/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.ui.v2.ftpexplorer.actions;

import com.biotechvana.commons.IFileTransferService;
import com.biotechvana.commons.ftpservice.IFTPManager;
import com.biotechvana.commons.ftpservice.IRemoteFile;
import com.biotechvana.ui.v2.ftpexplorer.FTPViewerComponent;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;

public class FTPUploadAction {
    public static final String TITLE = "Upload";
    private FTPViewerComponent ftpViewer;

    @CanExecute
    public boolean canExecute(IFTPManager ftpManager) {
        return ftpManager.isConnected();
    }

    @Execute
    public void run(FTPViewerComponent ftpViewer, IFileTransferService fileTransferService) {
        this.ftpViewer = ftpViewer;
        IRemoteFile[] selection = ftpViewer.getSelectedFiles();
        if (selection == null) {
            return;
        }
        IRemoteFile destination = selection[0];
        if (destination == null) {
            destination = ftpViewer.getFtpManager().getWorkingDirectory();
        }
        fileTransferService.uploadFilesTo(destination.getPath());
    }
}

