/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.ui.v2.ftpexplorer.actions;

import com.biotechvana.commons.ftpservice.IFTPManager;
import com.biotechvana.commons.ftpservice.IRemoteFile;
import com.biotechvana.ui.v2.ftpexplorer.FTPViewerComponent;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class FTPDeleteAction {
    public static final String TITLE = "New folder";

    @CanExecute
    public boolean canExecute(IFTPManager ftpManager) {
        return ftpManager.isConnected();
    }

    @Execute
    public void run(FTPViewerComponent ftpViewer) {
        if (!MessageDialog.openConfirm((Shell)ftpViewer.getShell(), (String)"Delete files", (String)"Continue deleting seleted files?")) {
            return;
        }
        IRemoteFile[] selection = ftpViewer.getSelectedFiles();
        if (selection == null || selection.length == 0) {
            return;
        }
        IRemoteFile[] iRemoteFileArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            IRemoteFile selected = iRemoteFileArray[n2];
            if (!selected.isParent() && !selected.isCWD()) {
                String path = selected.getPath();
                if (!ftpViewer.getFtpManager().delete(path)) {
                    MessageDialog.openError((Shell)ftpViewer.getShell(), (String)"FTP", (String)("Failed deleting file " + selected.getName()));
                }
            }
            ++n2;
        }
        try {
            ftpViewer.updateFTPList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

