/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.ui.v2.ftpexplorer;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.commons.ftpservice.IRemoteFile;
import com.biotechvana.ui.v2.ftpexplorer.FTPViewerContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Image;

public class FTPVLabelProvider
extends ColumnLabelProvider {
    public Image getImage(Object element) {
        if (element instanceof FTPViewerContentProvider.FTPErorr) {
            return SharedImages.ERROR;
        }
        IRemoteFile file = (IRemoteFile)element;
        if (file.isSymbolicLink()) {
            return SharedImages.FOLDERLINK;
        }
        if (file.isFolder()) {
            if (file.isCWD()) {
                return SharedImages.PROJECT;
            }
            if (file.isParent()) {
                return SharedImages.ARROWUP;
            }
            return SharedImages.FOLDER;
        }
        String filename = file.getName();
        if (filename.endsWith(".html") || filename.endsWith(".htm")) {
            return SharedImages.HTML;
        }
        if (filename.endsWith(".txt") || filename.endsWith(".fa") || filename.endsWith(".fasta") || filename.endsWith(".fastq") || filename.endsWith(".fq") || filename.endsWith(".xml")) {
            return SharedImages.FILE;
        }
        if (filename.endsWith(".doc") || filename.endsWith(".docx") || filename.endsWith(".rtf")) {
            return SharedImages.WORD;
        }
        if (filename.endsWith(".tgz") || filename.endsWith(".gz") || filename.endsWith(".zip") || filename.endsWith(".rar")) {
            return SharedImages.PACKAGE;
        }
        if (filename.endsWith(".csv") || filename.endsWith(".xls") || filename.endsWith(".xslx")) {
            return SharedImages.TABLE;
        }
        if (filename.endsWith(".pdf")) {
            return SharedImages.ACROBAT;
        }
        return SharedImages.DEFAULT;
    }

    public String getText(Object element) {
        if (element instanceof FTPViewerContentProvider.FTPErorr) {
            return ((FTPViewerContentProvider.FTPErorr)element).getMsg();
        }
        IRemoteFile file = (IRemoteFile)element;
        if (file.isParent()) {
            return "..";
        }
        if (file.isCWD()) {
            return ".";
        }
        return file.getName();
    }
}

