/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.ui.v2.ftpexplorer;

import com.biotechvana.commons.ftpservice.IFTPManager;
import com.biotechvana.commons.ftpservice.IRemoteFile;
import com.biotechvana.ui.v2.ftpexplorer.FTPViewerComponent;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class FTPSelectDialog
extends TitleAreaDialog {
    @Inject
    IFTPManager ftpManager;
    @Inject
    FTPViewerComponent ftpViewerComponent;
    private String selectedFile;

    public FTPSelectDialog() {
        super(null);
    }

    public FTPSelectDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(67696);
    }

    @PostConstruct
    public void setInit(@Named(value="activeShell") Shell activeShell) {
        this.setParentShell(activeShell);
        this.setShellStyle(67696);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialSize() {
        return new Point(400, 600);
    }

    public void create() {
        super.create();
        this.setTitle("Select Remote File/Folder");
        this.setMessage("Select Folder from Remote Host");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        composite.setBackground(composite.getDisplay().getSystemColor(13));
        Control tableControl = this.ftpViewerComponent.createPartControl(composite);
        gd = new GridData(1808);
        tableControl.setLayoutData((Object)gd);
        return composite;
    }

    protected void okPressed() {
        this.setErrorMessage(null);
        IRemoteFile[] selection = this.ftpViewerComponent.getSelectedFiles();
        if (selection == null || selection.length == 0) {
            try {
                String ftpRoot = this.ftpManager.getWorkingDirectory().getPath() + "/";
                this.selectedFile = ftpRoot.replaceAll("/{2,}", "/");
                super.okPressed();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                this.setErrorMessage("Please select a folder");
            }
            return;
        }
        IRemoteFile ftpFile = selection[0];
        if (ftpFile.getName().equals(".")) {
            return;
        }
        try {
            if (ftpFile.isFolder()) {
                this.selectedFile = ftpFile.getPath();
                super.okPressed();
            } else {
                this.setErrorMessage("Please select a folder");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            this.setErrorMessage("Please select a folder");
        }
    }

    public String getSelectedFile() {
        return this.selectedFile;
    }
}

