/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.gzip;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.compressed.CompressedFileFileObject;
import org.apache.commons.vfs2.provider.compressed.CompressedFileFileSystem;
import org.apache.commons.vfs2.provider.gzip.GzipFileSystem;

public class GzipFileObject
extends CompressedFileFileObject<GzipFileSystem> {
    @Deprecated
    protected GzipFileObject(AbstractFileName name, FileObject container, CompressedFileFileSystem fs) {
        super(name, container, GzipFileObject.cast(fs));
    }

    protected GzipFileObject(AbstractFileName name, FileObject container, GzipFileSystem fs) {
        super(name, container, fs);
    }

    @Override
    protected InputStream doGetInputStream(int bufferSize) throws Exception {
        return new GZIPInputStream(this.getContainer().getContent().getInputStream(), bufferSize);
    }

    @Override
    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        return new GZIPOutputStream(this.getContainer().getContent().getOutputStream(false));
    }

    private static GzipFileSystem cast(CompressedFileFileSystem fs) {
        if (fs instanceof GzipFileSystem) {
            return (GzipFileSystem)fs;
        }
        throw new IllegalArgumentException("GzipFileObject expects an instance of GzipFileSystem");
    }
}

