/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileFilter;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.filter.IOCase;

public class RegexFileFilter
implements FileFilter,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PATTERN_IS_MISSING = "Pattern is missing";
    private final Pattern pattern;

    public RegexFileFilter(Pattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(PATTERN_IS_MISSING);
        }
        this.pattern = pattern;
    }

    public RegexFileFilter(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(PATTERN_IS_MISSING);
        }
        this.pattern = Pattern.compile(pattern);
    }

    public RegexFileFilter(String pattern, int flags) {
        if (pattern == null) {
            throw new IllegalArgumentException(PATTERN_IS_MISSING);
        }
        this.pattern = Pattern.compile(pattern, flags);
    }

    public RegexFileFilter(String pattern, IOCase caseSensitivity) {
        if (pattern == null) {
            throw new IllegalArgumentException(PATTERN_IS_MISSING);
        }
        int flags = 0;
        if (caseSensitivity != null && !caseSensitivity.isCaseSensitive()) {
            flags = 2;
        }
        this.pattern = Pattern.compile(pattern, flags);
    }

    @Override
    public boolean accept(FileSelectInfo fileSelectInfo) {
        String name = fileSelectInfo.getFile().getName().getBaseName();
        return this.pattern.matcher(name).matches();
    }
}

