/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.variables;

import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.variables.JobVariable;
import java.util.Collection;

public class ListJobVariable
extends JobVariable {
    SelectionListVariableDescriptor desc;

    protected ListJobVariable(WorkflowJob containerJob, VariableDescriptor varDesc) {
        super(containerJob, varDesc);
        this.desc = (SelectionListVariableDescriptor)varDesc;
    }

    @Override
    protected String onGetBashVarDecleration() {
        Object str = "";
        String varName = this.getBashVarName();
        if (this.desc.getVarType() == VariableDescriptor.VariableType.SelectionList) {
            str = (String)str + "## Possible values are :- \n";
            for (String pValue : this.desc.getOptionsValues()) {
                str = (String)str + "## " + this.desc.getOptionValueCmdParamValue(pValue) + "\n";
            }
            str = (String)str + varName + "=\"" + this.desc.getOptionValueCmdParamValue(this.value) + "\" \n\n";
            return str;
        }
        return "";
    }

    @Override
    public String get_cmdValue() {
        return this.desc.getOptionValueCmdParamValue(this.value);
    }

    public int getDescpValueIndex(String value) {
        return this.desc.getOptionValueIndex(value);
    }

    public String getDescpValueCmdParamValue(String value) {
        return this.desc.getOptionValueCmdParamValue(value);
    }

    public String getDescDefaultValue() {
        return this.desc.getDefaultValue();
    }

    public String[] getDescHelpAvlOptions() {
        return this.desc.getHelpAvlOptions();
    }

    public String getDescHelpAvlOption(String pValue) {
        return this.desc.getHelpAvlOption(pValue);
    }

    public Collection<String> getDescpValues() {
        return this.desc.getOptionsValues();
    }

    public String getpValueCmdParamValue(String value) {
        return this.desc.getOptionValueCmdParamValue(value);
    }
}

