/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.template;

import com.biotechvana.workflow.IValidationResult;
import com.biotechvana.workflow.ValidationResult;
import com.biotechvana.workflow.Workflow;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.WorkflowMetadata;
import com.biotechvana.workflow.WorkflowObservable;
import com.biotechvana.workflow.WorkflowStartupJob;
import com.biotechvana.workflow.WorkflowValidationSet;
import com.biotechvana.workflow.manager.IWorkflowManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class WorkflowTemplate
extends WorkflowObservable {
    static boolean softChecking = true;
    public static final HashMap<Integer, String> errorCodeToMsg = new HashMap();
    public static final int ERR_WORKFLOWJOB_NOT_FOUND = 5000;
    public static final int ERR_JOBREF_NOT_FOUND = 5001;
    public static final int ERR_JOBVARIABLE_NOT_FOUND_TEMPLATE = 5002;
    public static final int ERR_VARIABLE_NOT_FOUND = 6000;
    public static final int ERR_MAPPING_NOT_VALID = 6001;
    WorkflowMetadata metadata = new WorkflowMetadata();
    HashMap<String, String> tasksIdToJobDescId = new HashMap();
    HashMap<String, Object[]> tasksInitParams = new HashMap();
    ArrayList<String> orderedTaskIds = new ArrayList();
    String startUpJobDescId;
    ArrayList<String> varMapFrom = new ArrayList();
    ArrayList<String> varMapTo = new ArrayList();
    ArrayList<String> declaredInputVar = new ArrayList();
    ArrayList<String> declaredOutputVar = new ArrayList();
    ArrayList<String> recommendationVarToSet = new ArrayList();
    HashMap<String, String> customVariableValues = new HashMap();
    HashMap<String, String> customVariableValuesCMDSwitch = new HashMap();
    HashMap<String, Boolean> customSetVariableState = new HashMap();
    String defaultName;

    static {
        errorCodeToMsg.put(5000, "Can not find Request Job %s in the Catalog");
        errorCodeToMsg.put(5001, "Can not find Request Job %s in the Catalog referenced by %s");
        errorCodeToMsg.put(5002, "Template does not have Job %s referenced by %s");
        errorCodeToMsg.put(6000, "Can not find Job Variable with id:%s in the Job:%s");
        errorCodeToMsg.put(6001, "Job Mapping from %s to %s is not valid.");
    }

    private static String getErrorMessage(int errorCode) {
        if (errorCodeToMsg.containsKey(errorCode)) {
            return errorCodeToMsg.get(errorCode);
        }
        return "";
    }

    public void addStarterTask(String jobDescId) {
        this.startUpJobDescId = jobDescId;
        this.addTask(jobDescId, jobDescId);
    }

    public void addStarterTask(String jobDescId, Object ... params) {
        this.startUpJobDescId = jobDescId;
        this.addTask(jobDescId, jobDescId, params);
    }

    public String getStarterTaskId() {
        return this.startUpJobDescId;
    }

    public void addTask(String jobDescId) {
        this.addTask(jobDescId, jobDescId);
    }

    public void addTask(String jobDescId, String taskCutsomTemplateId) {
        if (this.tasksIdToJobDescId.containsKey(taskCutsomTemplateId)) {
            int countTask = this.countTasksByCustomIdPrefix(taskCutsomTemplateId);
            String newCustomId = taskCutsomTemplateId + "_" + countTask;
            this.tasksIdToJobDescId.put(newCustomId, jobDescId);
            this.orderedTaskIds.add(newCustomId);
        } else {
            this.tasksIdToJobDescId.put(taskCutsomTemplateId, jobDescId);
            this.orderedTaskIds.add(taskCutsomTemplateId);
        }
    }

    public void addTask(String jobDescId, String taskCutsomTemplateId, Object ... params) {
        this.addTask(jobDescId, taskCutsomTemplateId);
        this.tasksInitParams.put(taskCutsomTemplateId, params);
    }

    private int countTasksByCustomIdPrefix(String taskCutsomTemplateId) {
        if (taskCutsomTemplateId == null) {
            return 0;
        }
        int count = 0;
        for (String value : this.tasksIdToJobDescId.values()) {
            if (!value.startsWith(taskCutsomTemplateId)) continue;
            ++count;
        }
        return count;
    }

    public void addMapping(String fromVar, String toVar) {
        this.varMapFrom.add(fromVar);
        this.varMapTo.add(toVar);
    }

    public void addMapping(String sourceTask, String sourceVar, String targetTask, String targetVar) {
        String fromVar = sourceTask + ":" + sourceVar;
        String toVar = targetTask + ":" + targetVar;
        this.varMapFrom.add(fromVar);
        this.varMapTo.add(toVar);
    }

    public void exposeInput(String varInput) {
        this.declaredInputVar.add(varInput);
    }

    public void exposeOutput(String varOutput) {
        this.declaredOutputVar.add(varOutput);
    }

    public void addRecommendation(String variableId) {
        this.declaredOutputVar.add(variableId);
    }

    public void addRecommendation(String variableId, String why) {
        this.declaredOutputVar.add(variableId);
    }

    public void setCustomVariableValue(String variableId, String value) {
        this.customVariableValues.put(variableId, value);
        this.customSetVariableState.put(variableId, false);
    }

    public void setCustomVariableValue(String jobId, String variableId, String value) {
        this.setCustomVariableValue(jobId + ":" + variableId, value);
    }

    public void setCustomVariableValue(String jobId, String variableId, String value, boolean locked) {
        this.setCustomVariableValue(jobId + ":" + variableId, value, locked);
    }

    public void setCustomVariableValue(String variableId, String value, boolean locked) {
        this.customVariableValues.put(variableId, value);
        this.customSetVariableState.put(variableId, locked);
    }

    public void setCustomVariableValueByCMDSwitch(String jobId, String cmdOption, String value) {
        this.customVariableValuesCMDSwitch.put(jobId + ":" + cmdOption, value);
        this.customSetVariableState.put(jobId + ":" + cmdOption, false);
    }

    public void setCustomVariableValueByCMDSwitch(String jobId, String cmdOption, String value, boolean locked) {
        this.customVariableValuesCMDSwitch.put(jobId + ":" + cmdOption, value);
        this.customSetVariableState.put(jobId + ":" + cmdOption, locked);
    }

    public WorkflowMetadata getMetadata() {
        return this.metadata;
    }

    public void setTemplateId(String templateId) {
        this.metadata.setTemplateId(templateId);
    }

    public String getTemplateId() {
        return this.metadata.getTemplateId();
    }

    public void setDefaultWorkflowName(String defaultName) {
        this.defaultName = defaultName;
    }

    public String getDefaultWorkflowName() {
        return this.defaultName;
    }

    public Collection<String> getTasksIds() {
        return (Collection)this.orderedTaskIds.clone();
    }

    public IValidationResult validate(IWorkflowManager workflowManager) {
        WorkflowValidationSet res = new WorkflowValidationSet();
        for (String taskId : this.tasksIdToJobDescId.values()) {
            if (workflowManager.getJobsCatalog().hasJobById(taskId)) continue;
            ValidationResult vRes = new ValidationResult(4, 5000, String.format(WorkflowTemplate.getErrorMessage(5000), taskId));
            res.add(vRes);
        }
        int i = 0;
        while (i < this.varMapFrom.size()) {
            String fromVar = this.varMapFrom.get(i);
            String toVar = this.varMapTo.get(i);
            if (!this.checkVariableExist(workflowManager, fromVar, res)) {
                vRes = new ValidationResult(softChecking ? 2 : 4, 6001, String.format(WorkflowTemplate.getErrorMessage(6001), fromVar, toVar));
                res.add(vRes);
            } else if (!this.checkVariableExist(workflowManager, toVar, res)) {
                vRes = new ValidationResult(softChecking ? 2 : 4, 6001, String.format(WorkflowTemplate.getErrorMessage(6001), fromVar, toVar));
                res.add(vRes);
            }
            ++i;
        }
        for (String variableId : this.customVariableValues.keySet()) {
            this.checkVariableExist(workflowManager, variableId, res);
        }
        for (String variableId : this.recommendationVarToSet) {
            this.checkVariableExist(workflowManager, variableId, res);
        }
        return res;
    }

    private boolean checkVariableExist(IWorkflowManager workflowManager, String variableName, WorkflowValidationSet res) {
        boolean didIFoundIt;
        boolean cont = true;
        String[] givenVars = variableName.split(":");
        int cfr_ignored_0 = givenVars.length;
        String taskID = givenVars[0];
        String varID = givenVars[1];
        if (!this.tasksIdToJobDescId.containsKey(taskID) && !(didIFoundIt = false)) {
            ValidationResult vRes = new ValidationResult(4, 5002, String.format(WorkflowTemplate.getErrorMessage(5002), taskID, variableName));
            res.add(vRes);
            return false;
        }
        String taskRefId = this.tasksIdToJobDescId.get(taskID);
        try {
            WorkflowJob refJob = workflowManager.getJobsCatalog().createJobInstanceById(taskRefId, new Object[0]);
            if (!refJob.hasVariable(varID)) {
                ValidationResult vRes = new ValidationResult(softChecking ? 2 : 4, 6000, String.format(WorkflowTemplate.getErrorMessage(6000), varID, taskRefId));
                res.add(vRes);
                return false;
            }
        }
        catch (Exception e) {
            ValidationResult vRes = new ValidationResult(4, 5000, String.format(WorkflowTemplate.getErrorMessage(5000), taskRefId));
            res.add(vRes);
            return false;
        }
        return true;
    }

    public void saveToFile(String fileName) throws IOException {
        Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().create();
        BufferedWriter br = new BufferedWriter(new FileWriter(fileName));
        br.write(gson.toJson((Object)this));
        br.close();
    }

    public static WorkflowTemplate loadFromFile(String fileName) throws IOException {
        String line;
        Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().create();
        Object allFile = "";
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        while ((line = br.readLine()) != null) {
            allFile = (String)allFile + line;
        }
        return (WorkflowTemplate)gson.fromJson((String)allFile, WorkflowTemplate.class);
    }

    private WorkflowJob createJob(IWorkflowManager workflowManager, String jobDescId) {
        WorkflowJob newJob = null;
        if (this.tasksInitParams.containsKey(jobDescId)) {
            Object[] param = this.tasksInitParams.get(jobDescId);
            newJob = workflowManager.getJobsCatalog().createJobInstanceById(jobDescId, param);
        } else {
            newJob = workflowManager.getJobsCatalog().createJobInstanceById(jobDescId, new Object[0]);
        }
        return newJob;
    }

    public Workflow createWorkflow(IWorkflowManager workflowManager) {
        try {
            String taskID;
            String[] givenVars;
            String value;
            WorkflowStartupJob startupJob = (WorkflowStartupJob)this.createJob(workflowManager, this.getStarterTaskId());
            Workflow workflow = new Workflow(startupJob);
            WorkflowMetadata metaData = (WorkflowMetadata)this.getMetadata().clone();
            workflow.setMetadata(metaData);
            workflow.setWorkflowId(this.getDefaultWorkflowName());
            workflow.setWorkflowName(this.getDefaultWorkflowName());
            for (String customTaskId : this.orderedTaskIds) {
                String taskId = this.tasksIdToJobDescId.get(customTaskId);
                if (taskId.equals(this.getStarterTaskId())) continue;
                WorkflowJob newJob = workflowManager.getJobsCatalog().createJobInstanceById(taskId, new Object[0]);
                newJob.setJobId(customTaskId);
                workflow.addJob(newJob);
            }
            int i = 0;
            while (i < this.varMapFrom.size()) {
                String fromVar = this.varMapFrom.get(i);
                String toVar = this.varMapTo.get(i);
                workflow.addMapping(fromVar, toVar);
                ++i;
            }
            for (String varKey : this.customVariableValues.keySet()) {
                value = this.customVariableValues.get(varKey);
                boolean isLocked = false;
                if (this.customSetVariableState.containsKey(varKey)) {
                    isLocked = this.customSetVariableState.get(varKey);
                }
                givenVars = varKey.split(":");
                int cfr_ignored_0 = givenVars.length;
                taskID = givenVars[0];
                String varID = givenVars[1];
                workflow.getJobById(taskID).setValue(varID, value);
                if (!isLocked) continue;
                workflow.getJobById(taskID).getJobDesc().getVariableDescById(varID).setReadOnly(true);
            }
            for (String varKey : this.customVariableValuesCMDSwitch.keySet()) {
                value = this.customVariableValuesCMDSwitch.get(varKey);
                boolean isLocked = false;
                if (this.customSetVariableState.containsKey(varKey)) {
                    isLocked = this.customSetVariableState.get(varKey);
                }
                givenVars = varKey.split(":");
                int cfr_ignored_1 = givenVars.length;
                taskID = givenVars[0];
                String cmdSwitch = givenVars[1];
                workflow.getJobById(taskID).setValueByCMDSwitch(cmdSwitch, value);
                if (!isLocked) continue;
                workflow.getJobById(taskID).getJobDesc().getVariableDescByCMDSwitch(cmdSwitch).setReadOnly(true);
            }
            return workflow;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return null;
        }
    }
}

