/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.executer;

import com.biotechvana.workflow.Tracking;
import com.biotechvana.workflow.executer.BashBlock;
import com.biotechvana.workflow.executer.BashBlockBase;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FileVariable;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;
import java.util.ArrayList;

public class CMLTemplate
extends BashBlockBase {
    BashBlock after;
    BashBlock before;
    private String interpreter;
    private String binPath = "${gpro_bin}";
    String baseCommand;
    String subCommand;
    String CMLName;
    String filesToTrackVarName = "__tempInFile";
    String processShmExitCodeVarName = "shm_process_code";
    ArrayList<Object> cmlArgs = new ArrayList();
    protected boolean batchMode = true;
    Object trackedInputVariable;
    String stdForward = null;

    public CMLTemplate() {
        this.after = new BashBlock();
        this.before = new BashBlock();
        this.after.setParent(this);
        this.before.setParent(this);
        this.internalIndetLevels = 1;
    }

    public CMLTemplate setBaseCommand(String baseCommand) {
        this.baseCommand = baseCommand;
        String[] parts = baseCommand.split("/");
        this.CMLName = parts[parts.length - 1];
        if (this.CMLName.contains(".")) {
            this.CMLName = this.CMLName.split("\\.")[0];
        }
        return this;
    }

    public CMLTemplate setSubCommand(String subCommand) {
        this.subCommand = subCommand;
        return this;
    }

    public CMLTemplate addArgs(String optionParamatersStrAs$) {
        this.cmlArgs.add(optionParamatersStrAs$);
        return this;
    }

    public CMLTemplate addArgs(JobVariable var) {
        this.cmlArgs.add(var);
        return this;
    }

    @Override
    public void generate(StringBuilder builder) {
        String indent = this.getIndent();
        String indentL1 = indent + this.getLocalIndent(1);
        Object commandLineStr = this.baseCommand + " ";
        if (this.interpreter != null) {
            commandLineStr = this.interpreter;
            commandLineStr = this.getBinPath() != null ? this.interpreter + " " + this.getBinPath() + "/" + this.baseCommand + " " : this.interpreter + " " + this.baseCommand + " ";
        }
        String subProg = this.baseCommand + " ";
        if (this.subCommand != null && !this.subCommand.isEmpty()) {
            commandLineStr = (String)commandLineStr + this.subCommand + " ";
            subProg = subProg + this.subCommand + " ";
        }
        for (Object arg : this.cmlArgs) {
            if (arg instanceof String) {
                commandLineStr = (String)commandLineStr + arg.toString() + " ";
            }
            if (!(arg instanceof JobVariable)) continue;
            commandLineStr = arg instanceof FilesVariable ? (String)commandLineStr + ((JobVariable)arg).$("${_i}") + " " : (arg instanceof FileVariable ? (String)commandLineStr + ((JobVariable)arg).$() + " " : (String)commandLineStr + ((JobVariable)arg).$() + " ");
        }
        commandLineStr = ((String)commandLineStr).strip();
        if (this.stdForward != null) {
            commandLineStr = (String)commandLineStr + " > " + this.stdForward;
        }
        this.before.generate(builder);
        String filesToTrack = CMLTemplate.$(this.filesToTrackVarName);
        if (this.trackedInputVariable != null) {
            if (this.trackedInputVariable instanceof FilesVariable) {
                builder.append(indent + CMLTemplate.st(BashHelper.assign(this.filesToTrackVarName, BashHelper.hlpArrAppend((JobVariable)this.trackedInputVariable, ","))));
            } else if (this.trackedInputVariable instanceof JobVariable) {
                builder.append(indent + CMLTemplate.st(BashHelper.assign(this.filesToTrackVarName, ((JobVariable)this.trackedInputVariable).$())));
            } else if (this.trackedInputVariable instanceof String) {
                builder.append(indent + CMLTemplate.st(BashHelper.assign(this.filesToTrackVarName, (String)this.trackedInputVariable)));
            }
        }
        builder.append(indent + Tracking.trackProcessing(filesToTrack, subProg));
        builder.append(indent + "{\n");
        builder.append(indent + CMLTemplate.st("echo \"################### Executing CMD #####################\" "));
        builder.append(indent + CMLTemplate.st("echo \"" + (String)commandLineStr + "\" "));
        builder.append(indent + CMLTemplate.st("echo \"#######################################################\""));
        if (this.batchMode) {
            builder.append(BashHelper.injectTraping((String)commandLineStr, indentL1, "${" + this.getProcessShmExitCodeVarName() + "}") + "\n");
        } else {
            builder.append(BashHelper.injectTraping((String)commandLineStr, indentL1, "${" + this.getTaskStatusVarName() + "}") + "\n");
        }
        builder.append("\n" + indent + "} && ( ");
        builder.append(Tracking.trackProcessed(filesToTrack, subProg));
        if (this.batchMode) {
            builder.append(indent + ") || ( " + Tracking.trackProcessedFail(filesToTrack));
            builder.append(indent + ")\n");
        } else {
            builder.append(indent + ") || { \n" + Tracking.trackProcessedFail(filesToTrack, subProg) + "\n" + BashHelper.assign("_g_job_exec_status", Tracking.TrackEndStatus.Failed.toString()));
            builder.append("\n" + indent + "}\n");
        }
        this.after.generate(builder);
    }

    public String getTaskStatusVarName() {
        return this.getTaskCleanName() + "_status";
    }

    public String getFinalTaskStatusVarName() {
        if (this.batchMode) {
            return this.getTaskStatusVarName() + "_all";
        }
        return this.getTaskStatusVarName();
    }

    public String getTaskCleanName() {
        Object name = this.CMLName;
        if (this.subCommand != null) {
            name = this.CMLName + "_" + this.subCommand;
        }
        return name;
    }

    public void setBatchMode(boolean b) {
        this.batchMode = b;
    }

    public String getProcessShmExitCodeVarName() {
        return this.processShmExitCodeVarName;
    }

    public BashBlock getAfter() {
        return this.after;
    }

    public BashBlock getBefore() {
        return this.before;
    }

    public String getInterpreter() {
        return this.interpreter;
    }

    public void setInterpreter(String interpreter) {
        this.interpreter = interpreter;
    }

    public String getBinPath() {
        return this.binPath;
    }

    public void setBinPath(String binPath) {
        this.binPath = binPath;
    }

    public CMLTemplate setTrackInput(JobVariable variable) {
        this.filesToTrackVarName = variable.getBashVarName();
        return this;
    }

    public CMLTemplate setTrackInput(String var_str) {
        this.trackedInputVariable = var_str;
        return this;
    }

    public CMLTemplate forward(String stdForward) {
        this.stdForward = stdForward;
        return this;
    }
}

