/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.configuration;

import com.biotechvana.utils.StringUtils;
import com.biotechvana.workflow.ValidationResult;
import com.biotechvana.workflow.WorkflowValidationSet;
import com.biotechvana.workflow.configuration.IPipelineConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public abstract class ConfigurationParser {
    protected boolean isPairEnd = false;
    String[] lines;
    protected int lineIndex = 0;
    int numberOfLines = 0;
    protected int parseState = 0;
    public static String CONFIG_VARNAME_INPUT_FORMAT = "input_format";
    public static String CONFIG_VARNAME_MIN_INSERT = "min_insert";
    public static String CONFIG_VARNAME_MAX_INSERT = "max_insert";
    public static String CONFIG_VARNAME_MATE_INNER_DIST = "mate_inner_dist";
    public static String CONFIG_VARNAME_MATE_STD_DEV = "mate_std_dev";
    public static String CONFIG_VARNAME_ALIGNMENT_PAIRS_ORIENTATION = "alignment_pairs_orientation";
    public static final String CONFIG_VARNAME_FILTER_Q = "Q";
    public static final String CONFIG_VARNAME_FILTER_QP = "QP";
    public static final String CONFIG_VARNAME_ADAPTER_5AD = "5AD";
    public static final String CONFIG_VARNAME_ADAPTER_3AD = "3AD";
    public static final String CONFIG_VARNAME_ADAPTER_53AD = "53AD";
    public static final String CONFIG_VARNAME_PREPROCESS_MIN_LEN = "MIN";
    public static final String CONFIG_VARNAME_PREPROCESS_MAX_LEN = "MAX";
    public static final String CONFIG_VARNAME_PREPROCESS_FILTER_PR = "PR";
    public static final String CONFIG_VARNAME_MAPPING_FILTER_RM = "RM";
    static HashMap<String, ConfigVariable> CONFIG_Variables = new HashMap();
    protected HashMap<String, DefinedVariable> definedVariables = new HashMap();
    private static final String PARSE_PAIR_END = "PAIR END LIBRARY";
    private static final String PARSE_SINGLE_END = "SINGLE END LIBRARY";
    private static final int PARSE_ERR_NO_LINRARY_TYPE = -1;
    private static final int PARSE_ERR_NO_ = -2;
    private static final int PARSE_ERR_UNEXP_END = -100;
    private static final int PARSE_ERR_NO_FILES_FORMAT = -102;
    private static final int PARSE_ERR_FILES_LIST = -103;
    private static final int PARSE_ERR_NO_FILE = -104;
    private static final int PARSE_ERR_ACC_FILE = -105;
    private static final int PARSE_ERR_NO_AlgOrientation = -110;
    private static final int PARSE_ERR_NO_INPUT_FILES = -120;
    private static final int PARSE_ERR_PAIR_FILES_LIST = -160;
    private static final int PARSE_ERR_SINGLE_FILES_LIST = -170;
    private static final int PARSE_ERR_PROPERTY_ASSIGN = -180;
    private static final int PARSE_ERR_PAIR_FILE_NAME_MISMATCH = -190;
    protected static final int PARSE_SUCCESS = 0;
    private static final String PARSE_SWITCH_INPUT_FILES = "input files";
    private static final String PARSE_SWITCH_FILTERS = "filter rules";
    private static final String PARSE_SWITCH_OPTIONS = "options";
    private static final String PARSE_FILES_SELECTOR_F1 = "f1=";
    private static final String PARSE_FILES_SELECTOR_F2 = "f2=";
    private static final String COMMENT_SYMBOL = "@";
    protected String customErrMsg = "";
    protected String fileFormat = "fastq";
    protected ArrayList<String> library = new ArrayList();
    protected ArrayList<String> f1 = new ArrayList();
    protected ArrayList<String> f2 = new ArrayList();

    static {
        CONFIG_Variables.put(CONFIG_VARNAME_INPUT_FORMAT, new ConfigVariable(){
            {
                this.configName = CONFIG_VARNAME_INPUT_FORMAT;
                this.jobsMapping = "";
                this.type = String.class;
                this.defaultValue = "fastq";
            }
        });
        CONFIG_Variables.put(CONFIG_VARNAME_MIN_INSERT, new ConfigVariable(){
            {
                this.configName = CONFIG_VARNAME_MIN_INSERT;
                this.jobsMapping = "";
            }
        });
        CONFIG_Variables.put(CONFIG_VARNAME_MAX_INSERT, new ConfigVariable(){
            {
                this.configName = CONFIG_VARNAME_MAX_INSERT;
                this.jobsMapping = "";
            }
        });
        CONFIG_Variables.put(CONFIG_VARNAME_MATE_INNER_DIST, new ConfigVariable(){
            {
                this.configName = CONFIG_VARNAME_MATE_INNER_DIST;
                this.jobsMapping = "";
            }
        });
        CONFIG_Variables.put(CONFIG_VARNAME_MATE_STD_DEV, new ConfigVariable(){
            {
                this.configName = CONFIG_VARNAME_MATE_STD_DEV;
                this.jobsMapping = "";
            }
        });
        CONFIG_Variables.put(CONFIG_VARNAME_ALIGNMENT_PAIRS_ORIENTATION, new ConfigVariable(){
            {
                this.configName = CONFIG_VARNAME_ALIGNMENT_PAIRS_ORIENTATION;
                this.jobsMapping = "";
            }
        });
        CONFIG_Variables.put(CONFIG_VARNAME_FILTER_Q, new ConfigVariable(){
            {
                this.configName = ConfigurationParser.CONFIG_VARNAME_FILTER_Q;
                this.jobsMapping = "";
            }
        });
        CONFIG_Variables.put(CONFIG_VARNAME_FILTER_QP, new ConfigVariable(){
            {
                this.configName = ConfigurationParser.CONFIG_VARNAME_FILTER_QP;
                this.jobsMapping = "";
            }
        });
        CONFIG_Variables.put(CONFIG_VARNAME_ADAPTER_5AD, new ConfigVariable(){
            {
                this.configName = ConfigurationParser.CONFIG_VARNAME_ADAPTER_5AD;
                this.jobsMapping = "";
            }
        });
        CONFIG_Variables.put(CONFIG_VARNAME_ADAPTER_53AD, new ConfigVariable(){
            {
                this.configName = ConfigurationParser.CONFIG_VARNAME_ADAPTER_53AD;
                this.jobsMapping = "";
            }
        });
        CONFIG_Variables.put(CONFIG_VARNAME_ADAPTER_3AD, new ConfigVariable(){
            {
                this.configName = ConfigurationParser.CONFIG_VARNAME_ADAPTER_3AD;
                this.jobsMapping = "";
            }
        });
    }

    protected void setConfigurationFile(String configurationFile) {
        File inputFile = new File(configurationFile);
        String configurationTxt = "";
        this.customErrMsg = "";
        try {
            FileInputStream inStream = new FileInputStream(inputFile);
            configurationTxt = IOUtils.toString((InputStream)inStream, (String)"UTF-8");
            this.lines = configurationTxt.split("\n");
            this.numberOfLines = this.lines.length;
            int i = 0;
            while (i < this.lines.length) {
                if (this.lines[i] != null) {
                    this.lines[i] = this.lines[i].trim();
                }
                ++i;
            }
            this.parseState = this.parseConfigurationFile();
        }
        catch (FileNotFoundException e1) {
            this.parseState = -104;
            e1.printStackTrace();
        }
        catch (IOException e) {
            this.parseState = -105;
            e.printStackTrace();
        }
    }

    public final ValidationResult getParseState() {
        if (this.parseState != 0) {
            WorkflowValidationSet res = new WorkflowValidationSet(4, this.parseState, "Error Parsing File at Line " + this.lineIndex + ". ");
            this.onGetParseState(res);
            switch (this.parseState) {
                case -105: {
                    res.appendMessage("Error Parsing File. File Not found or can not access the provided file.");
                    break;
                }
                case -103: {
                    res.appendMessage("Could not find Files List in the provided file.");
                    break;
                }
                case -104: {
                    res.appendMessage("Error Parsing File. File Not found or can not access the provided file.");
                    break;
                }
                case -102: {
                    res.appendMessage("Could not find input file format in the provided file.");
                    break;
                }
                case -1: {
                    res.appendMessage("Could not find input library type in the provided file.");
                    break;
                }
                case -110: {
                    res.appendMessage("Could not find alignment pairs orientation or unrecognized token. Allowed orientations fr/rf/ff/. Where fr  (forward-reverse), rf (reverse forward) and ff (forward-forward)");
                    break;
                }
                case -160: {
                    res.appendMessage("Could not parse pair file list.");
                    break;
                }
                case -190: {
                    res.appendMessage("Could not infer library name for file pair.");
                    break;
                }
                case -120: {
                    res.appendMessage("Error Parse or Could not find input files section.");
                    break;
                }
                default: {
                    res.appendMessage("Unexpected Line found in the provided file.");
                }
            }
            if (!this.customErrMsg.isEmpty()) {
                res.appendMessage(" " + this.customErrMsg);
            }
            return res;
        }
        return ValidationResult.Valid_RESULT;
    }

    protected abstract void onGetParseState(ValidationResult var1);

    public abstract ValidationResult setupExperimentConfiguration(IPipelineConfiguration var1);

    protected String getDefinedValueOrDefault(String configVarName) {
        String varValue = null;
        if (this.definedVariables.containsKey(configVarName)) {
            varValue = this.definedVariables.get((Object)configVarName).value;
        } else if (CONFIG_Variables.containsKey(configVarName) && ConfigurationParser.CONFIG_Variables.get((Object)configVarName).defaultValue != null) {
            varValue = ConfigurationParser.CONFIG_Variables.get((Object)configVarName).defaultValue;
        }
        return varValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int parseConfigurationFile() {
        this.skipEmptyLines();
        if (this.lineIndex >= this.numberOfLines) return -1;
        String libraryType = this.lines[this.lineIndex];
        ++this.lineIndex;
        if (libraryType.equals(PARSE_PAIR_END)) {
            this.isPairEnd = true;
        } else {
            if (!libraryType.equals(PARSE_SINGLE_END)) return -1;
            this.isPairEnd = false;
        }
        System.out.println("Found type continue rest of file " + libraryType);
        String currentBlockSwitch = "";
        HashMap<String, Block> allBlocks = new HashMap<String, Block>();
        while (this.lineIndex < this.numberOfLines) {
            String currentInputLine = this.lines[this.lineIndex];
            currentInputLine = this.preprocessLine(currentInputLine);
            ++this.lineIndex;
            if (currentInputLine.isEmpty()) continue;
            if (this.isSwitchLine(currentInputLine)) {
                Block newBlock;
                if (currentBlockSwitch.isEmpty()) {
                    currentBlockSwitch = this.getSwitchKeyWord(currentInputLine);
                    newBlock = new Block();
                    newBlock.blockName = currentBlockSwitch;
                    allBlocks.put(currentBlockSwitch, newBlock);
                }
                if (this.matchSwitch(currentInputLine, currentBlockSwitch)) continue;
                currentBlockSwitch = this.getSwitchKeyWord(currentInputLine);
                newBlock = new Block();
                newBlock.blockName = currentBlockSwitch;
                allBlocks.put(currentBlockSwitch, newBlock);
                continue;
            }
            if (allBlocks.containsKey(currentBlockSwitch)) {
                allBlocks.get(currentBlockSwitch).addLine(this.lineIndex, currentInputLine);
                continue;
            }
            System.out.println("Unknow configuration line : " + currentInputLine);
        }
        return this.parseBlocks(allBlocks);
    }

    private final int parseBlocks(HashMap<String, Block> allBlocks) {
        int retCode = 0;
        if (allBlocks.containsKey(this.getSwitchKeyWord(PARSE_SWITCH_INPUT_FILES))) {
            System.out.println("Found INPUT_FILES Section : ");
            this.sysPrintBlock(allBlocks.get(this.getSwitchKeyWord(PARSE_SWITCH_INPUT_FILES)));
            retCode = this.parseFilesListBlock(allBlocks.get(this.getSwitchKeyWord(PARSE_SWITCH_INPUT_FILES)));
            if (retCode != 0) {
                return retCode;
            }
        } else {
            return -120;
        }
        retCode = this.onParseBlocks(allBlocks);
        if (retCode != 0) {
            return retCode;
        }
        if (allBlocks.containsKey(this.getSwitchKeyWord(PARSE_SWITCH_FILTERS))) {
            Block fitlerBlock = allBlocks.get(this.getSwitchKeyWord(PARSE_SWITCH_FILTERS));
            System.out.println("Found FILTERS Section : ");
            this.sysPrintBlock(fitlerBlock);
            retCode = this.feedProperties(fitlerBlock);
            if (retCode != 0) {
                return retCode;
            }
        }
        if (allBlocks.containsKey(this.getSwitchKeyWord(PARSE_SWITCH_OPTIONS))) {
            Block optionsBlock = allBlocks.get(this.getSwitchKeyWord(PARSE_SWITCH_OPTIONS));
            System.out.println("Found OPTIONS Section : ");
            this.sysPrintBlock(optionsBlock);
            retCode = this.feedProperties(optionsBlock);
            if (retCode != 0) {
                return retCode;
            }
        }
        System.out.println("All Defined Variables ");
        for (DefinedVariable var : this.definedVariables.values()) {
            System.out.println("Var : " + var.configVarName + " = " + var.value + " : defined in " + var.configSection);
        }
        return 0;
    }

    protected abstract int onParseBlocks(HashMap<String, Block> var1);

    protected void sysPrintBlock(Block block) {
        System.out.println("Block : " + block.blockName);
        int i = 0;
        while (i < block.lines.size()) {
            System.out.println("Line : " + String.valueOf(block.linesIndex.get(i)) + "\t [ " + block.lines.get(i) + " ] ");
            ++i;
        }
        System.out.println("-Block END-\n\n");
    }

    private int feedProperties(Block block) {
        int i = 0;
        while (i < block.getNumberOflines()) {
            this.lineIndex = block.linesIndex.get(i);
            String line = block.lines.get(i);
            String[] tokens = ConfigurationParser.getTokens(line, "=");
            if (tokens.length != 2) {
                return -180;
            }
            if (this.definedVariables.containsKey(tokens[0].trim())) {
                this.definedVariables.get((Object)tokens[0].trim()).value = String.valueOf(this.definedVariables.get((Object)tokens[0].trim()).value) + "\n" + tokens[1].trim();
            } else {
                DefinedVariable variable = new DefinedVariable(this, block, tokens){
                    {
                        this.configSection = block.blockName;
                        this.configVarName = stringArray[0].trim();
                        this.value = stringArray[1].trim();
                    }
                };
                this.definedVariables.put(variable.configVarName, variable);
            }
            ++i;
        }
        return 0;
    }

    private String preprocessLine(String inputSwitchLine) {
        int loc = inputSwitchLine.indexOf(COMMENT_SYMBOL);
        if (loc == -1) {
            return inputSwitchLine.trim();
        }
        if (loc == 0) {
            return "";
        }
        String nonCommentPart = inputSwitchLine.substring(0, loc);
        return nonCommentPart.trim();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int parseFilesListBlock(Block inputBlock) {
        try {
            int i = 0;
            while (i < inputBlock.getNumberOflines()) {
                this.lineIndex = inputBlock.linesIndex.get(i);
                String line = inputBlock.lines.get(i);
                if (this.isPairEnd) {
                    String line1 = line;
                    if (++i >= inputBlock.getNumberOflines()) {
                        this.customErrMsg = "can not find file pair for " + this.getFileNameFromLine(line1);
                        return -160;
                    }
                    String line2 = inputBlock.lines.get(i);
                    ++this.lineIndex;
                    if (!line1.startsWith(PARSE_FILES_SELECTOR_F1)) return -160;
                    if (!line2.startsWith(PARSE_FILES_SELECTOR_F2)) return -160;
                    String firstFile = this.getFileNameFromLine(line1);
                    String secondFile = this.getFileNameFromLine(line2);
                    if (firstFile.isEmpty()) return -160;
                    if (secondFile.isEmpty()) return -160;
                    int returnCode = this.addFilePair(firstFile, secondFile);
                    if (returnCode != 0) {
                        return returnCode;
                    }
                } else {
                    if (!line.startsWith(PARSE_FILES_SELECTOR_F1)) return -170;
                    String firstFile = this.getFileNameFromLine(line);
                    int returnCode = this.addSingleFile(firstFile);
                    if (returnCode != 0) {
                        return returnCode;
                    }
                }
                ++i;
            }
            System.out.println("Number of items in Library : " + this.library.size());
            System.out.println("Number of items in F1 : " + this.f1.size());
            System.out.println("Number of items in F2 (Paired) : " + this.f2.size());
            i = 0;
            while (i < this.library.size()) {
                if (this.isPairEnd) {
                    System.out.println("Library : " + this.library.get(i) + " has " + this.f1.get(i) + " , " + this.f2.get(i));
                } else {
                    System.out.println("Library : " + this.library.get(i) + " has " + this.f1.get(i));
                }
                ++i;
            }
            return 0;
        }
        catch (Exception ex) {
            if (!this.isPairEnd) return -170;
            return -160;
        }
    }

    private int addSingleFile(String firstFile) {
        this.f1.add(firstFile);
        return 0;
    }

    private int addFilePair(String firstFile, String secondFile) {
        this.f1.add(firstFile);
        this.f2.add(secondFile);
        return 0;
    }

    private int inferLibarayNamePairEnd() {
        String fileNameRev;
        ArrayList<String> f1rev = new ArrayList<String>();
        ArrayList<String> f2rev = new ArrayList<String>();
        ArrayList<String> allList = new ArrayList<String>();
        allList.addAll(this.f1);
        allList.addAll(this.f2);
        for (String fileName : this.f1) {
            fileNameRev = StringUtils.reverse((String)FilenameUtils.getBaseName((String)fileName));
            f1rev.add(fileNameRev);
        }
        for (String fileName : this.f2) {
            fileNameRev = StringUtils.reverse((String)FilenameUtils.getBaseName((String)fileName));
            f2rev.add(fileNameRev);
        }
        int commonPrefixLCI = this.longestCommonStr(allList);
        int commonPostfixF1LCI = this.longestCommonStr(f1rev);
        int commonPostfixF2LCI = this.longestCommonStr(f2rev);
        System.out.println("Common prefix is  " + allList.get(0).substring(0, commonPrefixLCI + 1));
        System.out.println("Common prefix is  " + f1rev.get(0).substring(0, commonPostfixF1LCI + 1));
        System.out.println("Common prefix is  " + f2rev.get(0).substring(0, commonPostfixF2LCI + 1));
        String f1_postfix = StringUtils.reverse((String)f1rev.get(0).substring(0, commonPostfixF1LCI + 1));
        String f2_postfix = StringUtils.reverse((String)f2rev.get(0).substring(0, commonPostfixF2LCI + 1));
        int i = 0;
        while (i < this.f1.size()) {
            String f2preFixName;
            String f1Name = FilenameUtils.getBaseName((String)this.f1.get(i));
            String f2Name = FilenameUtils.getBaseName((String)this.f2.get(i));
            String f1preFixName = f1Name.substring(0, f1Name.indexOf(f1_postfix));
            if (!f1preFixName.equals(f2preFixName = f2Name.substring(0, f2Name.indexOf(f2_postfix)))) {
                this.customErrMsg = " Pair file name dose not match its libray name ( " + f1Name + "," + f2Name + " ) ";
                return -190;
            }
            this.library.add(f1preFixName);
            ++i;
        }
        return 0;
    }

    private int inferLibarayNameSingleEnd() {
        ArrayList<String> f1rev = new ArrayList<String>();
        for (String fileName : this.f1) {
            String fileNameRev = StringUtils.reverse((String)FilenameUtils.getBaseName((String)fileName));
            f1rev.add(fileNameRev);
        }
        int commonPostfixF1LCI = this.longestCommonStr(f1rev);
        System.out.println("Common postfix is  " + f1rev.get(0).substring(0, commonPostfixF1LCI + 1));
        String f1_postfix = StringUtils.reverse((String)f1rev.get(0).substring(0, commonPostfixF1LCI + 1));
        int i = 0;
        while (i < this.f1.size()) {
            String f1Name = FilenameUtils.getBaseName((String)this.f1.get(i));
            String f1preFixName = f1Name.substring(0, f1Name.indexOf(f1_postfix));
            this.library.add(f1preFixName);
            ++i;
        }
        return 0;
    }

    protected String getPostfix(ArrayList<String> f1) {
        ArrayList<String> f1rev = new ArrayList<String>();
        for (String fileName : f1) {
            String fileNameRev = StringUtils.reverse((String)FilenameUtils.getBaseName((String)fileName));
            f1rev.add(fileNameRev);
        }
        int commonPostfixF1LCI = this.longestCommonStr(f1rev);
        String f1_postfix = StringUtils.reverse((String)f1rev.get(0).substring(0, commonPostfixF1LCI + 1));
        return f1_postfix;
    }

    protected static int findMap(String key, ArrayList<String> list) {
        int index = -1;
        int i = 0;
        while (i < list.size()) {
            if (list.get(i).startsWith(key)) {
                if (index == -1) {
                    index = i;
                } else {
                    return -2;
                }
            }
            ++i;
        }
        return index;
    }

    private int longestCommonStr(ArrayList<String> strList) {
        int lcIndex = 0;
        String firstStr = strList.get(0);
        while (true) {
            boolean currentRound = true;
            for (String str : strList) {
                if (lcIndex > str.length()) {
                    currentRound = false;
                }
                if (str.charAt(lcIndex) == firstStr.charAt(lcIndex)) continue;
                currentRound = false;
            }
            if (!currentRound) break;
            ++lcIndex;
        }
        return lcIndex - 1;
    }

    private String getFileNameFromLine(String line) {
        String[] lineTokens = ConfigurationParser.getTokens(line, "=");
        if (lineTokens.length == 2) {
            return lineTokens[1];
        }
        return "";
    }

    boolean isSwitchLine(String inputSwitchLine) {
        return inputSwitchLine.startsWith("#");
    }

    protected static String[] getTokens(String inputLine, String tokenizer) {
        String[] lineTokens = inputLine.split(tokenizer);
        int i = 0;
        while (i < lineTokens.length) {
            lineTokens[i] = lineTokens[i].trim();
            ++i;
        }
        return lineTokens;
    }

    boolean matchSwitch(String switchLine, String inputLine) {
        switchLine = switchLine.toLowerCase();
        inputLine = inputLine.toLowerCase();
        String spliters = "(\\s+)|(#)|(\\[.*\\])|(\\(.*\\))";
        String[] switchLineTokens = switchLine.split(spliters);
        Object switchLineCons = "";
        String[] stringArray = switchLineTokens;
        int n = switchLineTokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (!(token = token.trim()).equalsIgnoreCase("a") && !token.equalsIgnoreCase("the")) {
                switchLineCons = (String)switchLineCons + token;
            }
            ++n2;
        }
        String[] inputLineTokens = inputLine.split(spliters);
        Object inputLineCons = "";
        String[] stringArray2 = inputLineTokens;
        int n3 = inputLineTokens.length;
        int n4 = 0;
        while (n4 < n3) {
            String token = stringArray2[n4];
            if (!(token = token.trim()).equalsIgnoreCase("a") && !token.equalsIgnoreCase("the")) {
                inputLineCons = (String)inputLineCons + token;
            }
            ++n4;
        }
        return ((String)inputLineCons).equalsIgnoreCase((String)switchLineCons);
    }

    protected String getSwitchKeyWord(String switchLine) {
        switchLine = switchLine.toLowerCase();
        String spliters = "(\\s+)|(#)|(\\[.*\\])|(\\(.*\\))";
        String[] switchLineTokens = switchLine.split(spliters);
        Object switchLineCons = "";
        String[] stringArray = switchLineTokens;
        int n = switchLineTokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (!(token = token.trim()).equalsIgnoreCase("a") && !token.equalsIgnoreCase("the")) {
                switchLineCons = (String)switchLineCons + token;
            }
            ++n2;
        }
        return switchLineCons;
    }

    int skipEmptyLines() {
        while (this.lineIndex < this.numberOfLines) {
            if (this.lines[this.lineIndex].isEmpty()) {
                ++this.lineIndex;
                continue;
            }
            return this.lineIndex;
        }
        return -1;
    }

    public class Block {
        String blockName;
        public HashMap<Integer, Integer> linesIndex = new HashMap();
        public ArrayList<String> lines = new ArrayList();

        public void addLine(int lineIndex, String currentInputLine) {
            this.lines.add(currentInputLine);
            this.linesIndex.put(this.lines.size() - 1, lineIndex);
        }

        public int getNumberOflines() {
            return this.lines.size();
        }
    }

    public static class ConfigVariable {
        String configName;
        Class type;
        String jobsMapping;
        String defaultValue;
        boolean isRequired = false;
    }

    public class DefinedVariable {
        public String configVarName;
        public String configSection;
        public String value;
    }
}

