/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow;

import com.biotechvana.workflow.IValidationResult;
import com.biotechvana.workflow.ValidationResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringJoiner;
import org.eclipse.core.runtime.Assert;

public class WorkflowValidationSet
extends ValidationResult {
    private boolean isValid = true;
    private ArrayList<IValidationResult> children = new ArrayList();

    public WorkflowValidationSet() {
        super(0, 0, "");
    }

    public WorkflowValidationSet(int severity, int code, String message) {
        super(severity, code, message);
    }

    public WorkflowValidationSet(int severity, int code, String message, Throwable exception) {
        super(severity, code, message, exception);
    }

    public void add(IValidationResult vRes) {
        Assert.isLegal((vRes != null ? 1 : 0) != 0);
        this.children.add(vRes);
        int newSev = vRes.getSeverity();
        if (newSev > this.getSeverity()) {
            this.setSeverity(newSev);
        }
    }

    public void addAll(IValidationResult status) {
        Assert.isLegal((status != null ? 1 : 0) != 0);
        this.addAllInternal(status.getChildren());
    }

    private void addAllInternal(IValidationResult[] newChildren) {
        int maxSeverity = this.getSeverity();
        IValidationResult[] iValidationResultArray = newChildren;
        int n = newChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IValidationResult child = iValidationResultArray[n2];
            Assert.isLegal((child != null ? 1 : 0) != 0);
            int severity = child.getSeverity();
            if (severity > maxSeverity) {
                maxSeverity = severity;
            }
            ++n2;
        }
        this.children.addAll(Arrays.asList(newChildren));
        this.setSeverity(maxSeverity);
    }

    @Override
    public IValidationResult[] getChildren() {
        return this.children.toArray(new IValidationResult[0]);
    }

    @Override
    public boolean isMultiValidation() {
        return true;
    }

    public void merge(IValidationResult status) {
        Assert.isLegal((status != null ? 1 : 0) != 0);
        if (!status.isMultiValidation()) {
            this.add(status);
        } else {
            this.addAll(status);
        }
    }

    @Override
    public String toString() {
        StringJoiner joiner = new StringJoiner(" ", super.toString() + " children=[", "]");
        for (IValidationResult child : this.children) {
            joiner.add(child.toString());
        }
        return joiner.toString();
    }
}

