/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.pipelinestools.utils;

import com.biotechvana.commons.model.UserLoginInfo;
import com.biotechvana.pipelineCommander.PipelineCommander;
import com.biotechvana.users.InvalidLoginInfoException;
import com.biotechvana.users.UserManager;
import com.biotechvana.utils.IPrefs;
import com.biotechvana.utils.PreferenceManager;
import com.biotechvana.utils.WorkspaceUtils;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class PipelineExecutor {
    public static final int RUN_MODE_SCREEN = 0;
    public static final int RUN_MODE_QSUB = 1;
    public static final int RUN_MODE_SLURM = 2;

    public static boolean runCommandWithHTTP(UserManager userManager, String command, String beforeCommand, String afterCommand, String outputCommandFile) {
        try {
            return PipelineExecutor.runCommandWithHTTP(userManager, command, beforeCommand, afterCommand, outputCommandFile, userManager.getUserLoginInfo());
        }
        catch (InvalidLoginInfoException e) {
            MessageDialog.openInformation((Shell)WorkspaceUtils.getShell(), (String)"Server credentials not set", (String)"Please, go to \"Preferences -> Pipeline connection settings\"");
            e.printStackTrace();
            return false;
        }
    }

    public static boolean runCommandWithHTTP(UserManager userManager, String command, String beforeCommand, String afterCommand, String outputCommandFile, UserLoginInfo userLogin) {
        String queueValue = userManager.get("PBS", "NO");
        int runMode = 0;
        if (queueValue.equals("QSUB")) {
            runMode = 1;
        } else if (queueValue.equals("SLURM")) {
            runMode = 2;
        }
        return PipelineExecutor.runCommandWithHTTP(userManager, runMode, command, beforeCommand, afterCommand, outputCommandFile, userLogin);
    }

    public static boolean runCommandWithHTTP(UserManager userManager, int runMode, String command, String beforeCommand, String afterCommand, String outputCommandFile, UserLoginInfo userLogin) {
        String username = userLogin.getUserName();
        String password = userLogin.getPassword();
        String host = userLogin.getHostInfo().getServerURL();
        int httpPort = userLogin.getHostInfo().getHttpPort();
        if (username.isEmpty() || password.isEmpty() || host.isEmpty()) {
            MessageDialog.openInformation((Shell)WorkspaceUtils.getShell(), (String)"Server credentials not set", (String)"Please, go to \"Preferences -> Pipeline connection settings\"");
            return false;
        }
        String emailAddress = userManager.get("email", "");
        String homePrefix = userManager.get("ssh_home_prefix", "home");
        if (outputCommandFile.isEmpty()) {
            outputCommandFile = ".command";
        }
        StringBuilder builderCommand = new StringBuilder();
        if (runMode == 1) {
            System.out.println("Running QSUB");
            builderCommand.append(beforeCommand + "\n");
            builderCommand.append("echo '");
            builderCommand.append("#!/bin/bash\n");
            builderCommand.append("#PBS -N " + username + "_GPRO_" + System.currentTimeMillis() + "\n");
            builderCommand.append("cd /" + homePrefix + "/" + username + "\n");
            builderCommand.append("sh " + outputCommandFile);
            builderCommand.append(afterCommand + "\n");
            builderCommand.append("' > gpro.qsub");
            builderCommand.append(" && ");
            builderCommand.append("echo '");
            builderCommand.append(command);
            builderCommand.append("' > " + outputCommandFile);
            builderCommand.append(" && ");
            builderCommand.append("qsub gpro.qsub");
        } else if (runMode == 2) {
            System.out.println("Running SLURM");
            builderCommand.append(beforeCommand + "\n");
            builderCommand.append("echo '");
            builderCommand.append("#!/bin/bash\n");
            builderCommand.append("#SBATCH -p batch\n");
            builderCommand.append("#SBATCH --account=" + PreferenceManager.getInstance().get("ssh_user", "") + "\n");
            builderCommand.append("#SBATCH -o slurm.%N.%j.out\n");
            builderCommand.append("#SBATCH -e slurm.%N.%j.err\n");
            builderCommand.append("#SBATCH --mail-type=END,FAIL\n");
            builderCommand.append("#SBATCH --mail-user=" + emailAddress + "\n");
            builderCommand.append("cd /" + homePrefix + "/" + username + "\n");
            builderCommand.append("sh " + outputCommandFile);
            builderCommand.append(afterCommand + "\n");
            builderCommand.append("' > gpro_slurm.sh");
            builderCommand.append(" && ");
            builderCommand.append("echo '");
            builderCommand.append(command);
            builderCommand.append("' > " + outputCommandFile);
            builderCommand.append(" && ");
            builderCommand.append("sbatch gpro_slurm.sh");
        } else {
            System.out.println("Running SCREEN");
            builderCommand.append(beforeCommand + "\n");
            builderCommand.append("cat <<'_EOM_' > " + outputCommandFile);
            builderCommand.append("\nscreen -wipe;\n");
            builderCommand.append(command);
            builderCommand.append("\n_EOM_\n");
            builderCommand.append("[ $? -eq 0 ] && ( chmod 755 " + outputCommandFile);
            builderCommand.append(" && screen -d -m bash " + outputCommandFile + " )\n");
            builderCommand.append(afterCommand);
        }
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("/home/ahafez/test_command.sh"), "utf-8"));
            writer.write(builderCommand.toString());
            ((Writer)writer).close();
        }
        catch (IOException ex) {
            System.out.println(ex.getStackTrace());
        }
        try {
            PipelineCommander pipelineCommander = new PipelineCommander(userManager.get("ssh_host", ""), httpPort, (IPrefs)userManager);
            boolean emailOnCompletion = true;
            if (emailAddress == null || emailAddress.isEmpty()) {
                emailOnCompletion = false;
            }
            pipelineCommander.prepareCommandRequest(username, password, builderCommand.toString(), true, emailAddress, emailOnCompletion);
            OutputStreamWriter output = new OutputStreamWriter(System.out);
            pipelineCommander.postPipelineRequest((Writer)output);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

