/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.processors.checksum;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import org.eclipse.equinox.internal.p2.repository.helpers.ChecksumHelper;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStep;

public abstract class MessageDigestProcessingStep
extends ProcessingStep {
    protected MessageDigest messageDigest;
    private static final int BUFFER_SIZE = 16384;
    private ByteBuffer buffer = ByteBuffer.allocate(16384);

    @Override
    public final void write(int b) throws IOException {
        boolean isBufferFull;
        this.getDestination().write(b);
        boolean bl = isBufferFull = this.buffer.remaining() == 0;
        if (isBufferFull) {
            this.processBufferredBytes();
        }
        this.buffer.put((byte)b);
    }

    private void processBufferredBytes() {
        this.buffer.flip();
        this.updateDigest();
        this.buffer.clear();
    }

    private void updateDigest() {
        this.messageDigest.update(this.buffer);
    }

    @Override
    public final void close() throws IOException {
        this.processBufferredBytes();
        String digestString = this.digest();
        this.onClose(digestString);
        super.close();
    }

    private String digest() {
        byte[] digestBytes = this.messageDigest.digest();
        return ChecksumHelper.toHexString((byte[])digestBytes);
    }

    protected abstract void onClose(String var1);
}

