/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;

public class Overlay {
    private List<Composite> parents;
    private Control objectToOverlay;
    private Shell overlay;
    private Label label;
    private ControlListener controlListener;
    private DisposeListener disposeListener;
    private PaintListener paintListener;
    private boolean showing;
    private boolean hasClientArea;
    private Scrollable scrollableToOverlay;

    public Overlay(Control objectToOverlay) {
        Objects.requireNonNull(objectToOverlay);
        this.objectToOverlay = objectToOverlay;
        if (objectToOverlay instanceof Scrollable) {
            this.hasClientArea = true;
            this.scrollableToOverlay = (Scrollable)objectToOverlay;
        } else {
            this.hasClientArea = false;
            this.scrollableToOverlay = null;
        }
        this.parents = new ArrayList<Composite>();
        Composite parent = objectToOverlay.getParent();
        while (parent != null) {
            this.parents.add(parent);
            parent = parent.getParent();
        }
        this.controlListener = new ControlListener(){

            public void controlMoved(ControlEvent e) {
                Overlay.this.reposition();
            }

            public void controlResized(ControlEvent e) {
                Overlay.this.reposition();
            }
        };
        this.paintListener = new PaintListener(){

            public void paintControl(PaintEvent arg0) {
                Overlay.this.reposition();
            }
        };
        this.disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Overlay.this.remove();
            }
        };
        this.overlay = new Shell(objectToOverlay.getShell(), 8);
        this.overlay.setBackground(objectToOverlay.getDisplay().getSystemColor(15));
        this.overlay.setAlpha(0);
        this.overlay.setBackgroundMode(1);
        this.label = new Label((Composite)this.overlay, 64);
        this.overlay.setLayout((Layout)new GridLayout());
        this.label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        this.showing = false;
        this.overlay.open();
        this.overlay.setVisible(this.showing);
    }

    public void show() {
        if (this.showing) {
            return;
        }
        this.reposition();
        this.overlay.setVisible(true);
        this.objectToOverlay.addControlListener(this.controlListener);
        this.objectToOverlay.addDisposeListener(this.disposeListener);
        this.objectToOverlay.addPaintListener(this.paintListener);
        for (Composite parent : this.parents) {
            parent.addControlListener(this.controlListener);
            parent.addPaintListener(this.paintListener);
        }
        this.showing = true;
    }

    public void remove() {
        if (!this.showing) {
            return;
        }
        if (!this.objectToOverlay.isDisposed()) {
            this.objectToOverlay.removeControlListener(this.controlListener);
            this.objectToOverlay.removeDisposeListener(this.disposeListener);
            this.objectToOverlay.removePaintListener(this.paintListener);
        }
        for (Composite parent : this.parents) {
            if (parent.isDisposed()) continue;
            parent.removeControlListener(this.controlListener);
            parent.removePaintListener(this.paintListener);
        }
        if (!this.overlay.isDisposed()) {
            this.overlay.setVisible(false);
        }
        this.showing = false;
    }

    public void setBackground(Color background) {
        this.overlay.setBackground(background);
    }

    public Color getBackground() {
        return this.overlay.getBackground();
    }

    public void setAlpha(int alpha) {
        this.overlay.setAlpha(alpha);
    }

    public int getAlpha() {
        return this.overlay.getAlpha();
    }

    public boolean isShowing() {
        return this.showing;
    }

    public void setText(String text) {
        this.label.setText(text);
        this.overlay.layout();
    }

    public String getText() {
        return this.label.getText();
    }

    private void reposition() {
        Rectangle objectToOverlayBounds;
        Point objectToOverlaySize;
        if (!this.objectToOverlay.isVisible()) {
            this.overlay.setBounds(new Rectangle(0, 0, 0, 0));
            return;
        }
        Point objectToOverlayDisplayLocation = this.objectToOverlay.toDisplay(0, 0);
        if (this.hasClientArea) {
            Rectangle clientArea = this.scrollableToOverlay.getClientArea();
            objectToOverlaySize = new Point(clientArea.width, clientArea.height);
        } else {
            objectToOverlaySize = this.objectToOverlay.getSize();
        }
        Rectangle intersection = objectToOverlayBounds = new Rectangle(objectToOverlayDisplayLocation.x, objectToOverlayDisplayLocation.y, objectToOverlaySize.x, objectToOverlaySize.y);
        for (Composite parent : this.parents) {
            Rectangle parentClientArea = parent.getClientArea();
            Point parentLocation = parent.toDisplay(parentClientArea.x, parentClientArea.y);
            Rectangle parentBounds = new Rectangle(parentLocation.x, parentLocation.y, parentClientArea.width, parentClientArea.height);
            intersection = intersection.intersection(parentBounds);
            if (intersection.width == 0 || intersection.height == 0) break;
        }
        this.overlay.setBounds(intersection);
    }
}

