/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.ui.dialogs;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.ui.dialogs.ChatDialog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class ChatWidget2 {
    public static ChatWidget2 DEFAULT_CHATWIDGET;
    Shell background;
    Point dialogSizeMin;
    Point dialogSizeMax;
    Point dialogSize;
    Shell widget;
    private Browser chatBrowser;
    boolean initilzed = false;
    boolean allDeactivated = false;
    private String productName;
    boolean openStatus = false;
    boolean clearChat = true;
    boolean loaded = false;
    static String APP_NAME_PLACEHOLDER;
    private static final String RESEOURCE_PREFIX = "com/biotechvana/ui/resources/";

    static {
        APP_NAME_PLACEHOLDER = "__APP_NAME__";
    }

    public ChatWidget2(Shell background) {
        IProduct product = Platform.getProduct();
        if (product != null) {
            this.productName = product.getName();
        }
        this.background = background;
        this.dialogSizeMin = new Point(75, 75);
        this.dialogSize = this.dialogSizeMax = new Point(350, 450);
        this.createWidget();
        this.reSize();
        background.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                ChatWidget2.this.reSize();
            }

            public void controlMoved(ControlEvent e) {
                ChatWidget2.this.reSize();
            }
        });
        background.addListener(20, new Listener(){

            public void handleEvent(Event event) {
            }
        });
        background.addListener(19, new Listener(){

            public void handleEvent(Event event) {
            }
        });
        background.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
            }
        });
        background.addShellListener(new ShellListener(){
            boolean deiconifiedHappening = false;

            public void shellIconified(ShellEvent e) {
                ChatWidget2.this.widget.setVisible(false);
            }

            public void shellDeiconified(ShellEvent e) {
                this.deiconifiedHappening = true;
                if (ChatWidget2.this.openStatus) {
                    ChatWidget2.this.widget.setVisible(true);
                    ChatWidget2.this.showWidget();
                }
            }

            public void shellDeactivated(ShellEvent e) {
            }

            public void shellClosed(ShellEvent e) {
                ChatWidget2.this.widget.setVisible(false);
            }

            public void shellActivated(ShellEvent e) {
                if (this.deiconifiedHappening) {
                    this.deiconifiedHappening = false;
                    return;
                }
                if (ChatWidget2.this.openStatus) {
                    ChatWidget2.this.widget.setActive();
                }
            }
        });
        this.widget.addShellListener(new ShellListener(){

            public void shellIconified(ShellEvent e) {
            }

            public void shellDeiconified(ShellEvent e) {
            }

            public void shellDeactivated(ShellEvent e) {
            }

            public void shellClosed(ShellEvent e) {
            }

            public void shellActivated(ShellEvent e) {
            }
        });
        this.createDialogArea((Composite)this.widget);
    }

    private void createWidget() {
        this.widget = new Shell(this.background.getDisplay(), 0x4000400C);
        this.widget.setBackground(this.background.getDisplay().getSystemColor(15));
        this.widget.setBackgroundMode(1);
        this.widget.setLayout((Layout)new GridLayout(1, true));
    }

    void reSize() {
        if (this.widget.isDisposed()) {
            this.createWidget();
        }
        Point loc = this.background.getLocation();
        Rectangle size = this.background.getBounds();
        this.widget.setBounds(size.width + size.x - this.dialogSize.x - 10, size.height + size.y - this.dialogSize.y + 5, this.dialogSize.x, this.dialogSize.y);
    }

    public void open() {
        this.openStatus = true;
        if (!this.initilzed) {
            this.widget.open();
            this.widget.setVisible(false);
            this.loadData(this.chatBrowser);
        } else {
            this.showWidget();
        }
    }

    protected void createDialogArea(Composite parent) {
        this.chatBrowser = new Browser(parent, 0);
        Menu menu = new Menu((Decorations)this.widget, 8);
        MenuItem closeMenuItem = new MenuItem(menu, 8);
        closeMenuItem.setText("Close");
        closeMenuItem.setImage(SharedImages.CANCEL);
        closeMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ChatWidget2.this.widget.setVisible(false);
                ChatWidget2.this.openStatus = false;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ChatWidget2.this.widget.setVisible(false);
                ChatWidget2.this.openStatus = false;
            }
        });
        this.chatBrowser.setMenu(menu);
        GridData gd = new GridData(4, 4, true, true);
        this.chatBrowser.setLayoutData((Object)gd);
    }

    public void showWidget() {
        if (this.openStatus) {
            this.widget.setVisible(true);
            this.reSize();
            this.widget.setActive();
        }
    }

    private void loadData(Browser text2) {
        text2.setText(this.getHtmlContent("ChatViewer.html"));
        text2.addProgressListener(new ProgressListener(){

            public void completed(ProgressEvent event) {
                ChatWidget2.this.loaded = true;
                StringBuffer script = new StringBuffer();
                script.append("init();  ");
                try {
                    if (ChatWidget2.this.clearChat) {
                        ChatWidget2.this.eval("clearChat();");
                    }
                    ChatWidget2.this.eval(script.toString());
                    ChatWidget2.this.eval("waitForElementToDisplay('.rw-launcher', function () {openChat();},1000, 9000);");
                    ChatWidget2.this.createBrowserFunctions();
                }
                catch (SWTException e) {
                    e.printStackTrace();
                }
            }

            public void changed(ProgressEvent event) {
            }
        });
    }

    private void createBrowserFunctions() {
        new BrowserFunction(this.chatBrowser, "onChatClose"){

            public Object function(Object[] arguments) {
                ChatWidget2.this.widget.setVisible(false);
                ChatWidget2.this.openStatus = false;
                ChatWidget2.this.eval("openChat();");
                return null;
            }
        };
        new BrowserFunction(this.chatBrowser, "onChatOpen"){

            public Object function(Object[] arguments) {
                if (!ChatWidget2.this.initilzed && !ChatWidget2.this.widget.isVisible()) {
                    ChatWidget2.this.widget.setVisible(true);
                    ChatWidget2.this.chatBrowser.setFocus();
                    ChatWidget2.this.initilzed = true;
                }
                return null;
            }
        };
    }

    private void eval(String script) {
        try {
            this.chatBrowser.evaluate(script);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private String getHtmlContent(String url) {
        StringBuilder html = new StringBuilder();
        html.append(ChatWidget2.getTextFromResource(url, "UTF-8"));
        return html.toString().replace(APP_NAME_PLACEHOLDER, this.productName);
    }

    private static String getTextFromResource(String resourceName, String charset) {
        try {
            return ChatWidget2.getTextFromResourceChecked(RESEOURCE_PREFIX + resourceName, charset);
        }
        catch (IOException exception) {
            String message = "Could not read text from resource: " + resourceName;
            throw new IllegalArgumentException(message, exception);
        }
    }

    private static String getTextFromResourceChecked(String resourceName, String charset) throws IOException {
        InputStream inputStream = ChatDialog.class.getClassLoader().getResourceAsStream(resourceName);
        if (inputStream == null) {
            throw new IllegalArgumentException("Resource not found: " + resourceName);
        }
        try {
            String string = ChatWidget2.getTextFromInputStream(inputStream, charset);
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    private static String getTextFromInputStream(InputStream inputStream, String charset) throws IOException {
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, charset));
        String line = reader.readLine();
        while (line != null) {
            builder.append(line);
            builder.append('\n');
            line = reader.readLine();
        }
        return builder.toString();
    }

    private static void inlineScripts(StringBuilder html) {
        String srcAttrStr = "src=\"./";
        String quotStr = "\"";
        String tagStr = "<script ";
        String closingTagStr = "</script>";
        String newTagStr = "<script type=\"text/javascript\">";
        int offset = html.length();
        while ((offset = html.lastIndexOf(tagStr, offset)) != -1) {
            int srcAttrStart;
            int srcAttrEnd;
            int closeTag = html.indexOf(closingTagStr, offset);
            int srcAttr = html.indexOf(srcAttrStr, offset);
            if (srcAttr != -1 && srcAttr < closeTag && (srcAttrEnd = html.indexOf(quotStr, srcAttrStart = srcAttr + srcAttrStr.length())) != -1) {
                String filename = html.substring(srcAttrStart, srcAttrEnd);
                StringBuffer newScriptTag = new StringBuffer();
                newScriptTag.append(newTagStr);
                newScriptTag.append(ChatWidget2.getTextFromResource(filename, "UTF-8"));
                newScriptTag.append(closingTagStr);
                html.replace(offset, closeTag + closingTagStr.length(), newScriptTag.toString());
            }
            --offset;
        }
    }

    private static void inlineCSS(StringBuilder html) {
        String srcAttrStr = "href=\"./";
        String quotStr = "\"";
        String tagStr = "<link ";
        String closingTagStr = "</link>";
        String newClosingTagStr = "</style>";
        String newTagStr = "<style type=\"text/css\">";
        int offset = html.length();
        while ((offset = html.lastIndexOf(tagStr, offset)) != -1) {
            int srcAttrStart;
            int srcAttrEnd;
            int closeTag = html.indexOf(closingTagStr, offset);
            int srcAttr = html.indexOf(srcAttrStr, offset);
            if (srcAttr != -1 && srcAttr < closeTag && (srcAttrEnd = html.indexOf(quotStr, srcAttrStart = srcAttr + srcAttrStr.length())) != -1) {
                String filename = html.substring(srcAttrStart, srcAttrEnd);
                StringBuffer newScriptTag = new StringBuffer();
                newScriptTag.append(newTagStr);
                newScriptTag.append(ChatWidget2.getTextFromResource(filename, "UTF-8"));
                newScriptTag.append(newClosingTagStr);
                html.replace(offset, closeTag + closingTagStr.length(), newScriptTag.toString());
            }
            --offset;
        }
    }
}

