/*
 * @author		Alfonso Muñoz-Pomer Fuentes, 
 * 				<a href="mailto:alfonso.munozpomer@biotechvana.com">
 * 				alfonso.munozpomer@biotechvana.com</a>,  
 * 				<a href="http://www.biotechvana.com">Biotechvana</a>
 *
 * @date		2010-11-25
 * 
 * @license		See <a href="http://www.biotechvana.com></a>
 *
 * @copyright	Copyright Biotech Vana, S.L. 2006-2010
 */

package com.biotechvana.javabiotoolkit.text;

/**
 * Enumeration of the three platforms which give name to the three different formats of line separators. In short, 
 * Windows uses <code>\r\n</code> or <code>CR-LF</code>, Unix-based systems use <code>\n</code> or <code>LF</code> and 
 * legacy Apple Mac systems use <code>\r</code> or <code>CR</code>.
 * 
 * @author	<a href="mailto:alfonso.munozpomer@biotechvana.com">Alfonso Muñoz-Pomer Fuentes</a>,
 * 			<a href="http://www.biotechvana.com">Biotechvana</a>.
 * 
 * @see		FASTAReader
 * @see		GenBankReader
 * 
 * @version	1.0, 2010-11-01
 */
public enum LineSeparatorFormat
{
	/**
	 * 
	 */
	WINDOWS("\r\n"),
	/**
	 * 
	 */
	UNIX("\n"),
	/**
	 * 
	 */
	MAC("\r"),
	/**
	 * 
	 */
	MIXED(""),
	/**
	 * 
	 */
	SYSTEM_DEFAULT(System.getProperty("line.separator"));
	
	private String lineSeparatorString;
	
	/**
	 * Constructs a <code>LineSeparatorFormat</code> with its corresponding line separator string.
	 * 
	 * @param	lineSeparatorString	the line separator string, proper.
	 * 
	 * @since	1.0
	 */
	private LineSeparatorFormat(String lineSeparatorString)
	{
		this.lineSeparatorString = lineSeparatorString;
	}
	
	/**
	 * Returns the line separator string for this <code>LineSeparatorFormat</code>.
	 * 
	 * @return	this line separator as a string.
	 * 
	 * @since	1.0
	 */
	public String lineSeparator()
	{
		return lineSeparatorString;
	}
}