package com.biotechvana.javabiotoolkit.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.biotechvana.javabiotoolkit.exceptions.FastaReaderNotParsedException;

public class FastaRecordCollection extends ArrayList<FASTAFileRecord> {


	public FastaRecordCollection findSortedRecords (String description, boolean caseInsensitive, boolean resortByOffset)
	{
		FastaRecordCollection fastaRecords  = this;

		Comparator<FASTAFileRecord> comparator =
				caseInsensitive ? FASTAFileRecord.descriptionComparatorCaseInsensitive : FASTAFileRecord.descriptionComparator;

		// Load the descriptions to make sure that sorting by description can be done

		// not here
		// loadDescriptionsIntoRecords(false);


		Collections.sort(fastaRecords, comparator);

		// Create a dummy record with the parameter description
		FASTAFileRecord dummyRecord = new FASTAFileRecord(null, null, null, 0, 0, 0, 0, null, 0);
		dummyRecord.headerLineSB = new StringBuilder(description);

		// And now, search...
		FastaRecordCollection matchingRecords = new FastaRecordCollection();
		int searchPosition = Collections.binarySearch(fastaRecords, dummyRecord, comparator);

		if (searchPosition >= 0)
		{
			matchingRecords.add(fastaRecords.get(searchPosition));

			for (int i = searchPosition - 1 ; i >= 0 ; i--)
			{
				if (caseInsensitive)
				{
					if (fastaRecords.get(i).headerLineSB.toString().equalsIgnoreCase(description))
					{
						matchingRecords.add(fastaRecords.get(i));
					}
					else
					{
						break;
					}
				}
				else // if (!caseInsensitive)
				{
					if (fastaRecords.get(i).headerLineSB.toString().equals(description))
					{
						matchingRecords.add(fastaRecords.get(i));
					}
					else
					{
						break;
					}
				}
			}

			for (int i = searchPosition + 1 ; i < fastaRecords.size() ; i++)
			{
				if (caseInsensitive)
				{
					if (fastaRecords.get(i).headerLineSB.toString().equalsIgnoreCase(description))
					{
						matchingRecords.add(fastaRecords.get(i));
					}
					else
					{
						break;
					}
				}
				else // if (!caseInsensitive)
				{
					if (fastaRecords.get(i).headerLineSB.toString().equals(description))
					{
						matchingRecords.add(fastaRecords.get(i));
					}
					else
					{
						break;
					}
				}
			}
		}

		if (resortByOffset)
		{
			Collections.sort(fastaRecords, FASTAFileRecord.sequenceByteOffsetComparator);
		}

		return matchingRecords;
	}

	public List<FASTAFileRecord> findRecords(String description, boolean caseInsensitive, boolean forceRetrieve) 
	{
		FastaRecordCollection fastaRecords  = this;		
		List<FASTAFileRecord> matchingRecords = new ArrayList<FASTAFileRecord>();
		for (FASTAFileRecord fastaRecord : fastaRecords)
		{
			if (forceRetrieve || fastaRecord.headerLineSB == null)
			{
				String tName;
				// FIXME :: what should i do here ??
				try {
					tName = fastaRecord.retrieveDescriptionSB().toString();
					if (caseInsensitive && tName.equalsIgnoreCase(description))
					{
						matchingRecords.add(fastaRecord);
					}
					else if (tName.equals(description))
					{
						matchingRecords.add(fastaRecord);
					}
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				
				
			}
			else
			{
				if (caseInsensitive && fastaRecord.headerLineSB.toString().equalsIgnoreCase(description))
				{
					matchingRecords.add(fastaRecord);
				}
				else if (fastaRecord.headerLineSB.toString().equals(description))
				{
					matchingRecords.add(fastaRecord);
				}
			}
		}
		return matchingRecords;
	}



	public List<FASTAFileRecord> findRecords(String description)
	{
		return findRecords(description, false, false);
	}
	public Map<String, List<FASTAFileRecord>> findRecords (List<String> descriptions, boolean caseInsensitive, boolean forceRetrieve)
	{


		Map<String, List<FASTAFileRecord>> matchingRecords = new HashMap<String, List<FASTAFileRecord>>();

		for (String description : descriptions)
		{
			matchingRecords.put(description, findRecords(description, caseInsensitive, forceRetrieve));
		}
		return matchingRecords;			
	}

	public Map<String, List<FASTAFileRecord>> findRecords(List<String> descriptions)
	{
		return findRecords(descriptions, false, false);
	}

	/**
	 * 
	 * @param descriptionRegex
	 * 
	 * @return
	 * 
	 * @throws	IOException
	 * @throws FastaReaderNotParsedException 
	 * 
	 * @since	1.0rc2
	 */
	public List<FASTAFileRecord> matchRecords(String descriptionRegex, boolean forceRetrieve) 
	{
		FastaRecordCollection fastaRecords  = this;		


		List<FASTAFileRecord> matchingRecords = new ArrayList<FASTAFileRecord>();

		for (FASTAFileRecord fastaRecord : fastaRecords)
		{
			if (forceRetrieve || fastaRecord.headerLineSB == null)
			{
				// FIXME :: what shoud i do here  ??
				try {
					if (fastaRecord.retrieveDescriptionSB().toString().matches(descriptionRegex))
					{
						matchingRecords.add(fastaRecord);
					}
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			else if (fastaRecord.headerLineSB.toString().matches(descriptionRegex))
			{
				matchingRecords.add(fastaRecord);
			}
		}
		return matchingRecords;			
	}

	public List<FASTAFileRecord> matchRecords(String descriptionRegex) 
	{
		return matchRecords(descriptionRegex, false);
	}

	/**
	 * 
	 * @param descriptionRegexes
	 * 
	 * @return
	 * 
	 * @throws IOException
	 * @throws FastaReaderNotParsedException 
	 * 
	 * @since	1.0rc2
	 */
	public Map<String, List<FASTAFileRecord>> matchRecords(List<String> descriptionRegexes, boolean forceRetrieve)
	{
		Map<String, List<FASTAFileRecord>> matchingRecords = new HashMap<String, List<FASTAFileRecord>>();

		for (String descriptionRegex : descriptionRegexes)
		{
			matchingRecords.put(descriptionRegex, matchRecords(descriptionRegex, forceRetrieve));
		}
		return matchingRecords;	
	}

	public Map<String, List<FASTAFileRecord>> matchRecords(List<String> descriptionRegexes)
	{
		return matchRecords(descriptionRegexes, false);
	}

	public FASTAFileRecord findRecord(String description) {
		List<FASTAFileRecord> result = findRecords(description);

		return null;
	}

	/**
	 * , 
	 * 
	 * @return last record in the collection or nul if the collection is empty
	 */
	public FASTAFileRecord lastRecord() {
		if(size() == 0)
			return null;
		return get(size()-1);
	}

}
