/*
 * @author		Alfonso Muñoz-Pomer Fuentes, 
 * 				<a href="mailto:alfonso.munozpomer@biotechvana.com">
 * 				alfonso.munozpomer@biotechvana.com</a>,  
 * 				<a href="http://www.biotechvana.com">Biotechvana</a>
 *
 * @date		2010-11-01
 * 
 * @copyright	Copyright Biotech Vana, S.L. 2006-2011
 */

package com.biotechvana.javabiotoolkit;

/**
 * Enumeration of the two directions a nucleotide sequence can have. Namely, 5' to 3' directionality (downstream) and 
 * 3' to 5' directionality (upstream).
 * 
 * @version	1.5, 2011-07-19
 * 
 * @author	<a href="mailto:alfonso.munozpomer@biotechvana.com">Alfonso Muñoz-Pomer Fuentes</a>,
 * 			<a href="http://www.biotechvana.com">Biotechvana</a>.
 * 
 * @see		DNASequence
 * @see		RNASequence
 */
public enum NucleotideSequenceDirectionality implements BioSequenceDirectionality
{
	/**
	 * 5' to 3' (downstream).
	 */
	C5_C3("5-3", "5' to 3'"),
	/**
	 * 3' to 5' (upstream).
	 */
	C3_C5("3-5", "3' to 5'");
	private String name;
	private String fullName;

	/*
	 * Default private constructor.
	 */
	private NucleotideSequenceDirectionality(String name, String fullName)
	{
		this.name = name;
		this.fullName = fullName;
	}
	
	/**
	 * Returns the full name of this direction.
	 * 
	 * @return	full name of the receiver.
	 * 
	 * @since	0.1
	 */
	@Override
	public String getFullName()
	{
		return fullName;
	}
	
	/**
	 * Returns the reverse of this direction.
	 * 
	 * @return	reverse direction of the receiver.
	 * 
	 * @since	1.1
	 */
	@Override
	public NucleotideSequenceDirectionality reverse()
	{
		if (this == C5_C3)
		{
			return C3_C5;
		}
		else
		{
			return C5_C3;
		}
	}
	
	/*
	 * (non-Javadoc) @see java.lang.Enum#toString()
	 */
	@Override
	public String toString()
	{
		return name;
	}
}