/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.commons.model;

import com.biotechvana.commons.ftpservice.IFTPManager;
import com.biotechvana.commons.ftpservice.IRemoteFile;
import com.biotechvana.commons.model.DropManager;
import com.biotechvana.commons.model.UserNotifyListener;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class FTPDropManager
extends DropManager {
    private boolean ftpDataSet = false;
    public static final String PROTOCOL_FTP = "ftp:";
    IFTPManager ftpManager;

    @Deprecated
    protected FTPDropManager(Control control, int type, String ftpHost, String ftpPort, String ftpUser, String ftpPassword) {
        this(control, type);
    }

    protected FTPDropManager(Control control, int operations, Transfer[] transfers, int type) {
        this.control = control;
        this.operations = operations;
        this.transfers = transfers;
        this.mode = 2;
        this.type = type;
        this.addDropListener();
    }

    protected FTPDropManager(Control control, int type) {
        this.control = control;
        this.operations = 7;
        this.transfers = new Transfer[]{TextTransfer.getInstance(), FileTransfer.getInstance()};
        this.mode = 2;
        this.type = type;
        final UserNotifyListener userNotifyListener = new UserNotifyListener(){

            @Override
            public void userChanging() {
            }

            @Override
            public void userChanged() {
            }
        };
        this.addDropListener();
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FTPDropManager.this.removeManager();
                userNotifyListener.remove();
            }
        });
    }

    public void setFTPManager(IFTPManager ftpManager) {
        this.ftpManager = ftpManager;
        this.ftpDataSet = ftpManager != null && ftpManager.isConnected();
    }

    private void performFtpDrop(String dropFiles) throws FTPDataNotSetException, Exception {
        if (!this.ftpDataSet) {
            throw new FTPDataNotSetException("FTP has not been provided");
        }
        String[] remoteFiles = dropFiles.split("\\|");
        if (!this.ftpManager.isConnected()) {
            throw new Exception("FTP error: can not connect to FTP server");
        }
        try {
            if (this.control instanceof Text) {
                if (this.type == 10) {
                    String[] stringArray = remoteFiles;
                    int n = remoteFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IRemoteFile[] listFiles;
                        String s = stringArray[n2];
                        String ftpFile = s.replace(PROTOCOL_FTP, "");
                        IRemoteFile remoteFile = this.ftpManager.resolveRemoteFile(ftpFile);
                        if (remoteFile.isFile() && ftpFile.endsWith(".gprolib")) {
                            ((Text)this.control).setText(ftpFile);
                        } else if (remoteFile.isFolder() && (listFiles = this.ftpManager.listFiles(ftpFile)) != null) {
                            IRemoteFile[] iRemoteFileArray = listFiles;
                            int n3 = listFiles.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IRemoteFile lf = iRemoteFileArray[n4];
                                if (lf.isFile() && lf.getName().endsWith(".gprolib")) {
                                    ((Text)this.control).setText(lf.getPath());
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                } else {
                    Object ftpFile = remoteFiles[0].replace(PROTOCOL_FTP, "");
                    if (!((String)ftpFile).startsWith("/")) {
                        ftpFile = "/" + (String)ftpFile;
                    }
                    IRemoteFile remoteFile = this.ftpManager.resolveRemoteFile((String)ftpFile);
                    if (this.type == 3) {
                        if (remoteFile.isFile()) {
                            ((Text)this.control).setText((String)ftpFile);
                        }
                    } else if ((this.type == 9 || this.type == 4) && remoteFile.isFolder()) {
                        ((Text)this.control).setText((String)ftpFile);
                    }
                }
            } else if (this.control instanceof List) {
                if (this.type == 3) {
                    String[] stringArray = remoteFiles;
                    int n = remoteFiles.length;
                    int n5 = 0;
                    while (n5 < n) {
                        IRemoteFile[] listFiles;
                        IRemoteFile remoteFile;
                        String s = stringArray[n5];
                        Object ftpFile = s.replace(PROTOCOL_FTP, "");
                        if (!((String)ftpFile).startsWith("/")) {
                            ftpFile = "/" + (String)ftpFile;
                        }
                        if ((remoteFile = this.ftpManager.resolveRemoteFile((String)ftpFile)).isFile() && this.passFilter((String)ftpFile)) {
                            ((List)this.control).add((String)ftpFile);
                        } else if (remoteFile.isFolder() && (listFiles = this.ftpManager.listFiles((String)ftpFile)) != null) {
                            IRemoteFile[] iRemoteFileArray = listFiles;
                            int n6 = listFiles.length;
                            int n7 = 0;
                            while (n7 < n6) {
                                IRemoteFile lf = iRemoteFileArray[n7];
                                if (lf.isFile() && this.passFilter(lf.getName())) {
                                    ((List)this.control).add(lf.getPath());
                                }
                                ++n7;
                            }
                        }
                        ++n5;
                    }
                } else if (this.type == 4) {
                    String[] stringArray = remoteFiles;
                    int n = remoteFiles.length;
                    int n8 = 0;
                    while (n8 < n) {
                        IRemoteFile remoteFile;
                        String s = stringArray[n8];
                        Object ftpFile = s.replace(PROTOCOL_FTP, "");
                        if (!((String)ftpFile).startsWith("/")) {
                            ftpFile = "/" + (String)ftpFile;
                        }
                        if (!(remoteFile = this.ftpManager.resolveRemoteFile((String)ftpFile)).isFile() && remoteFile.isFolder()) {
                            IRemoteFile[] listFiles;
                            IRemoteFile[] iRemoteFileArray = listFiles = this.ftpManager.listFiles((String)ftpFile);
                            int n9 = listFiles.length;
                            int n10 = 0;
                            while (n10 < n9) {
                                IRemoteFile lf = iRemoteFileArray[n10];
                                if (lf.isFile() && this.passFilter(lf.getName())) {
                                    ((List)this.control).add(lf.getPath());
                                }
                                ++n10;
                            }
                        }
                        ++n8;
                    }
                } else if (this.type == 5) {
                    String[] stringArray = remoteFiles;
                    int n = remoteFiles.length;
                    int n11 = 0;
                    while (n11 < n) {
                        IRemoteFile remoteFile;
                        String s = stringArray[n11];
                        Object ftpFile = s.replace(PROTOCOL_FTP, "");
                        if (!((String)ftpFile).startsWith("/")) {
                            ftpFile = "/" + (String)ftpFile;
                        }
                        if ((remoteFile = this.ftpManager.resolveRemoteFile((String)ftpFile)).isFile()) {
                            ((List)this.control).add((String)ftpFile);
                        } else if (remoteFile.isFolder()) {
                            IRemoteFile[] listFiles;
                            IRemoteFile[] iRemoteFileArray = listFiles = this.ftpManager.listFiles((String)ftpFile);
                            int n12 = listFiles.length;
                            int n13 = 0;
                            while (n13 < n12) {
                                IRemoteFile lf = iRemoteFileArray[n13];
                                if (lf.isFile()) {
                                    ((List)this.control).add(lf.getPath());
                                }
                                ++n13;
                            }
                        }
                        ++n11;
                    }
                } else if (this.type == 9) {
                    String[] stringArray = remoteFiles;
                    int n = remoteFiles.length;
                    int n14 = 0;
                    while (n14 < n) {
                        IRemoteFile remoteFile;
                        String s = stringArray[n14];
                        Object ftpFile = s.replace(PROTOCOL_FTP, "");
                        if (!((String)ftpFile).startsWith("/")) {
                            ftpFile = "/" + (String)ftpFile;
                        }
                        if ((remoteFile = this.ftpManager.resolveRemoteFile((String)ftpFile)).isFolder()) {
                            ((List)this.control).add((String)ftpFile);
                        }
                        ++n14;
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new Exception("FTP error: cannot retrieve directory listing");
        }
        if (this.control instanceof List && ((List)this.control).getItemCount() > 0) {
            ((List)this.control).selectAll();
        }
    }

    private void performBlastDrop(String dropFiles) throws Exception {
        String[] remoteDatabases = dropFiles.split("\\|");
        if (remoteDatabases == null || remoteDatabases.length == 0) {
            return;
        }
        if (this.ftpManager == null || !this.ftpManager.isConnected()) {
            throw new Exception("FTP error: can not connect to FTP server");
        }
        try {
            String ftpFile = remoteDatabases[0].replace(PROTOCOL_FTP, "");
            IRemoteFile remoteFile = this.ftpManager.resolveRemoteFile(ftpFile);
            if (remoteFile.isFile()) {
                throw new Exception("FTP error: Cannot change directory");
            }
            IRemoteFile[] listFiles = this.ftpManager.listFiles(ftpFile);
            if (listFiles != null) {
                String[] ftpFiles = new String[listFiles.length];
                int i = 0;
                IRemoteFile[] iRemoteFileArray = listFiles;
                int n = listFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    IRemoteFile lf = iRemoteFileArray[n2];
                    ftpFiles[i] = lf.getName();
                    ++i;
                    ++n2;
                }
                String[] filteredList = FTPDropManager.filterDatabase(ftpFile, ftpFiles);
                if (this.control instanceof List) {
                    ((List)this.control).setItems(filteredList);
                    if (this.control instanceof List && ((List)this.control).getItemCount() > 0) {
                        ((List)this.control).select(0);
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new Exception("FTP error: Cannot change directory");
        }
    }

    private void performHMMDrop(String dropFiles) throws Exception {
        String[] remoteDatabases = dropFiles.split("\\|");
        if (remoteDatabases == null || remoteDatabases.length == 0) {
            return;
        }
        if (this.ftpManager == null || !this.ftpManager.isConnected()) {
            throw new Exception("FTP error: can not connect to FTP server");
        }
        try {
            String ftpFile = remoteDatabases[0].replace(PROTOCOL_FTP, "");
            IRemoteFile remoteFile = this.ftpManager.resolveRemoteFile(ftpFile);
            if (remoteFile.isFile()) {
                throw new Exception("FTP error: Cannot change directory");
            }
            IRemoteFile[] listFiles = this.ftpManager.listFiles(ftpFile);
            if (listFiles != null) {
                String[] ftpFiles = new String[listFiles.length];
                int i = 0;
                IRemoteFile[] iRemoteFileArray = listFiles;
                int n = listFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    IRemoteFile lf = iRemoteFileArray[n2];
                    ftpFiles[i] = lf.getName();
                    ++i;
                    ++n2;
                }
                String[] filteredList = FTPDropManager.filterHMM(ftpFile, ftpFiles);
                if (this.control instanceof List) {
                    ((List)this.control).setItems(filteredList);
                    if (((List)this.control).getItemCount() > 0) {
                        ((List)this.control).select(0);
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new Exception("FTP error: Cannot retrieve file list");
        }
    }

    public static String[] filterDatabase(String path, String[] dblist) {
        ArrayList<CallSite> filteredList = new ArrayList<CallSite>();
        String[] stringArray = dblist;
        int n = dblist.length;
        int n2 = 0;
        while (n2 < n) {
            String dbName;
            String s = stringArray[n2];
            int firstDot = s.indexOf(46);
            if (!((s.equals(".") || s.equals("..") || s.indexOf(".nhr") < 0) && s.indexOf(".phr") < 0 || filteredList.contains(path + "/" + (dbName = s.substring(0, firstDot))))) {
                filteredList.add((CallSite)((Object)(path + "/" + dbName)));
            }
            ++n2;
        }
        return filteredList.toArray(new String[filteredList.size()]);
    }

    public static String[] filterHMM(String path, String[] dblist) {
        HashSet<CallSite> nameSet = new HashSet<CallSite>();
        String[] stringArray = dblist;
        int n = dblist.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            int firstDot = s.lastIndexOf(".");
            if (!s.equals(".") && !s.equals("..") && (s.contains(".hmm") || s.contains(".HMM") || s.contains(".h3m"))) {
                if (firstDot > 0) {
                    nameSet.add((CallSite)((Object)(path + "/" + s.substring(0, firstDot))));
                } else {
                    nameSet.add((CallSite)((Object)(path + "/" + s)));
                }
            }
            ++n2;
        }
        return nameSet.toArray(new String[nameSet.size()]);
    }

    @Override
    protected void perfromDrop(DropTargetEvent event) {
        if (event.data instanceof String[]) {
            return;
        }
        if (event.data instanceof String) {
            if (this.type == 6) {
                try {
                    this.performBlastDrop((String)event.data);
                }
                catch (Exception e) {
                    MessageDialog.openWarning((Shell)this.control.getShell(), (String)"Drop BLAST database files", (String)e.getMessage());
                    e.printStackTrace();
                }
            } else if (this.type == 7) {
                try {
                    this.performHMMDrop((String)event.data);
                }
                catch (Exception e) {
                    MessageDialog.openWarning((Shell)this.control.getShell(), (String)"Drop HMMer database files", (String)e.getMessage());
                }
            } else {
                try {
                    this.performFtpDrop((String)event.data);
                }
                catch (FTPDataNotSetException e) {
                    if (!this.control.isDisposed()) {
                        MessageDialog.openWarning((Shell)this.control.getShell(), (String)"Drop FTP files", (String)e.getMessage());
                    }
                    e.printStackTrace();
                }
                catch (Exception e) {
                    if (!this.control.isDisposed()) {
                        MessageDialog.openWarning((Shell)this.control.getShell(), (String)"Drop FTP files", (String)e.getMessage());
                    }
                    e.printStackTrace();
                }
            }
        } else {
            return;
        }
    }

    class FTPDataNotSetException
    extends Exception {
        public FTPDataNotSetException(String message) {
            super(message);
        }
    }
}

