/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.commons.ftpservice;

import com.biotechvana.commons.ftpservice.IFileTransferJob;
import com.biotechvana.commons.ftpservice.IFtpFileTransfer;
import com.biotechvana.commons.ftpservice.TransferStatus;
import com.biotechvana.commons.ftpservice.TransferType;

public abstract class FtpFileTransfer
implements IFtpFileTransfer {
    protected long totolSize;
    protected long transferedBytes = 0L;
    protected IFileTransferJob transferJob;
    protected TransferStatus status = TransferStatus.PENDING;
    protected boolean done = false;
    protected TransferType transferType;
    protected long speed;

    @Override
    public long getTotalSize() {
        return this.totolSize;
    }

    @Override
    public long getTransferedBytes() {
        return this.transferedBytes;
    }

    @Override
    public boolean isFinished() {
        return this.status == TransferStatus.FINISHED || this.status == TransferStatus.ERROR || this.status == TransferStatus.STOPED;
    }

    @Override
    public TransferStatus getStatus() {
        return this.status;
    }

    @Override
    public long getSpeed() {
        return this.speed;
    }

    @Override
    public IFileTransferJob getJob() {
        return this.transferJob;
    }

    @Override
    public TransferType getTransferType() {
        return this.transferType;
    }

    @Override
    public void setStatus(TransferStatus status) {
        TransferStatus oldStatus = this.status;
        if (oldStatus == TransferStatus.FINISHED && status == TransferStatus.CANCELING) {
            return;
        }
        if (status == TransferStatus.CANCELING) {
            this.status = status;
            this.transferJob.fileTransferStatusUpdate(this, oldStatus);
            return;
        }
        if (this.status == TransferStatus.CANCELING && status == TransferStatus.STOPED) {
            this.status = status;
            this.transferJob.fileTransferStatusUpdate(this, oldStatus);
        }
        if (this.status == TransferStatus.PENDING || this.status == TransferStatus.RUNNING || this.status == TransferStatus.PAUSED) {
            this.status = status;
            switch (status) {
                case FINISHED: {
                    this.transferedBytes = this.totolSize;
                }
                case STOPED: 
                case ERROR: {
                    break;
                }
            }
            this.transferJob.fileTransferStatusUpdate(this, oldStatus);
        }
    }

    @Override
    public void updateTransferedBytes(long totalBytesTransferred) {
        this.transferedBytes = totalBytesTransferred;
        this.transferJob.fileTransferStatusUpdate(this, this.getStatus());
    }

    @Override
    public void updateTransferedBytes(long totalBytesTransferred, long speed) {
        this.setSpeed(speed);
        this.updateTransferedBytes(totalBytesTransferred);
    }

    public void setSpeed(long speed) {
        this.speed = speed;
    }
}

