/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.commons.ftpservice;

import com.biotechvana.commons.ftpservice.IFTPManager;
import com.biotechvana.commons.ftpservice.IFTPQueue;
import com.biotechvana.commons.ftpservice.IFileTransferJob;
import com.biotechvana.commons.ftpservice.IFtpFileTransfer;
import com.biotechvana.commons.ftpservice.TransferStatus;
import com.biotechvana.commons.ftpservice.TransferType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public abstract class FileTransferJob
implements IFileTransferJob {
    protected TransferType transferType;
    protected long totalTransferSize = 0L;
    protected long transferedBytes = 0L;
    protected long activeSubTransferedBytes = 0L;
    protected long avarageTransferSpeed = 0L;
    protected boolean doneResolving = false;
    private TransferStatus status = TransferStatus.PENDING;
    protected List<IFtpFileTransfer> jobFiles = new ArrayList<IFtpFileTransfer>();
    protected HashSet<IFtpFileTransfer> doneJobFiles = new HashSet();
    protected IFTPQueue queue;
    protected IFTPManager ftpManagerImpl;
    protected int totalNumberOfFiles = 0;
    HashSet<IFtpFileTransfer> activeTransfers = new HashSet();
    int nTransfersWithError = 0;
    int nTransfersCanceled = 0;

    @Override
    public long getTotalSize() {
        return this.totalTransferSize;
    }

    @Override
    public long getTransferedBytes() {
        return this.transferedBytes + this.activeSubTransferedBytes;
    }

    @Override
    public TransferType getTransferType() {
        return this.transferType;
    }

    @Override
    public TransferStatus getStatus() {
        return this.status;
    }

    @Override
    public boolean isFinished() {
        return this.status == TransferStatus.FINISHED || this.status == TransferStatus.ERROR || this.status == TransferStatus.STOPED;
    }

    @Override
    public long getSpeed() {
        return this.avarageTransferSpeed;
    }

    protected void changeStatus(TransferStatus newStatus) {
        if (this.status == newStatus) {
            return;
        }
        TransferStatus oldStatus = this.status;
        this.status = newStatus;
        this.queue.fileTransferJobStatusChange(this, oldStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IFtpFileTransfer> getFiles() {
        List<IFtpFileTransfer> list = this.jobFiles;
        synchronized (list) {
            ArrayList<IFtpFileTransfer> aux = new ArrayList<IFtpFileTransfer>(this.jobFiles);
            return aux;
        }
    }

    public ArrayList<IFtpFileTransfer> getDone() {
        ArrayList<IFtpFileTransfer> aux = new ArrayList<IFtpFileTransfer>();
        for (IFtpFileTransfer file : this.doneJobFiles) {
            aux.add(file);
        }
        return aux;
    }

    @Override
    public Collection<? extends IFtpFileTransfer> getActive() {
        return this.activeTransfers;
    }

    @Override
    public synchronized void fileTransferStatusUpdate(IFtpFileTransfer fileTransferJob, TransferStatus oldStatus) {
        this.activeSubTransferedBytes = 0L;
        this.avarageTransferSpeed = 0L;
        if (fileTransferJob.getStatus() != oldStatus) {
            if (fileTransferJob.getStatus() == TransferStatus.RUNNING) {
                if (!this.activeTransfers.contains(fileTransferJob)) {
                    this.activeTransfers.add(fileTransferJob);
                }
            } else {
                if (this.activeTransfers.contains(fileTransferJob)) {
                    this.activeTransfers.remove(fileTransferJob);
                }
                if (fileTransferJob.getStatus() == TransferStatus.FINISHED) {
                    this.transferedBytes += fileTransferJob.getTotalSize();
                    this.doneJobFiles.add(fileTransferJob);
                }
                if (fileTransferJob.getStatus() == TransferStatus.ERROR) {
                    ++this.nTransfersWithError;
                    this.doneJobFiles.add(fileTransferJob);
                }
                if (fileTransferJob.getStatus() == TransferStatus.STOPED) {
                    ++this.nTransfersCanceled;
                    this.doneJobFiles.add(fileTransferJob);
                }
            }
        }
        for (IFtpFileTransfer subTransfer : this.activeTransfers) {
            this.activeSubTransferedBytes += subTransfer.getTransferedBytes();
            this.avarageTransferSpeed += subTransfer.getSpeed();
        }
        if (this.activeTransfers.size() > 0) {
            this.avarageTransferSpeed /= (long)this.activeTransfers.size();
        }
        this.queue.fileTransferStatusUpdate(fileTransferJob, oldStatus);
        this.checkFinalStatus();
    }

    protected void checkFinalStatus() {
        if (this.isFinished()) {
            return;
        }
        if (this.doneResolving && this.doneJobFiles.size() == this.totalNumberOfFiles) {
            if (this.getStatus() == TransferStatus.RUNNING) {
                this.changeStatus(TransferStatus.FINISHED);
            } else {
                this.changeStatus(TransferStatus.STOPED);
            }
        }
    }

    @Override
    public void stop() {
        this.changeStatus(TransferStatus.CANCELING);
        for (IFtpFileTransfer fileObject : this.jobFiles) {
            fileObject.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IFtpFileTransfer fileTransferJob) {
        List<IFtpFileTransfer> list = this.jobFiles;
        synchronized (list) {
            this.jobFiles.add(fileTransferJob);
        }
    }

    public IFTPManager getFtpManagerImpl() {
        return this.ftpManagerImpl;
    }
}

