/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.commons;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.osgi.framework.Bundle;

public class LocaleNLS {
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Set<String> knownMissing = new HashSet<String>();

    public void populate(Bundle bundle) {
        String baseName = (String)bundle.getHeaders().get("Bundle-Localization");
        this.populate(this.getLocalizedEntry(baseName, bundle));
        this.populate(this.getLocalizedEntry("fragment", bundle));
    }

    private URL getLocalizedEntry(String baseName, Bundle bundle) {
        Locale locale = Locale.getDefault();
        URL entry = bundle.getEntry(this.getFileName(baseName, locale.getLanguage(), locale.getCountry()));
        if (entry == null) {
            entry = bundle.getResource(this.getFileName(baseName, locale.getLanguage(), locale.getCountry()));
        }
        if (entry == null) {
            entry = bundle.getEntry(this.getFileName(baseName, locale.getLanguage()));
        }
        if (entry == null) {
            entry = bundle.getResource(this.getFileName(baseName, locale.getLanguage()));
        }
        if (entry == null) {
            entry = bundle.getEntry(this.getFileName(baseName, new String[0]));
        }
        if (entry == null) {
            entry = bundle.getResource(this.getFileName(baseName, new String[0]));
        }
        return entry;
    }

    private String getFileName(String baseName, String ... arguments) {
        Object name = baseName;
        int index = 0;
        while (index < arguments.length) {
            name = (String)name + "_" + arguments[index];
            ++index;
        }
        return (String)name + ".properties";
    }

    private void populate(URL resourceUrl) {
        if (resourceUrl != null) {
            Properties props;
            block13: {
                props = new Properties();
                InputStream stream = null;
                try {
                    try {
                        stream = resourceUrl.openStream();
                        props.load(stream);
                    }
                    catch (IOException e) {
                        this.warn("Could not open the resource file " + String.valueOf(resourceUrl), e);
                        try {
                            stream.close();
                        }
                        catch (IOException e2) {
                            this.warn("Could not close stream for resource file " + String.valueOf(resourceUrl), e2);
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        this.warn("Could not close stream for resource file " + String.valueOf(resourceUrl), e);
                    }
                    throw throwable;
                }
                try {
                    stream.close();
                }
                catch (IOException e) {
                    this.warn("Could not close stream for resource file " + String.valueOf(resourceUrl), e);
                }
            }
            for (Object key : props.keySet()) {
                this.properties.put((String)key, (String)props.get(key));
            }
        }
    }

    public String getTranslated(String key, Object ... arguments) {
        Object translation = this.properties.get(key);
        if (translation != null) {
            if (arguments != null) {
                translation = MessageFormat.format((String)translation, arguments);
            }
        } else {
            translation = "!! " + key;
            if (!this.knownMissing.contains(key)) {
                this.warn("Could not find any translation text for " + key, null);
                this.knownMissing.add(key);
            }
        }
        return translation;
    }

    private void warn(String string, Throwable cause) {
    }
}

