/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.servercommons.dialogs.preferences;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.commons.model.RemoteServerInfo;
import com.biotechvana.commons.model.ServiceStatus;
import com.biotechvana.commons.model.UserLoginInfo;
import com.biotechvana.servercommons.dialogs.preferences.DockerHelper;
import com.biotechvana.servercommons.dialogs.preferences.OnlineCheckDialog;
import com.biotechvana.users.IUsersService;
import com.biotechvana.users.UserManager;
import com.biotechvana.utils.Constants;
import com.biotechvana.utils.EmailValidator;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PreferencesSSHDialog
extends TitleAreaDialog {
    public static final String TRUE_CNST = "true";
    public static final String FALSE_CNST = "false";
    public static final String USE_LOCAL_GPRO_PROP = "USE_LOCAL_GPRO_PROP";
    String preferenceEmail = "";
    String preferenceHost = "";
    int preferenceSSHPort;
    int preferenceAPIPort;
    String preferenceUser = "";
    String preferencePassword = "";
    private Text textEmail;
    private Text textHost;
    private Text textUser;
    private Text textPassword;
    private Text textSSHPort;
    private Text textAPIPort;
    private Button buttonTest;
    boolean localDockerMode = false;
    DockerHelper dockerHelper;
    @Inject
    IUsersService usersService;
    @Inject
    Provider<IRunnableContext> runnableContext;
    Composite localParent;
    UserLoginInfo currentLoginInfo = null;

    @Inject
    public PreferencesSSHDialog(Shell parentShell) {
        super(parentShell);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialSize() {
        return new Point(800, 600);
    }

    public void create() {
        super.create();
        this.setTitle("Server connection settings");
        this.setMessage("Set your Server connection settings");
        this.getButton(0).setEnabled(false);
        this.getShell().setText("GPRO Server Configuration");
        if (!this.localDockerMode) {
            this.validate();
        }
    }

    protected Control createDialogArea(Composite parent) {
        if (this.dockerHelper == null) {
            this.dockerHelper = new DockerHelper();
        }
        if (this.usersService.getUserManager().get(USE_LOCAL_GPRO_PROP, FALSE_CNST).equals(TRUE_CNST)) {
            this.localDockerMode = true;
        }
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        compositeParent.setLayout((Layout)new GridLayout());
        this.createGroupCredentials(compositeParent);
        return compositeParent;
    }

    private Composite createGroupCredentials(final Composite parent) {
        Label spacer;
        if (this.localParent != null && !this.localParent.isDisposed()) {
            this.localParent.dispose();
            this.localParent = null;
        }
        this.localParent = new Composite(parent, 0);
        this.localParent.setLayout((Layout)new GridLayout(3, false));
        this.localParent.setLayoutData((Object)new GridData(768));
        if (!this.localDockerMode) {
            Group group = new Group(this.localParent, 0);
            group.setLayoutData((Object)new GridData(768));
            group.setText("Server login credentials");
            group.setLayout((Layout)new GridLayout(3, false));
            GridLayout layout = (GridLayout)group.getLayout();
            layout.marginWidth = 20;
            layout.marginHeight = 20;
            Label labelHost = new Label((Composite)group, 0);
            labelHost.setText("Host / IP:");
            GridData layoutData = new GridData();
            labelHost.setLayoutData((Object)layoutData);
            this.textHost = new Text((Composite)group, 2052);
            layoutData = new GridData();
            layoutData.widthHint = 200;
            this.textHost.setLayoutData((Object)layoutData);
            this.textHost.setMessage("Host IP or domain");
            Label label = new Label((Composite)group, 0);
            layoutData = new GridData();
            label.setLayoutData((Object)layoutData);
            Label labelUser = new Label((Composite)group, 0);
            labelUser.setText("User:");
            layoutData = new GridData();
            labelUser.setLayoutData((Object)layoutData);
            this.textUser = new Text((Composite)group, 2052);
            layoutData = new GridData();
            layoutData.widthHint = 200;
            this.textUser.setLayoutData((Object)layoutData);
            Label spacer2 = new Label((Composite)group, 0);
            spacer2.setText("");
            layoutData = new GridData();
            spacer2.setLayoutData((Object)layoutData);
            Label labelPassword = new Label((Composite)group, 0);
            labelPassword.setText("Password:");
            layoutData = new GridData();
            labelPassword.setLayoutData((Object)layoutData);
            this.textPassword = new Text((Composite)group, 0x400804);
            layoutData = new GridData();
            layoutData.widthHint = 200;
            this.textPassword.setLayoutData((Object)layoutData);
            spacer2 = new Label((Composite)group, 0);
            spacer2.setText("");
            layoutData = new GridData();
            spacer2.setLayoutData((Object)layoutData);
            Label labelEmail = new Label((Composite)group, 0);
            labelEmail.setText("E-mail address:");
            layoutData = new GridData();
            labelEmail.setLayoutData((Object)layoutData);
            this.textEmail = new Text((Composite)group, 2052);
            layoutData = new GridData();
            layoutData.widthHint = 200;
            layoutData.horizontalSpan = 2;
            this.textEmail.setLayoutData((Object)layoutData);
            Group portsGroup = new Group((Composite)group, 0);
            portsGroup.setText("Ports");
            portsGroup.setLayout((Layout)new GridLayout(4, false));
            layoutData = new GridData(4, 4, false, false, 2, 1);
            portsGroup.setLayoutData((Object)layoutData);
            Label labelPort = new Label((Composite)portsGroup, 0);
            labelPort.setText("API Port:");
            layoutData = new GridData();
            labelPort.setLayoutData((Object)layoutData);
            this.textAPIPort = new Text((Composite)portsGroup, 2052);
            this.textAPIPort.setText("");
            this.textAPIPort.setMessage("80 as default");
            layoutData = new GridData();
            layoutData.widthHint = 150;
            this.textAPIPort.setLayoutData((Object)layoutData);
            labelPort = new Label((Composite)portsGroup, 0);
            labelPort.setText("SSH Port:");
            layoutData = new GridData();
            labelPort.setLayoutData((Object)layoutData);
            this.textSSHPort = new Text((Composite)portsGroup, 2052);
            this.textSSHPort.setText("");
            this.textSSHPort.setMessage("22 as default");
            layoutData = new GridData();
            layoutData.widthHint = 150;
            this.textSSHPort.setLayoutData((Object)layoutData);
            spacer = new Label((Composite)group, 0);
            spacer.setText("");
            layoutData = new GridData();
            spacer.setLayoutData((Object)layoutData);
            this.buttonTest = new Button((Composite)group, 8);
            this.buttonTest.setText("Test connection settings");
            layoutData = new GridData();
            layoutData.horizontalSpan = 2;
            this.buttonTest.setLayoutData((Object)layoutData);
            spacer = new Label((Composite)group, 0);
            spacer.setText("");
            layoutData = new GridData();
            layoutData.horizontalSpan = 3;
            spacer.setLayoutData((Object)layoutData);
            spacer = new Label((Composite)group, 0);
            spacer.setText("");
            layoutData = new GridData();
            layoutData.horizontalSpan = 3;
            spacer.setLayoutData((Object)layoutData);
        }
        final Button useDocker = new Button(this.localParent, 32);
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 3;
        useDocker.setLayoutData((Object)layoutData);
        useDocker.setText("Run GPRO server locally using Docker.");
        useDocker.setSelection(this.localDockerMode);
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesSSHDialog.this.localDockerMode = useDocker.getSelection();
                useDocker.removeSelectionListener((SelectionListener)this);
                PreferencesSSHDialog.this.createGroupCredentials(parent);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        useDocker.addSelectionListener(selectionListener);
        if (this.localDockerMode) {
            Group dockerGroup = new Group(this.localParent, 2048);
            dockerGroup.setText("Container Options");
            layoutData = new GridData(4, 1, true, false, 3, 1);
            layoutData.horizontalSpan = 3;
            dockerGroup.setLayoutData((Object)layoutData);
            dockerGroup.setLayout((Layout)new GridLayout(3, false));
            Button startContainer = new Button((Composite)dockerGroup, 8);
            startContainer.setText("Start GPRO Container");
            startContainer.setToolTipText("Start GRPO Container");
            try {
                boolean isRunninng = this.dockerHelper.isRunning();
                if (isRunninng) {
                    startContainer.setToolTipText("Container is running");
                }
            }
            catch (DockerHelper.NTryRestartEx e2) {
                e2.printStackTrace();
            }
            startContainer.setImage(SharedImages.RUN_EXC);
            startContainer.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    BusyIndicator.showWhile((Display)PreferencesSSHDialog.this.getShell().getDisplay(), (Runnable)new Runnable(){

                        public void run(boolean checkAgain) {
                            try {
                                if (!(this).PreferencesSSHDialog.this.dockerHelper.isRunning()) {
                                    (this).PreferencesSSHDialog.this.dockerHelper.startGpro();
                                    if ((this).PreferencesSSHDialog.this.dockerHelper.isRunning()) {
                                        PreferencesSSHDialog.this.saveDokcerSettings();
                                    }
                                }
                            }
                            catch (DockerHelper.NTryRestartEx e1) {
                                e1.printStackTrace();
                                if (checkAgain) {
                                    (this).PreferencesSSHDialog.this.dockerHelper.removeContainer();
                                    this.run(false);
                                }
                                MessageDialog.openError((Shell)PreferencesSSHDialog.this.getShell(), (String)"Error", (String)"can not start docker container");
                            }
                        }

                        @Override
                        public void run() {
                            this.run(true);
                        }
                    });
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Label spacer3 = new Label((Composite)dockerGroup, 0);
            layoutData = new GridData();
            layoutData.horizontalSpan = 2;
            spacer3.setLayoutData((Object)layoutData);
            this.buttonTest = new Button((Composite)dockerGroup, 8);
            this.buttonTest.setText("Test connection settings");
            layoutData = new GridData();
            layoutData.horizontalSpan = 2;
            this.buttonTest.setLayoutData((Object)layoutData);
            spacer3 = new Label((Composite)dockerGroup, 0);
            layoutData = new GridData();
            layoutData.horizontalSpan = 2;
            spacer3.setLayoutData((Object)layoutData);
        }
        spacer = new Label(this.localParent, 0);
        layoutData = new GridData();
        layoutData.horizontalSpan = 3;
        spacer.setLayoutData((Object)layoutData);
        if (!this.dockerHelper.dockerInstalled) {
            useDocker.setEnabled(false);
            spacer.setText("To use this feature you need to install docker first.");
        }
        this.initForm();
        this.addListeners();
        if (!this.localDockerMode) {
            this.textEmail.setFocus();
        }
        parent.layout(true);
        parent.computeSize(-1, -1);
        return this.localParent;
    }

    private void initForm() {
        UserLoginInfo loginInfo;
        this.currentLoginInfo = loginInfo = this.usersService.getActiveLogin();
        if (this.localDockerMode) {
            this.preferenceEmail = "g_user@localhost.com";
            this.preferenceHost = "localhost";
            this.preferenceSSHPort = RemoteServerInfo.DEFAULT_SSH_PORT;
            this.preferenceAPIPort = RemoteServerInfo.DEFAULT_API_PORT;
            this.preferenceUser = "g_user";
            this.preferencePassword = "g_user";
        } else {
            if (loginInfo != null) {
                this.preferenceEmail = loginInfo.getEmailAddress();
                this.preferenceHost = loginInfo.getHostInfo().getServerURL();
                this.preferenceSSHPort = loginInfo.getHostInfo().getSshPort();
                this.preferenceAPIPort = loginInfo.getHostInfo().getHttpPort();
                this.preferenceUser = loginInfo.getUserName();
                this.preferencePassword = loginInfo.getPassword();
            }
            if (!this.preferenceEmail.isEmpty()) {
                this.textEmail.setText(this.preferenceEmail);
            }
            if (!this.preferenceHost.isEmpty()) {
                this.textHost.setText(this.preferenceHost);
            } else {
                this.textHost.setText("");
            }
            if (this.preferenceSSHPort != RemoteServerInfo.DEFAULT_SSH_PORT) {
                this.textSSHPort.setText(Integer.toString(this.preferenceSSHPort));
            }
            if (this.preferenceAPIPort != RemoteServerInfo.DEFAULT_API_PORT) {
                this.textAPIPort.setText(Integer.toString(this.preferenceAPIPort));
            }
            if (!this.preferenceUser.isEmpty()) {
                this.textUser.setText(this.preferenceUser);
            }
            if (!this.preferencePassword.isEmpty()) {
                this.textPassword.setText(this.preferencePassword);
            }
        }
    }

    protected void okPressed() {
        boolean connectionOk;
        block11: {
            this.updateInputs();
            if (this.localDockerMode) {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("Starting Docker Container", -1);
                        boolean started = DockerHelper.checkStart(PreferencesSSHDialog.this.getShell().getDisplay(), true);
                        if (!started) {
                            throw new InvocationTargetException(new Exception("Can not start docker container"));
                        }
                        monitor.done();
                    }
                };
                ProgressMonitorDialog pm = new ProgressMonitorDialog(this.getShell());
                try {
                    pm.run(true, false, runnable);
                }
                catch (InterruptedException | InvocationTargetException e) {
                    e.printStackTrace();
                    MessageDialog.openWarning((Shell)this.getShell(), (String)"Save configuration", (String)"Error saving configuration: Can not start GPRO docker container");
                    return;
                }
            } else {
                this.updateInputs();
            }
            connectionOk = false;
            try {
                UserLoginInfo loginInfo = new UserLoginInfo();
                loginInfo.setPassword(this.preferencePassword);
                loginInfo.setUserName(this.preferenceUser);
                loginInfo.setHostInfo(new RemoteServerInfo(this.preferenceHost, this.preferenceHost));
                loginInfo.getHostInfo().setScheme(RemoteServerInfo.DEFAULT_FTP_SCHEME);
                loginInfo.getHostInfo().setSshPort(this.preferenceSSHPort);
                loginInfo.getHostInfo().setFtpPort(this.preferenceSSHPort);
                loginInfo.getHostInfo().setHttpPort(this.preferenceAPIPort);
                loginInfo.setEmailAddress(this.preferenceEmail);
                connectionOk = this.usersService.changeLogin(loginInfo);
                if (connectionOk) {
                    UserManager userManager = this.usersService.getUserManager();
                    if (userManager.get("DEMO_MODE", Constants.DEMO_MODE_FALSE).equals(Constants.DEMO_MODE_TRUE)) {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)"DEMO MODE", (String)"Please, note that this software is running in demo mode. Some functions may be disabled.");
                    }
                    break block11;
                }
                MessageDialog.openWarning((Shell)this.getShell(), (String)"Save configuration", (String)"Error saving configuration: Invalid Login");
                return;
            }
            catch (Exception e1) {
                e1.printStackTrace();
                connectionOk = false;
                MessageDialog.openWarning((Shell)this.getShell(), (String)"Save configuration", (String)("Error saving configuration: " + e1.getMessage()));
                return;
            }
        }
        if (connectionOk) {
            if (!this.localDockerMode) {
                this.usersService.getUserManager().put(USE_LOCAL_GPRO_PROP, FALSE_CNST);
                this.usersService.getUserManager().savePreferences();
            } else {
                this.usersService.getUserManager().put(USE_LOCAL_GPRO_PROP, TRUE_CNST);
                this.usersService.getUserManager().savePreferences();
            }
        }
        super.okPressed();
    }

    private void savePreferences() throws BackingStoreException {
    }

    private void saveDokcerSettings() {
        block5: {
            if (this.localDockerMode) {
                this.usersService.getUserManager().put(USE_LOCAL_GPRO_PROP, TRUE_CNST);
                this.usersService.getUserManager().savePreferences();
            }
            boolean connectionOk = false;
            try {
                UserLoginInfo loginInfo = this.getNewLogin();
                connectionOk = this.usersService.changeLogin(loginInfo);
                if (connectionOk) {
                    UserManager userManager = this.usersService.getUserManager();
                    if (userManager.get("DEMO_MODE", Constants.DEMO_MODE_FALSE).equals(Constants.DEMO_MODE_TRUE)) {
                        MessageDialog.openInformation((Shell)this.getShell(), (String)"DEMO MODE", (String)"Please, note that this software is running in demo mode. Some functions may be disabled.");
                    }
                    break block5;
                }
                MessageDialog.openWarning((Shell)this.getShell(), (String)"Save configuration", (String)"Error saving configuration: Invalid Login");
                return;
            }
            catch (Exception e1) {
                e1.printStackTrace();
                connectionOk = false;
                MessageDialog.openWarning((Shell)this.getShell(), (String)"Save configuration", (String)("Error saving configuration: " + e1.getMessage()));
                return;
            }
        }
    }

    private void addListeners() {
        this.buttonTest.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesSSHDialog.this.getButton(0).setEnabled(true);
                ArrayList<ServiceStatus> servicesToCheck = new ArrayList<ServiceStatus>();
                if (PreferencesSSHDialog.this.localDockerMode) {
                    servicesToCheck.add(new ServiceStatus(){
                        {
                            this.name = "Docker Started";
                        }

                        public boolean runCheck() {
                            return DockerHelper.checkStart(null, false);
                        }
                    });
                }
                PreferencesSSHDialog.this.updateInputs();
                servicesToCheck.addAll(PreferencesSSHDialog.this.usersService.getUserManager().getCheckStatus(PreferencesSSHDialog.this.getNewLogin()));
                OnlineCheckDialog onlineDialog = new OnlineCheckDialog(PreferencesSSHDialog.this.getParentShell(), servicesToCheck);
                onlineDialog.open();
                boolean res = onlineDialog.getCheckStatus();
                if (PreferencesSSHDialog.this.localDockerMode) {
                    if (res) {
                        MessageDialog.openInformation((Shell)PreferencesSSHDialog.this.getShell(), (String)"Pipeline connection settings", (String)"Connected successfully to Local GPRO ");
                    } else {
                        MessageDialog.openError((Shell)PreferencesSSHDialog.this.getShell(), (String)"Pipeline connection settings", (String)"Cannot connect to Localhost");
                    }
                } else if (res) {
                    MessageDialog.openInformation((Shell)PreferencesSSHDialog.this.getShell(), (String)"Pipeline connection settings", (String)("Connected successfully to " + PreferencesSSHDialog.this.textHost.getText()));
                } else {
                    MessageDialog.openError((Shell)PreferencesSSHDialog.this.getShell(), (String)"Pipeline connection settings", (String)("Cannot connect to " + PreferencesSSHDialog.this.textHost.getText()));
                }
            }
        });
        if (!this.localDockerMode) {
            this.textEmail.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PreferencesSSHDialog.this.validate();
                }
            });
            this.textHost.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PreferencesSSHDialog.this.validate();
                }
            });
            this.textUser.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PreferencesSSHDialog.this.validate();
                }
            });
            this.textPassword.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PreferencesSSHDialog.this.validate();
                }
            });
        }
    }

    private boolean validate() {
        this.setErrorMessage(null);
        this.getButton(0).setEnabled(false);
        if (this.textEmail.getText().isEmpty()) {
            this.setErrorMessage("E-mail address is required");
            return false;
        }
        if (!EmailValidator.validateEmail((String)this.textEmail.getText())) {
            this.setErrorMessage("Invalid e-mail address");
            return false;
        }
        if (this.textHost.getText().isEmpty()) {
            this.setErrorMessage("Host name is required");
            return false;
        }
        if (this.textUser.getText().isEmpty()) {
            this.setErrorMessage("User name is required");
            return false;
        }
        if (this.textPassword.getText().isEmpty()) {
            this.setErrorMessage("Password is required");
            return false;
        }
        this.getButton(0).setEnabled(true);
        return true;
    }

    private void updateInputs() {
        if (this.validate()) {
            if (this.localDockerMode) {
                this.preferenceEmail = "g_user@localhost.com";
                this.preferenceHost = "localhost";
                this.preferenceSSHPort = RemoteServerInfo.DEFAULT_SSH_PORT;
                this.preferenceAPIPort = RemoteServerInfo.DEFAULT_API_PORT;
                this.preferenceUser = "g_user";
                this.preferencePassword = "g_user";
            } else {
                if (this.textHost.getText().isEmpty()) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)"Pipeline settings", (String)"Host cannot be empty");
                    return;
                }
                if (this.textUser.getText().isEmpty()) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)"Pipeline settings", (String)"Username cannot be empty");
                    return;
                }
                if (this.textPassword.getText().isEmpty()) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)"Pipeline settings", (String)"Password cannot be empty");
                    return;
                }
                this.preferenceEmail = this.textEmail.getText();
                this.preferenceHost = this.textHost.getText();
                this.preferenceUser = this.textUser.getText();
                this.preferencePassword = this.textPassword.getText();
                try {
                    this.preferenceSSHPort = Integer.parseInt(this.textSSHPort.getText());
                }
                catch (Exception e) {
                    this.preferenceSSHPort = RemoteServerInfo.DEFAULT_SSH_PORT;
                    this.textSSHPort.setText("");
                }
                try {
                    this.preferenceAPIPort = Integer.parseInt(this.textAPIPort.getText());
                }
                catch (Exception e) {
                    this.preferenceAPIPort = RemoteServerInfo.DEFAULT_API_PORT;
                }
            }
        }
    }

    private UserLoginInfo getNewLogin() {
        UserLoginInfo loginInfo = new UserLoginInfo();
        loginInfo.setPassword(this.preferencePassword);
        loginInfo.setUserName(this.preferenceUser);
        loginInfo.setHostInfo(new RemoteServerInfo(this.preferenceHost, this.preferenceHost));
        loginInfo.getHostInfo().setScheme(RemoteServerInfo.DEFAULT_FTP_SCHEME);
        loginInfo.getHostInfo().setSshPort(this.preferenceSSHPort);
        loginInfo.getHostInfo().setFtpPort(this.preferenceSSHPort);
        loginInfo.getHostInfo().setHttpPort(this.preferenceAPIPort);
        loginInfo.setEmailAddress(this.preferenceEmail);
        return loginInfo;
    }

    public void setUsersService(IUsersService usersServicer) {
        this.usersService = usersServicer;
    }
}

