/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.servercommons.dialogs.preferences;

import com.biotechvana.commons.model.ServiceStatus;
import com.biotechvana.servercommons.dialogs.preferences.ServicesStatusComposite;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class OnlineCheckDialog
extends Dialog {
    private static final String CLOSE_LABEL = "Close";
    ServicesStatusComposite statusComposite;
    List<ServiceStatus> services;

    protected OnlineCheckDialog(Shell parentShell, List<ServiceStatus> services) {
        super(parentShell);
        this.services = services;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.statusComposite = new ServicesStatusComposite(container, 0);
        this.statusComposite.setLayoutData(new GridData(1808));
        this.statusComposite.start(this.services);
        return container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("GPRO Status");
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button btn = this.createButton(parent, 12, CLOSE_LABEL, true);
        btn.setToolTipText("Cancel Check and Close the Window");
    }

    protected void buttonPressed(int buttonId) {
        if (12 == buttonId) {
            this.statusComposite.cancel();
            this.close();
        }
    }

    public boolean getCheckStatus() {
        for (ServiceStatus s : this.services) {
            if (s.getStatus().equals("OK")) continue;
            return false;
        }
        return true;
    }
}

