/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.ui.widgets;

import com.biotechvana.workflow.Workflow;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.WorkflowStartupJob;
import com.biotechvana.workflow.manager.IWorkflowManager;
import com.biotechvana.workflow.submissionhistory.SubmissionHistoryEntry;
import com.biotechvana.workflow.template.WorkflowTemplate;
import com.biotechvana.workflow.tracking.ExecStatus;
import com.biotechvana.workflow.tracking.ITrackerInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.IContainer;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.CompositeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalShift;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;

public class WorkflowVis
extends Composite
implements Observer {
    IWorkflowManager workflowManager;
    Composite body;
    HashMap<ExecStatus, Color> colorCodes = new HashMap();
    HashMap<ExecStatus, Color> textColorCodes = new HashMap();
    ArrayList<Button> allJobs = new ArrayList();
    HashMap<String, GraphNode> allNodes = new HashMap();
    Graph graph;
    private Workflow workflow;
    protected List<SelectionListener> linkListeners = new ArrayList<SelectionListener>();
    WorkflowJob selectedJob;
    GraphConnection lastSelectedEdeg = null;
    SubmissionHistoryEntry entry;

    public WorkflowVis(Composite parent, int style, IWorkflowManager workflowManager) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        if (this.colorCodes.isEmpty()) {
            this.colorCodes.put(ExecStatus.Running, this.getDisplay().getSystemColor(9));
            this.colorCodes.put(ExecStatus.Finished, this.getDisplay().getSystemColor(5));
            this.colorCodes.put(ExecStatus.Failed, this.getDisplay().getSystemColor(3));
            this.colorCodes.put(ExecStatus.Scheduled, this.getDisplay().getSystemColor(15));
            this.colorCodes.put(ExecStatus.Canceled, this.getDisplay().getSystemColor(13));
            this.colorCodes.put(ExecStatus.Unknown, this.getDisplay().getSystemColor(1));
            this.textColorCodes.put(ExecStatus.Running, this.getDisplay().getSystemColor(1));
            this.textColorCodes.put(ExecStatus.Finished, this.getDisplay().getSystemColor(2));
            this.textColorCodes.put(ExecStatus.Failed, this.getDisplay().getSystemColor(2));
            this.textColorCodes.put(ExecStatus.Scheduled, this.getDisplay().getSystemColor(2));
            this.textColorCodes.put(ExecStatus.Canceled, this.getDisplay().getSystemColor(2));
            this.textColorCodes.put(ExecStatus.Unknown, this.getDisplay().getSystemColor(1));
        }
        this.workflowManager = workflowManager;
    }

    void reset() {
        this.lastSelectedEdeg = null;
        this.allNodes.clear();
    }

    void clearGraph() {
        if (this.body != null) {
            this.body.dispose();
        }
        this.body = new Composite((Composite)this, 0);
        this.body.setLayoutDeferred(true);
        this.body.setLayout((Layout)new GridLayout(1, false));
        if (this.graph != null) {
            this.graph.dispose();
        }
        this.graph = new Graph(this.body, 0);
        this.layout(true);
        this.body.setLayoutDeferred(false);
    }

    public void setWorkflow(WorkflowTemplate workflowTemplate, boolean animated) {
        Workflow workflow = workflowTemplate.createWorkflow(this.workflowManager);
        this.setWorkflow(workflow, animated);
    }

    public void setWorkflow(WorkflowTemplate workflow) {
        this.setWorkflow(workflow, false);
    }

    public void setWorkflow(Workflow workflow) {
        this.setWorkflow(workflow, false);
    }

    public void setWorkflow(Workflow workflow, boolean animated) {
        if (workflow == null) {
            this.reset();
            this.clearGraph();
            return;
        }
        this.reset();
        if (this.workflow != null) {
            this.workflow.deleteObserver((Observer)this);
        }
        workflow.bind((Observer)this);
        this.workflow = workflow;
        this.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 500) {
                    WorkflowVis.this.renderGraph(false);
                }
            }
        });
        this.renderGraph(animated);
    }

    protected void renderGraph(boolean animated) {
        if (this.body != null) {
            this.body.dispose();
        }
        this.body = new Composite((Composite)this, 0);
        this.body.setLayout((Layout)new GridLayout(1, false));
        if (this.graph != null) {
            this.graph.dispose();
        }
        this.graph = new Graph(this.body, 0);
        this.graph.setNodeStyle(65792);
        this.graph.setLayoutData((Object)new GridData(4, 4, true, true));
        CompositeLayoutAlgorithm dr = new CompositeLayoutAlgorithm(new LayoutAlgorithm[]{new TreeLayoutAlgorithm(1), new HorizontalShift(1)});
        this.graph.setLayoutAlgorithm((LayoutAlgorithm)dr, false);
        this.graph.setLayoutDeferred(true);
        for (WorkflowJob job : this.workflow.getAllJobs()) {
            if (job instanceof WorkflowStartupJob) continue;
            GraphNode node = new GraphNode((IContainer)this.graph, 0, job.getFriendlyName(), (Object)job);
            node.setData((Object)job);
            Object desc = job.getJobDesc().getDesc();
            if (((String)desc).length() > 100) {
                desc = ((String)desc).substring(0, 100) + " ....";
            }
            if (!((String)desc).isEmpty()) {
                Label tooltip = new Label((String)desc);
                node.setTooltip((IFigure)tooltip);
            }
            this.allNodes.put(job.getJobID(), node);
        }
        for (WorkflowJob job : this.workflow.getAllJobs()) {
            if (job instanceof WorkflowStartupJob) continue;
            WorkflowJob[] workflowJobArray = job.getPostJobs();
            int n = workflowJobArray.length;
            int n2 = 0;
            while (n2 < n) {
                WorkflowJob postJob = workflowJobArray[n2];
                GraphNode source = this.allNodes.get(job.getJobID());
                GraphNode target = this.allNodes.get(postJob.getJobID());
                GraphConnection edge = new GraphConnection(this.graph, 2, source, target);
                edge.setLineWidth(2);
                edge.setData((Object)postJob.getMappingSummary(job.getJobDescID()));
                ++n2;
            }
        }
        this.graph.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Widget selected;
                System.out.println(e);
                if (WorkflowVis.this.lastSelectedEdeg != null) {
                    WorkflowVis.this.lastSelectedEdeg.setText("");
                    WorkflowVis.this.lastSelectedEdeg = null;
                }
                if ((selected = e.item) == null) {
                    WorkflowVis.this.selectedJob = null;
                    e.data = WorkflowVis.this.selectedJob;
                    WorkflowVis.this.notifyLinkedWithSelection(e);
                } else if (e.item instanceof GraphConnection) {
                    GraphConnection edge = (GraphConnection)e.item;
                    String mapping = (String)edge.getData();
                    edge.setText(mapping);
                    WorkflowVis.this.lastSelectedEdeg = edge;
                    e.data = null;
                    WorkflowVis.this.notifyLinkedWithSelection(e);
                } else {
                    WorkflowJob job;
                    WorkflowVis.this.selectedJob = job = (WorkflowJob)selected.getData();
                    e.data = WorkflowVis.this.selectedJob;
                    WorkflowVis.this.notifyLinkedWithSelection(e);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.graph.applyLayout();
        this.graph.setLayoutDeferred(true);
        this.layout(true);
    }

    protected void notifyLinkedWithSelection(SelectionEvent e) {
        for (SelectionListener selectionListener : this.linkListeners) {
            try {
                selectionListener.widgetSelected(e);
            }
            catch (Exception e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    public WorkflowJob getSelectedWorkflowJob() {
        return this.selectedJob;
    }

    public void addSelectionListener(SelectionListener listener) {
        if (this.graph != null && !this.graph.isDisposed()) {
            this.graph.addSelectionListener(listener);
        }
        this.linkListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (this.graph != null && !this.graph.isDisposed()) {
            this.graph.removeSelectionListener(listener);
        }
        this.linkListeners.add(listener);
    }

    public void addSelectionListener_old(SelectionListener selection) {
    }

    public SubmissionHistoryEntry getTrackEntry() {
        return this.entry;
    }

    public void setTrackInfo(SubmissionHistoryEntry entry) {
        this.entry = entry;
        for (GraphNode node : this.allNodes.values()) {
            WorkflowJob job = (WorkflowJob)node.getData();
            ITrackerInfo info = entry.getTrackInfo().getSubInfoByTaskName(job.getJobID());
            if (info != null) {
                node.setForegroundColor(this.textColorCodes.get(info.getExecStatus()));
                node.setBackgroundColor(this.colorCodes.get(info.getExecStatus()));
                Label tooltip = new Label(job.getJobDescID() + " : " + String.valueOf(info.getExecStatus()));
                node.setTooltip((IFigure)tooltip);
                continue;
            }
            ExecStatus nodeStatus = ExecStatus.Unknown;
            if (entry.getStatus() == ExecStatus.Failed) {
                nodeStatus = ExecStatus.Canceled;
            }
            if (entry.getStatus() == ExecStatus.Running) {
                nodeStatus = ExecStatus.Scheduled;
            }
            node.setBackgroundColor(this.colorCodes.get(nodeStatus));
            node.setForegroundColor(this.textColorCodes.get(nodeStatus));
            Label tooltip = new Label(job.getJobDescID() + " : " + String.valueOf(nodeStatus));
            node.setTooltip((IFigure)tooltip);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.isDisposed()) {
            o.deleteObserver(this);
            return;
        }
        Event e = new Event();
        e.detail = (Integer)arg;
        this.notifyListeners(24, e);
    }

    public void dispose() {
        if (this.workflow != null) {
            this.workflow.deleteObserver((Observer)this);
        }
        super.dispose();
    }

    public void setValidationStatus(HashMap<WorkflowJob, Boolean> valids) {
        for (GraphNode node : this.allNodes.values()) {
            WorkflowJob job = (WorkflowJob)node.getData();
            if (!valids.containsKey(job)) continue;
            ExecStatus nodeStatus = ExecStatus.Finished;
            nodeStatus = valids.get(job) != false ? ExecStatus.Finished : ExecStatus.Failed;
            node.setBackgroundColor(this.colorCodes.get(nodeStatus));
            node.setForegroundColor(this.textColorCodes.get(nodeStatus));
        }
    }
}

