/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.ui.widgets;

import com.biotechvana.workflow.submissionhistory.SubmissionHistoryEntry;
import com.biotechvana.workflow.tracking.ExecStatus;
import com.biotechvana.workflow.tracking.TrackInfo;
import com.biotechvana.workflow.tracking.events.ProcessingTrackEvent;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;

public class ConsoleLog2 {
    Composite parentComposite;
    StyledText logText;
    private SubmissionHistoryEntry curEntry;
    boolean showAll = true;
    TrackInfo currentInfo = null;
    ProcessingTrackEvent startEvent = null;

    public ConsoleLog2(Composite parent) {
        this.parentComposite = parent;
        this.logText = new StyledText(parent, 776);
        this.logText.addLineStyleListener(new LineStyleListener(){

            public void lineGetStyle(LineStyleEvent event) {
                String timestamp;
                if (ConsoleLog2.this.curEntry != null && ConsoleLog2.this.curEntry.getStatus() == ExecStatus.Failed && !event.lineText.toLowerCase().matches("(^##\\[\\d*\\]##).*") && event.lineText.toLowerCase().matches(".*(fail|error).*")) {
                    StyleRange styleRange = new StyleRange();
                    styleRange.start = event.lineOffset;
                    styleRange.length = event.lineText.length();
                    styleRange.background = ConsoleLog2.this.parentComposite.getShell().getDisplay().getSystemColor(3);
                    styleRange.fontStyle = 1;
                    event.styles = new StyleRange[]{styleRange};
                }
                if (ConsoleLog2.this.startEvent != null && event.lineText.startsWith(timestamp = ConsoleLog2.this.startEvent.getLogLine())) {
                    StyleRange styleRange = new StyleRange();
                    styleRange.start = event.lineOffset;
                    styleRange.length = event.lineText.length();
                    styleRange.background = ConsoleLog2.this.parentComposite.getShell().getDisplay().getSystemColor(7);
                    event.styles = new StyleRange[]{styleRange};
                }
            }
        });
    }

    public void updateSelected(ProcessingTrackEvent startEvent) {
        if (startEvent != this.startEvent) {
            this.startEvent = startEvent;
            if (startEvent != null && this.currentInfo.getTaskLog() != null) {
                this.updateLogText(this.currentInfo);
            }
            if (startEvent == null && this.currentInfo.getTaskLog() != null) {
                this.updateLogText(this.currentInfo);
            }
        }
        if (startEvent != null) {
            String timestamp = startEvent.getLogLine();
            if (this.logText != null) {
                int i = 0;
                while (i < this.logText.getLineCount()) {
                    String line = this.logText.getLine(i);
                    if (line.startsWith(timestamp)) {
                        this.logText.setLineBackground(i, 1, this.parentComposite.getShell().getDisplay().getSystemColor(7));
                        this.logText.setTopIndex(i);
                    }
                    ++i;
                }
            }
        }
    }

    public void updateLogText(TrackInfo info) {
        if (this.currentInfo != info) {
            this.currentInfo = info;
            this.setText();
        } else {
            int vBar = 0;
            int hBar = 0;
            vBar = this.logText.getTopIndex();
            hBar = this.logText.getHorizontalIndex();
            this.setText();
            this.logText.setHorizontalIndex(hBar);
            this.logText.setTopIndex(vBar);
        }
    }

    private void setText() {
        if (this.currentInfo == null) {
            this.logText.setText("");
            return;
        }
        try {
            if (this.startEvent != null) {
                this.logText.setText(this.currentInfo.getLogMsg(this.startEvent));
            } else if (this.showAll) {
                this.logText.setText(this.currentInfo.getLogMsg());
            }
        }
        catch (OutOfMemoryError e) {
            this.logText.setText("Log File is to large to view");
        }
    }

    public void setCurrentEntry(SubmissionHistoryEntry visCurEnrtry) {
        if (this.curEntry != visCurEnrtry) {
            this.startEvent = null;
            this.currentInfo = null;
        }
        this.curEntry = visCurEnrtry;
        if (this.curEntry == null) {
            this.updateLogText(null);
        }
    }

    public void setRawText(String logs) {
        try {
            this.logText.setText(logs);
        }
        catch (OutOfMemoryError e) {
            this.logText.setText("Log File is to large to view");
        }
    }
}

