/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.ui.widgets;

import com.biotechvana.workflow.submissionhistory.SubmissionHistoryEntry;
import com.biotechvana.workflow.tracking.ExecStatus;
import com.biotechvana.workflow.tracking.TrackInfo;
import com.biotechvana.workflow.tracking.UITaskTrackInfo;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;

public class ConsoleLog {
    Composite parentComposite;
    StyledText logText;
    private SubmissionHistoryEntry curEntry;
    TrackInfo currentInfo = null;
    UITaskTrackInfo currentTaskInfos = null;

    public ConsoleLog(Composite parent) {
        this.parentComposite = parent;
        this.logText = new StyledText(parent, 776);
        this.logText.addLineStyleListener(new LineStyleListener(){

            public void lineGetStyle(LineStyleEvent event) {
                if (ConsoleLog.this.curEntry != null && ConsoleLog.this.curEntry.getStatus() == ExecStatus.Failed && !event.lineText.toLowerCase().matches("(^##\\[\\d*\\]##).*") && event.lineText.toLowerCase().matches(".*(fail|error).*")) {
                    StyleRange styleRange = new StyleRange();
                    styleRange.start = event.lineOffset;
                    styleRange.length = event.lineText.length();
                    styleRange.background = ConsoleLog.this.parentComposite.getShell().getDisplay().getSystemColor(3);
                    styleRange.fontStyle = 1;
                    event.styles = new StyleRange[]{styleRange};
                }
            }
        });
    }

    public void updateSelected(UITaskTrackInfo entry) {
        if (this.currentTaskInfos != entry) {
            this.currentTaskInfos = entry;
            if (entry != null && entry.startEvent != null && this.currentInfo.getTaskLog() != null) {
                this.updateLogText(this.currentInfo);
            }
            if (entry == null && this.currentInfo.getTaskLog() != null) {
                this.updateLogText(this.currentInfo);
            }
        }
        if (entry != null && entry.startEvent != null) {
            String timestamp = entry.startEvent.getLogLine();
            if (this.logText != null) {
                int i = 0;
                while (i < this.logText.getLineCount()) {
                    String line = this.logText.getLine(i);
                    if (line.startsWith(timestamp)) {
                        this.logText.setLineBackground(i, 1, this.parentComposite.getShell().getDisplay().getSystemColor(7));
                        this.logText.setTopIndex(i);
                    }
                    ++i;
                }
            }
        }
    }

    public void updateLogText() {
        if (this.currentInfo != null) {
            int vBar = 0;
            int hBar = 0;
            vBar = this.logText.getTopIndex();
            hBar = this.logText.getHorizontalIndex();
            this.setText();
            this.logText.setHorizontalIndex(hBar);
            this.logText.setTopIndex(vBar);
        }
    }

    public void updateLogText(TrackInfo info) {
        if (this.currentInfo != info) {
            this.currentInfo = info;
            this.currentTaskInfos = null;
            this.setText();
        } else {
            int vBar = 0;
            int hBar = 0;
            vBar = this.logText.getTopIndex();
            hBar = this.logText.getHorizontalIndex();
            this.setText();
            this.logText.setHorizontalIndex(hBar);
            this.logText.setTopIndex(vBar);
        }
    }

    private void setText() {
        if (this.currentInfo == null) {
            this.logText.setText("");
            return;
        }
        try {
            if (this.currentTaskInfos != null && this.currentTaskInfos.startEvent != null) {
                this.logText.setText(this.currentInfo.getLogMsg(this.currentTaskInfos.startEvent));
            } else {
                this.logText.setText(this.currentInfo.getLogMsg());
            }
        }
        catch (OutOfMemoryError e) {
            this.logText.setText("Log File is to large to view");
        }
    }

    public void setCurrentEntry(SubmissionHistoryEntry visCurEnrtry) {
        if (this.curEntry != visCurEnrtry) {
            this.currentTaskInfos = null;
            this.currentInfo = null;
        }
        this.curEntry = visCurEnrtry;
        if (this.curEntry == null) {
            this.updateLogText(null);
        }
    }
}

