/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.ui.variables;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.commons.model.DropManager;
import com.biotechvana.utils.Constants;
import com.biotechvana.utils.WorkspaceUtils;
import com.biotechvana.workflow.IWorkflowJobComposite;
import com.biotechvana.workflow.VariableControl;
import com.biotechvana.workflow.VariableCustomAction;
import com.biotechvana.workflow.VariablesRule;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.ui.variables.ButtonVariableComposite;
import com.biotechvana.workflow.ui.variables.FileListVariableComposite;
import com.biotechvana.workflow.ui.variables.FileVariableComposite;
import com.biotechvana.workflow.ui.variables.FilesVariableComposite;
import com.biotechvana.workflow.ui.variables.JobVariableComposite;
import com.biotechvana.workflow.ui.variables.ListVariableComposite;
import com.biotechvana.workflow.ui.variables.LiteralListVariableComposite;
import com.biotechvana.workflow.ui.variables.LiteralVariableComposite;
import com.biotechvana.workflow.ui.variables.MultiListVariableComposite;
import com.biotechvana.workflow.ui.variables.RangeVariableComposite;
import com.biotechvana.workflow.variables.JobVariable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;

public class VariableComposite
extends Composite
implements Observer,
VariableControl {
    protected static final String VAR_HELP_SYM = "!";
    protected static final String HL_HELP_SYM = "!";
    protected static final String HL_HELP_TOOLTIP = "Double Click! to Show more help.";
    protected IWorkflowJobComposite parentJobComposite;
    public static final int VAR_DESC_LABEL_MINWIDTH = 50;
    protected static final int OPTION_VAR_HORIZONTAL_INDENT = 25;
    public static final int HELP_LABEL_HORIZONTAL_INDENT = 10;
    protected static final boolean GRAB_EXCESS_HORIZONTAL_SPACE = true;
    public static final int NORMAL_VAR_HORIZONTAL_INDENT = 25;
    public static final int LIST_OBJECT_HIGHT = 150;
    public static final int LIST_OBJECT_WIDTH = 500;
    protected static final int SUB_VAR_HORIZONTAL_INDENT = 25;
    public static final int VAR_DESC_LABEL_WIDTH = 400;
    protected static final int VAR_LIST_FILES_WIDTH = 500;
    public static final int VAR_INPUT_FIELD_WIDTH = 500;
    protected static Cursor cursor = null;
    protected Link varDesclabel;
    protected Link varHelplabel;
    protected String helpMsg = "";
    protected JobVariable var;
    protected Label varErrorslabel;
    protected ControlDecoration controlDecoration;
    protected Composite thisC;
    static Color colorDark = null;
    static Color colorlight = null;
    int style;
    DropManager dropManager;
    Composite childVars;
    ArrayList<Control> disposableParts = new ArrayList();
    Control varControl = null;
    int localColorIndex = 0;
    boolean toggleHelpStatus = false;

    public static VariableComposite createJobVariableComposite(Composite parent, IWorkflowJobComposite parentJobComposite, JobVariable var, int istyle) {
        Object newVariableComposite = null;
        if (var.getDescVarType() == VariableDescriptor.VariableType.FileList) {
            return new FileListVariableComposite(parent, parentJobComposite, var, istyle);
        }
        if (var.getDescVarType() == VariableDescriptor.VariableType.String || var.getDescVarType() == VariableDescriptor.VariableType.Double || var.getDescVarType() == VariableDescriptor.VariableType.Int) {
            return new LiteralVariableComposite(parent, parentJobComposite, var, istyle);
        }
        if (var.getDescVarType() == VariableDescriptor.VariableType.Strings) {
            return new LiteralListVariableComposite(parent, parentJobComposite, var, istyle);
        }
        if (var.getDescVarType() == VariableDescriptor.VariableType.Range) {
            return new RangeVariableComposite(parent, parentJobComposite, var, istyle);
        }
        if (var.getDescVarType() == VariableDescriptor.VariableType.Checked) {
            return new ButtonVariableComposite(parent, parentJobComposite, var, istyle);
        }
        if (var.getDescVarType() == VariableDescriptor.VariableType.SelectionList) {
            return new ListVariableComposite(parent, parentJobComposite, var, istyle);
        }
        if (var.getDescVarType() == VariableDescriptor.VariableType.MultiSelectionList) {
            return new MultiListVariableComposite(parent, parentJobComposite, var, istyle);
        }
        if (var.getDescVarType() == VariableDescriptor.VariableType.Files || var.getDescVarType() == VariableDescriptor.VariableType.Folders) {
            return new FilesVariableComposite(parent, parentJobComposite, var, istyle);
        }
        if (var.getDescVarType() == VariableDescriptor.VariableType.File || var.getDescVarType() == VariableDescriptor.VariableType.Folder) {
            return new FileVariableComposite(parent, parentJobComposite, var, istyle);
        }
        return new JobVariableComposite(parent, parentJobComposite, var, istyle);
    }

    protected VariableComposite(Composite parent, final IWorkflowJobComposite parentJobComposite, JobVariable variable, int style) {
        super(parent, style | 0x800);
        this.var = variable;
        this.var.setBinding((Observer)this);
        this.parentJobComposite = parentJobComposite;
        parentJobComposite.addVarComposite((VariableControl)this);
        this.thisC = this;
        this.style = style;
        if (cursor == null) {
            cursor = new Cursor((Device)parent.getDisplay(), 21);
        }
        if (colorDark == null) {
            Color c = this.getDisplay().getSystemColor(22);
            colorlight = this.getDisplay().getSystemColor(25);
            int r = c.getRed() - 15;
            int g = c.getGreen() - 15;
            int b = c.getBlue() - 15;
            if (r < 0) {
                r = 0;
            }
            if (g < 0) {
                g = 0;
            }
            if (b < 0) {
                b = 0;
            }
            colorDark = new Color(c.getDevice(), r, g, b);
            r = c.getRed() + 15;
            g = c.getGreen() + 15;
            b = c.getBlue() + 15;
            if (r > 255) {
                r = 255;
            }
            if (g > 255) {
                g = 255;
            }
            if (b > 255) {
                b = 255;
            }
        }
        this.setBackgroundMode(1);
        int numOfColumns = 3;
        if (this.var.getDescVarRole() == VariableDescriptor.VariableRole.Option) {
            numOfColumns = 3;
        }
        this.setLayout((Layout)new GridLayout(numOfColumns, false));
        this.createContolsPart();
        this.bindNewValue(true);
        if (this.var.hasMapping() && this.varControl != null) {
            this.varControl.setEnabled(false);
        }
        if (this.var.isReadOnly() && this.varControl != null) {
            this.varControl.setEnabled(false);
        }
        if (this.varControl != null) {
            this.varControl.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                }

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 0x100000A) {
                        parentJobComposite.requestShowHelp(VariableComposite.this.var);
                    }
                }
            });
        }
        if (this.varDesclabel != null) {
            this.varDesclabel.setCursor(cursor);
            this.varDesclabel.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                    parentJobComposite.requestShowHelp(VariableComposite.this.var);
                }
            });
        }
        this.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                VariableComposite.this.setValidation();
                if (event.detail != 400) {
                    VariableComposite.this.bindNewValue(false);
                }
            }
        });
        this.setValidation();
        final VariableComposite thisC = this;
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                VariableComposite.this.var.deleteObserver((Observer)thisC);
                thisC.parentJobComposite.removeVarComposite((VariableControl)thisC);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                VariableComposite.this.var.deleteObserver((Observer)thisC);
                thisC.parentJobComposite.removeVarComposite((VariableControl)thisC);
            }
        });
    }

    protected void setValidation() {
        if (!this.var.isValid()) {
            if (this.varErrorslabel != null) {
                this.varErrorslabel.setForeground(this.getDisplay().getSystemColor(3));
                this.varErrorslabel.setText(this.var.getErrorMsg());
                this.thisC.layout(true);
            }
            if (this.controlDecoration != null) {
                this.controlDecoration.setImage(SharedImages.ERROR);
                this.controlDecoration.show();
                this.controlDecoration.setDescriptionText(this.var.getErrorMsg());
            }
        } else {
            if (this.varErrorslabel != null) {
                this.varErrorslabel.setForeground(this.getDisplay().getSystemColor(2));
                this.varErrorslabel.setText("");
            }
            if (this.var.hasWarning()) {
                this.controlDecoration.setImage(SharedImages.WARNNING_YELLOW);
                this.controlDecoration.show();
                this.controlDecoration.setDescriptionText(this.var.getWarning());
            } else if (this.controlDecoration != null) {
                this.controlDecoration.hide();
                this.controlDecoration.setDescriptionText("");
            }
        }
    }

    protected void createContolsPart() {
    }

    public void bindNewValue(boolean inInit) {
        boolean requireLayout = false;
        if (this.childVars != null) {
            this.childVars.dispose();
            this.childVars = null;
            requireLayout = true;
        }
        ArrayList<JobVariable> activeVars = new ArrayList<JobVariable>();
        if (this.var.descHasRules()) {
            this.setLayoutDeferred(true);
            for (VariablesRule rule : this.var.getDescRules()) {
                if (!rule.isTrue(this.var) || rule.getAction() != VariablesRule.Action.Enable) continue;
                requireLayout = true;
                JobVariable var2 = this.var.getJob().getVariable(rule.getActionVariable().getKey());
                if (!var2.isVisable()) continue;
                activeVars.add(var2);
            }
            if (activeVars.size() > 0) {
                GridData layoutData;
                if (!this.var.getDescGUIVisible()) {
                    this.setVisible(true);
                }
                if (this.childVars == null) {
                    this.childVars = new Composite((Composite)this, 0);
                    layoutData = new GridData(4, 4, true, true, 3, 1);
                    layoutData.horizontalIndent = 25;
                    this.childVars.setLayoutData((Object)layoutData);
                    this.childVars.setLayout((Layout)new GridLayout(1, false));
                    this.childVars.setBackgroundMode(0);
                    this.childVars.setBackground(null);
                }
                int colorIndex = this.localColorIndex + 1;
                for (JobVariable var2 : activeVars) {
                    VariableComposite varComposite = VariableComposite.createJobVariableComposite(this.childVars, this.parentJobComposite, var2, this.style);
                    layoutData = new GridData(4, 4, true, false, 1, 1);
                    varComposite.setLayoutData(layoutData);
                    varComposite.setColor(colorIndex);
                    varComposite.toggleHelpMsg(this.toggleHelpStatus);
                    ++colorIndex;
                }
            } else if (this.var.getDescGUIVisible()) {
                this.setVisible(true);
            } else {
                this.setVisible(false);
            }
            if (requireLayout && !inInit) {
                this.layout(true);
                this.var.getJob().notifyLayoutchanged();
            }
            this.setLayoutDeferred(false);
        }
    }

    public void setColor(int colorIndex) {
        int localColorIndex = colorIndex;
        if (localColorIndex % 2 == 1) {
            this.setBackground(colorDark);
        } else {
            this.setBackground(colorlight);
        }
        if (this.childVars != null) {
            this.childVars.setBackgroundMode(0);
            this.childVars.setBackground(null);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.isDisposed()) {
            this.var.deleteObserver((Observer)this);
            return;
        }
        Event e = new Event();
        e.detail = (Integer)arg;
        this.notifyListeners(24, e);
    }

    protected void invalidVarType() {
        throw new InvalidParameterException("VariableComposite has the wrong VarType Composite has " + String.valueOf(this.var.getDescVarType()));
    }

    public void toggleHelpMsg() {
        this.toggleHelpMsg(!this.toggleHelpStatus);
    }

    private void toggleHelpMsg(boolean toggleHelpStatus) {
        this.toggleHelpStatus = toggleHelpStatus;
        if (this.varHelplabel != null) {
            if (toggleHelpStatus) {
                if (this.helpMsg != null && !this.helpMsg.isEmpty()) {
                    this.varHelplabel.setText(this.helpMsg);
                }
            } else {
                this.varHelplabel.setText("");
            }
            this.layout(true);
        }
    }

    public void exportResources(String jobName, String filename) {
        String resourcesFolder = "job_resources";
        String resourceName = resourcesFolder + "/" + jobName + "/" + filename;
        ClassLoader classLoader = this.parentJobComposite.getWorkflowJob().getClass().getClassLoader();
        final URL url = classLoader.getResource(resourceName);
        String outputFileExtension = filename.substring(filename.length() - 4);
        FileDialog fileDialog = new FileDialog(WorkspaceUtils.getShell(), 8192);
        fileDialog.setFileName(filename);
        fileDialog.setFilterExtensions(new String[]{"*" + outputFileExtension});
        final String outputFilePath = fileDialog.open();
        if (outputFilePath != null) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Copying ", -1);
                    File dest = new File(outputFilePath);
                    try {
                        FileUtils.copyURLToFile((URL)url, (File)dest);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    monitor.done();
                }
            };
            try {
                new ProgressMonitorDialog(WorkspaceUtils.getShell()).run(true, true, runnable);
                MessageDialog.openInformation((Shell)WorkspaceUtils.getShell(), (String)Constants.MODULE_NAME, (String)"Finished successfully");
            }
            catch (Exception e1) {
                e1.printStackTrace();
                MessageDialog.openWarning((Shell)WorkspaceUtils.getShell(), (String)Constants.MODULE_NAME, (String)"Operation was interrupted");
            }
        }
    }

    public static IEclipseContext getEclipseContext() {
        Bundle x = FrameworkUtil.getBundle(VariableComposite.class);
        if (x.getState() != 32) {
            try {
                x.start();
            }
            catch (BundleException e) {
                e.printStackTrace();
            }
        }
        IEclipseContext serviceContext = EclipseContextFactory.getServiceContext((BundleContext)FrameworkUtil.getBundle(VariableComposite.class).getBundleContext());
        IEclipseContext eclipseContext = ((IWorkbench)serviceContext.get(IWorkbench.class)).getApplication().getContext();
        return eclipseContext;
    }

    public Menu getCustomActionMenu(Composite topComposite) {
        Menu menu = new Menu((Control)topComposite);
        for (final VariableCustomAction customAction : this.var.getCustomActions()) {
            MenuItem mi = new MenuItem(menu, 8);
            mi.setText(customAction.getTitle());
            mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IEclipseContext eclipseContext = VariableComposite.getEclipseContext();
                    try {
                        IEclipseContext varContext = EclipseContextFactory.create();
                        varContext.set(JobVariable.class, (Object)VariableComposite.this.var);
                        varContext.setParent(eclipseContext);
                        ContextInjectionFactory.invoke((Object)customAction.getCustomActionCallback(), Execute.class, (IEclipseContext)varContext);
                    }
                    catch (InjectionException e) {
                        customAction.execute(VariableComposite.this.var);
                    }
                }
            });
        }
        return menu;
    }

    public Button addCustomActionMenuBtn(Composite topComposite) {
        final Button actionsBtn = new Button(topComposite, 1028);
        Menu menu = new Menu((Control)topComposite);
        for (final VariableCustomAction customAction : this.var.getCustomActions()) {
            MenuItem mi = new MenuItem(menu, 8);
            mi.setText(customAction.getTitle());
            mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IEclipseContext eclipseContext = VariableComposite.getEclipseContext();
                    try {
                        IEclipseContext varContext = EclipseContextFactory.create();
                        varContext.set(JobVariable.class, (Object)VariableComposite.this.var);
                        varContext.setParent(eclipseContext);
                        ContextInjectionFactory.invoke((Object)customAction.getCustomActionCallback(), Execute.class, (IEclipseContext)varContext);
                    }
                    catch (InjectionException e) {
                        customAction.execute(VariableComposite.this.var);
                    }
                }
            });
        }
        actionsBtn.setMenu(menu);
        actionsBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                actionsBtn.getMenu().setVisible(true);
            }
        });
        GridData layoutData = new GridData(4, 1, false, false, 1, 1);
        layoutData.horizontalIndent = 10;
        layoutData.heightHint = 30;
        actionsBtn.setLayoutData((Object)layoutData);
        return actionsBtn;
    }
}

