/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.ui.variables;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.commons.model.DropManager;
import com.biotechvana.users.InvalidLoginInfoException;
import com.biotechvana.workflow.IWorkflowJobComposite;
import com.biotechvana.workflow.VariableCustomAction;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.ui.variables.VariableComposite;
import com.biotechvana.workflow.variables.JobVariable;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;

public class FileVariableComposite
extends VariableComposite {
    private static final String CONS_FIELD_TYPE_PREFIX = "Field Type : ";
    boolean loopBack = false;

    protected FileVariableComposite(Composite parent, IWorkflowJobComposite parentJobComposite, JobVariable variable, int style) {
        super(parent, parentJobComposite, variable, style);
    }

    @Override
    protected void createContolsPart() {
        super.createContolsPart();
        if (this.var.getDescGUIVisible()) {
            GridData layoutData;
            VariableDescriptor.VariableType varType = this.var.getDescVarType();
            if (varType != VariableDescriptor.VariableType.Checked && varType != VariableDescriptor.VariableType.FileList) {
                int varDesclabelHSpan = 1;
                this.varDesclabel = new Link((Composite)this, 0x40 | this.style);
                layoutData = new GridData(1, 0x1000000, false, false, varDesclabelHSpan, 1);
                layoutData.minimumWidth = 50;
                layoutData.widthHint = 400;
                this.varDesclabel.setLayoutData((Object)layoutData);
                if (this.parentJobComposite.supportShowHelp()) {
                    this.varDesclabel.setText(this.var.getDescFriendlyName() + " : !");
                    this.varDesclabel.setToolTipText("Double Click! to Show more help.");
                } else {
                    this.varDesclabel.setText(this.var.getDescFriendlyName());
                    if (this.var.getDescHelpMsg() != null) {
                        this.varDesclabel.setToolTipText(this.var.getDescHelpMsg());
                    }
                }
                FontData fontdata = this.varDesclabel.getFont().getFontData()[0];
                fontdata.setStyle(1);
                final Font font = new Font((Device)this.getDisplay(), fontdata);
                this.varDesclabel.setFont(font);
                this.varDesclabel.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        font.dispose();
                    }
                });
            }
            if (varType != VariableDescriptor.VariableType.Checked && varType != VariableDescriptor.VariableType.FileList) {
                Object cmdParamater;
                Link varErrorslabel = new Link((Composite)this, 0x40 | this.style);
                layoutData = new GridData(4, 1, true, false, 2, 2);
                layoutData.widthHint = 300;
                layoutData.horizontalIndent = 10;
                varErrorslabel.setLayoutData((Object)layoutData);
                this.disposableParts.add(varErrorslabel);
                String helpMsg = this.var.getDescHelpMsg();
                if (helpMsg == null) {
                    helpMsg = "";
                }
                if (!((String)(cmdParamater = this.var.getDescCommandParamater().trim())).isEmpty()) {
                    cmdParamater = "(" + (String)cmdParamater;
                    String alt = this.var.getDescCommandParamaterAlt().trim();
                    if (!alt.isEmpty()) {
                        cmdParamater = (String)cmdParamater + "/" + alt;
                    }
                    cmdParamater = (String)cmdParamater + ") ";
                }
                this.helpMsg = (String)cmdParamater + helpMsg;
                this.varHelplabel = varErrorslabel;
                this.helpMsg = this.var.getDescHelpMsg();
            }
            if (varType == VariableDescriptor.VariableType.File || varType == VariableDescriptor.VariableType.Folder) {
                FileVariableComposite topComposite = this;
                if (this.var.hasCustomGUIActions()) {
                    Composite innerComposite = new Composite((Composite)this, 0);
                    layoutData = new GridData(4, 1, true, false, 1, 1);
                    layoutData.horizontalIndent = 25;
                    layoutData.widthHint = 500;
                    innerComposite.setLayoutData((Object)layoutData);
                    innerComposite.setLayout((Layout)new GridLayout(2, false));
                    topComposite = innerComposite;
                }
                final Text varValueText = new Text((Composite)topComposite, 2060);
                if (this.var.hasCustomGUIActions()) {
                    layoutData = new GridData(4, 1, true, false, 1, 1);
                    layoutData.horizontalIndent = 25;
                    layoutData.widthHint = 500;
                    varValueText.setLayoutData((Object)layoutData);
                    final Button actionsBtn = new Button((Composite)topComposite, 1028);
                    Menu menu = new Menu((Control)topComposite);
                    for (final VariableCustomAction customAction : this.var.getCustomActions()) {
                        MenuItem mi = new MenuItem(menu, 8);
                        mi.setText(customAction.getTitle());
                        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event) {
                                IEclipseContext eclipseContext = VariableComposite.getEclipseContext();
                                try {
                                    IEclipseContext varContext = EclipseContextFactory.create();
                                    varContext.set(JobVariable.class, (Object)FileVariableComposite.this.var);
                                    varContext.setParent(eclipseContext);
                                    ContextInjectionFactory.invoke((Object)customAction.getCustomActionCallback(), Execute.class, (IEclipseContext)varContext);
                                }
                                catch (InjectionException e) {
                                    customAction.execute(FileVariableComposite.this.var);
                                }
                            }
                        });
                    }
                    actionsBtn.setMenu(menu);
                    actionsBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            actionsBtn.getMenu().setVisible(true);
                        }
                    });
                    actionsBtn.setImage(SharedImages.CODE);
                    layoutData = new GridData(4, 1, false, false, 1, 1);
                    layoutData.horizontalIndent = 10;
                    actionsBtn.setLayoutData((Object)layoutData);
                } else {
                    layoutData = new GridData(4, 1, true, false, 1, 1);
                    layoutData.horizontalIndent = 25;
                    layoutData.widthHint = 500;
                    varValueText.setLayoutData((Object)layoutData);
                }
                varValueText.setToolTipText(this.var.getDescHelpMsg());
                this.controlDecoration = new ControlDecoration((Control)varValueText, 0x1004000);
                this.controlDecoration.setDescriptionText("");
                this.controlDecoration.hide();
                ControlDecoration c = new ControlDecoration((Control)varValueText, 0x1020000);
                if (varType == VariableDescriptor.VariableType.File) {
                    c.setImage(SharedImages.FILE);
                    c.setDescriptionText("Field Type : File");
                }
                if (varType == VariableDescriptor.VariableType.Folder) {
                    c.setImage(SharedImages.FOLDER);
                    c.setDescriptionText("Field Type : Folder");
                }
                c.setShowOnlyOnFocus(true);
                KeyListener clearSet = new KeyListener(){

                    public void keyReleased(KeyEvent e) {
                    }

                    public void keyPressed(KeyEvent e) {
                        if ((e.keyCode == 27 || e.keyCode == 8 || e.keyCode == 127) && e.getSource() instanceof Text) {
                            FileVariableComposite.this.var.setValue("");
                        }
                    }
                };
                varValueText.addKeyListener(clearSet);
                String value = this.var.getValue();
                if (value != null) {
                    varValueText.setText(this.var.getValue());
                }
                varValueText.addFocusListener(new FocusListener(){

                    public void focusLost(FocusEvent e) {
                        FileVariableComposite.this.var.setValue(varValueText.getText());
                    }

                    public void focusGained(FocusEvent e) {
                    }
                });
                int dropManagerType = -1;
                switch (varType) {
                    case File: {
                        dropManagerType = 3;
                        break;
                    }
                    case Folder: {
                        dropManagerType = 4;
                    }
                }
                if (dropManagerType != -1) {
                    try {
                        String userName = this.parentJobComposite.getUserManager().getUserLoginInfo().getUserName();
                        String hostName = this.parentJobComposite.getUserManager().getUserLoginInfo().getHostInfo().getServerURL();
                        String password = this.parentJobComposite.getUserManager().getUserLoginInfo().getPassword();
                        String ftpPort = "" + this.parentJobComposite.getUserManager().getUserLoginInfo().getHostInfo().getFtpPort();
                        this.dropManager = DropManager.create((Control)varValueText, (int)2, (int)dropManagerType);
                    }
                    catch (InvalidLoginInfoException e1) {
                        e1.printStackTrace();
                    }
                }
                this.addListener(24, new Listener(){

                    public void handleEvent(Event event) {
                        FileVariableComposite.this.loopBack = true;
                        varValueText.setText(FileVariableComposite.this.var.getValue());
                    }
                });
                this.varControl = varValueText;
            }
            String shortMsg = "Drag a folder from the FTP Browser";
            if (varType == VariableDescriptor.VariableType.File) {
                shortMsg = "Drag a file from the FTP Browser";
            }
            if (this.var.getDescShortHelpMsg() != null && !this.var.getDescShortHelpMsg().isEmpty()) {
                shortMsg = this.var.getDescShortHelpMsg();
            }
            Label shortHelpLabel = new Label((Composite)this, 0);
            layoutData = new GridData(1, 0x1000000, false, false, 3, 1);
            layoutData.horizontalIndent = 26;
            shortHelpLabel.setLayoutData((Object)layoutData);
            shortHelpLabel.setText(shortMsg);
            if (varType == VariableDescriptor.VariableType.File && this.var.getHasSampleResources()) {
                Link link = new Link((Composite)this, 0);
                link.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
                Object linkText = "Examples of accepted Input format : ";
                if (this.var.getSampleResources().size() == 1) {
                    linkText = "Example of accepted Input format : ";
                }
                for (String sample : this.var.getSampleResources()) {
                    String sampleDisplayName = this.var.getSampleResourcesName(sample);
                    linkText = (String)linkText + "<a href=\"" + sample + "\">" + sampleDisplayName + "</a>, ";
                }
                link.setText(((String)linkText).substring(0, ((String)linkText).length() - 2));
                link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String filename = e.text.substring(e.text.lastIndexOf(47) + 1);
                        FileVariableComposite.this.exportResources(FileVariableComposite.this.var.getJob().getJobDescID(), filename);
                    }
                });
            }
        }
    }
}

