/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.ui.variables;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.commons.model.DropManager;
import com.biotechvana.users.InvalidLoginInfoException;
import com.biotechvana.workflow.IWorkflowJobComposite;
import com.biotechvana.workflow.VariableControl;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.ui.variables.FilesVariableComposite;
import com.biotechvana.workflow.variables.JobVariable;
import com.biotechvana.workflow.variables.ListJobVariable;
import com.biotechvana.workflow.variables.MultiListJobVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class CMDOptionControls
implements Observer,
VariableControl {
    public static int CUSTOM_EVENT = 100;
    protected static final String VAR_HELP_SYM = "!";
    protected static final String HL_HELP_SYM = "!";
    protected static final String HL_HELP_TOOLTIP = "Double Click! to Show more help.";
    protected Composite parent;
    protected IWorkflowJobComposite parentJobComposite;
    protected JobVariable variable;
    protected int style;
    protected Label varDesclabel;
    protected Label varHelplabel;
    protected Label varErrorslabel;
    protected ControlDecoration controlDecoration;
    protected Label cmdOptoin;
    protected Control varControl;
    protected String helpMsg = "";
    protected static Cursor cursor = null;

    public CMDOptionControls(Composite parent, final IWorkflowJobComposite parentJobComposite, JobVariable variable, int style) {
        this.parent = parent;
        if (cursor == null) {
            cursor = new Cursor((Device)parent.getDisplay(), 21);
        }
        this.parentJobComposite = parentJobComposite;
        this.variable = variable;
        this.variable.setBinding((Observer)this);
        parentJobComposite.addVarComposite((VariableControl)this);
        this.style = style;
        this.renderControlPart();
        final CMDOptionControls thisC = this;
        if (this.varDesclabel != null) {
            this.varDesclabel.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                    parentJobComposite.requestShowHelp(thisC.variable);
                }
            });
        }
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                thisC.variable.deleteObserver((Observer)thisC);
                thisC.parentJobComposite.removeVarComposite((VariableControl)thisC);
            }
        });
    }

    private void renderControlPart() {
        this.cmdOptoin = new Label(this.parent, 0);
        this.cmdOptoin.setText(this.variable.getDescCommandParamater());
        GridData layoutData = new GridData(4, 128, false, false);
        GC gc = new GC((Drawable)this.cmdOptoin);
        FontMetrics fontMetrics = gc.getFontMetrics();
        layoutData.widthHint = fontMetrics.getAverageCharWidth() * (this.parentJobComposite.varsCommandParamaterMaxStrLen() + 2);
        gc.dispose();
        this.cmdOptoin.setLayoutData((Object)layoutData);
        this.cmdOptoin.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                System.out.println("mouseUp " + e.count + "\t" + e.button + "\t" + e.time);
            }

            public void mouseDown(MouseEvent e) {
                System.out.println("mouseDown  " + e.count + "\t" + e.button + "\t" + e.time);
                System.out.println("-\n\n");
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.varDesclabel = new Label(this.parent, 64);
        this.varDesclabel.setText(this.variable.getDescFriendlyName() + " !");
        layoutData = new GridData(4, 128, true, false);
        layoutData.horizontalIndent = 25;
        this.varDesclabel.setToolTipText(HL_HELP_TOOLTIP);
        FontData fontdata = this.varDesclabel.getFont().getFontData()[0];
        fontdata.setStyle(1);
        Font font = new Font((Device)this.parent.getDisplay(), fontdata);
        this.varDesclabel.setFont(font);
        this.varDesclabel.setLayoutData((Object)layoutData);
        this.varDesclabel.setCursor(cursor);
        Label varType = new Label(this.parent, 0);
        varType.setText("--");
        this.setTypeLabel(varType);
        layoutData = new GridData(4, 128, false, false);
        layoutData.minimumWidth = 50;
        layoutData.widthHint = 70;
        varType.setLayoutData((Object)layoutData);
        this.renderControlValue();
        if (this.variable.isReadOnly()) {
            this.varControl.setEnabled(false);
        }
    }

    void setTypeLabel(Label varType) {
        if (this.variable.getDescVarType() == VariableDescriptor.VariableType.Checked) {
            varType.setText("YES/NO");
        }
        if (this.variable.getDescVarType() == VariableDescriptor.VariableType.Int || this.variable.getDescVarType() == VariableDescriptor.VariableType.Range) {
            varType.setText("NUMBER");
        }
        if (this.variable.getDescVarType() == VariableDescriptor.VariableType.File) {
            varType.setText("FILE");
        }
        if (this.variable.getDescVarType() == VariableDescriptor.VariableType.Files) {
            varType.setText("FILE");
        }
        if (this.variable.getDescVarType() == VariableDescriptor.VariableType.Double) {
            varType.setText("NUMBER");
        }
        if (this.variable.getDescVarType() == VariableDescriptor.VariableType.SelectionList || this.variable.getDescVarType() == VariableDescriptor.VariableType.MultiSelectionList) {
            varType.setText("SELECT");
        }
        if (this.variable.getDescVarType() == VariableDescriptor.VariableType.Folder) {
            varType.setText("FOLDER");
        }
        if (this.variable.getDescVarType() == VariableDescriptor.VariableType.String) {
            varType.setText("TEXT");
        }
    }

    private void renderControlValue() {
        GridData layoutData = new GridData(4, 0x1000000, false, false, 2, 1);
        layoutData.widthHint = 200;
        layoutData.horizontalIndent = 25;
        if (this.variable.getDescVarType() == VariableDescriptor.VariableType.Checked) {
            this.varControl = this.createCheckControl();
            layoutData.horizontalSpan = 1;
            layoutData.widthHint = 20;
            layoutData.heightHint = 25;
            Label emptyOne = new Label(this.parent, 0);
            GridData emptyOneLayoutData = new GridData(4, 0x1000000, false, false);
            emptyOneLayoutData.widthHint = 130;
            emptyOne.setLayoutData((Object)emptyOneLayoutData);
        } else if (this.variable.getDescVarType() == VariableDescriptor.VariableType.SelectionList) {
            this.varControl = this.createSelectListControl();
        } else if (this.variable.getDescVarType() == VariableDescriptor.VariableType.MultiSelectionList) {
            this.varControl = this.createMultiListControl();
            layoutData.heightHint = 75;
        } else {
            this.varControl = this.variable.getDescVarType() == VariableDescriptor.VariableType.Files ? this.createFilesListControl() : this.createTextControl();
        }
        this.controlDecoration = new ControlDecoration(this.varControl, 0x1004000);
        this.controlDecoration.setDescriptionText("");
        this.controlDecoration.hide();
        this.varControl.setToolTipText(this.variable.getDescHelpMsg());
        this.varControl.setLayoutData((Object)layoutData);
    }

    private Control createFilesListControl() {
        List varValueList = FilesVariableComposite.createBasicControl(this.parentJobComposite, this.parent, this.variable, CUSTOM_EVENT);
        return varValueList;
    }

    protected Control createCheckControl() {
        final Button checkBtn = new Button(this.parent, 32);
        String varValue = this.variable.getValue();
        if (varValue != null && !varValue.isEmpty()) {
            checkBtn.setSelection(varValue.equalsIgnoreCase("true"));
        }
        checkBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CMDOptionControls.this.variable.setValue(checkBtn.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        checkBtn.addListener(CUSTOM_EVENT, new Listener(){

            public void handleEvent(Event event) {
                String varValue = CMDOptionControls.this.variable.getValue();
                if (varValue != null && !varValue.isEmpty()) {
                    checkBtn.setSelection(varValue.equalsIgnoreCase("true"));
                }
            }
        });
        return checkBtn;
    }

    protected Control createTextControl() {
        final Text conVarValue = new Text(this.parent, 2052);
        conVarValue.setText(this.variable.getValue());
        conVarValue.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                CMDOptionControls.this.variable.setValue(conVarValue.getText());
            }

            public void focusGained(FocusEvent e) {
            }
        });
        conVarValue.addListener(CUSTOM_EVENT, new Listener(){

            public void handleEvent(Event event) {
                conVarValue.setText(CMDOptionControls.this.variable.getValue());
            }
        });
        if (this.variable.getDescVarType() == VariableDescriptor.VariableType.File || this.variable.getDescVarType() == VariableDescriptor.VariableType.Folder) {
            KeyListener clearSet = new KeyListener(){

                public void keyReleased(KeyEvent e) {
                }

                public void keyPressed(KeyEvent e) {
                    if ((e.keyCode == 27 || e.keyCode == 8 || e.keyCode == 127) && e.getSource() instanceof Text) {
                        CMDOptionControls.this.variable.setValue("");
                    }
                }
            };
            conVarValue.addKeyListener(clearSet);
            conVarValue.setEditable(false);
            int dropManagerType = -1;
            switch (this.variable.getDescVarType()) {
                case File: {
                    dropManagerType = 3;
                    break;
                }
                case Folder: {
                    dropManagerType = 4;
                }
            }
            if (dropManagerType != -1) {
                try {
                    String userName = this.parentJobComposite.getUserManager().getUserLoginInfo().getUserName();
                    String hostName = this.parentJobComposite.getUserManager().getUserLoginInfo().getHostInfo().getServerURL();
                    String password = this.parentJobComposite.getUserManager().getUserLoginInfo().getPassword();
                    String ftpPort = "" + this.parentJobComposite.getUserManager().getUserLoginInfo().getHostInfo().getFtpPort();
                    DropManager dropManager = DropManager.create((Control)conVarValue, (int)2, (int)dropManagerType);
                }
                catch (InvalidLoginInfoException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return conVarValue;
    }

    protected void setValidation() {
        if (this.controlDecoration == null) {
            return;
        }
        if (!this.variable.isValid()) {
            this.controlDecoration.setImage(SharedImages.ERROR);
            this.controlDecoration.show();
            this.controlDecoration.setDescriptionText(this.variable.getErrorMsg());
        } else if (this.variable.hasWarning()) {
            this.controlDecoration.setImage(SharedImages.WARNNING_YELLOW);
            this.controlDecoration.show();
            this.controlDecoration.setDescriptionText(this.variable.getWarning());
        } else {
            this.controlDecoration.hide();
            this.controlDecoration.setDescriptionText("");
        }
    }

    protected Control createSelectListControl() {
        ArrayList<String> pValues;
        final Combo comboVar = new Combo(this.parent, 0x80080C);
        final ListJobVariable variable = (ListJobVariable)this.variable;
        int pValueOffset = 0;
        if (!variable.getDescIsRequired()) {
            pValues = new ArrayList<String>();
            pValues.add("");
            pValues.addAll(variable.getDescpValues());
            pValueOffset = 1;
        } else {
            pValues = variable.getDescpValues();
        }
        final int pValueOffsetFinal = pValueOffset;
        comboVar.setItems(pValues.toArray(new String[pValues.size()]));
        comboVar.select(variable.getDescpValueIndex(variable.getValue()) + pValueOffsetFinal);
        comboVar.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                System.out.println("List select Event");
                variable.setValue(comboVar.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        comboVar.addListener(CUSTOM_EVENT, new Listener(){

            public void handleEvent(Event event) {
                comboVar.select(variable.getDescpValueIndex(variable.getValue()) + pValueOffsetFinal);
            }
        });
        return comboVar;
    }

    protected Control createMultiListControl() {
        final CheckboxTableViewer listComboVar = CheckboxTableViewer.newCheckList((Composite)this.parent, (int)67586);
        final MultiListJobVariable var = (MultiListJobVariable)this.variable;
        Collection pValues = var.getDescpValues();
        listComboVar.add((Object[])pValues.toArray(new String[var.getDescpValues().size()]));
        listComboVar.getTable().setToolTipText(var.getDescHelpMsg());
        listComboVar.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object[] checkedItems = listComboVar.getCheckedElements();
                var.setValue(checkedItems);
            }
        });
        String[] items = var.getValue().split("\n");
        listComboVar.setAllChecked(false);
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            listComboVar.setChecked((Object)item, true);
            ++n2;
        }
        listComboVar.getTable().addListener(CUSTOM_EVENT, new Listener(){

            public void handleEvent(Event event) {
                String[] items = var.getValue().split("\n");
                listComboVar.setAllChecked(false);
                String[] stringArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    listComboVar.setChecked((Object)item, true);
                    ++n2;
                }
            }
        });
        Menu menu = new Menu((Control)listComboVar.getTable());
        listComboVar.getTable().setMenu(menu);
        MenuItem mntmSelectAll = new MenuItem(menu, 0);
        mntmSelectAll.setText("Select All");
        mntmSelectAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                listComboVar.setAllChecked(true);
                Object[] checkedItems = listComboVar.getCheckedElements();
                var.setValue(checkedItems);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        MenuItem mntmDeSelectAll = new MenuItem(menu, 0);
        mntmDeSelectAll.setText("Deselect All");
        mntmDeSelectAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                listComboVar.setAllChecked(false);
                var.setValue("");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (var.getDescHelpAvlOptions() != null) {
            listComboVar.getTable().addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    TableItem item = listComboVar.getTable().getItem(new Point(e.x, e.y));
                    if (item != null) {
                        String addHelp = var.getDescHelpAvlOption(item.getText());
                        if (addHelp != null) {
                            listComboVar.getTable().setToolTipText(var.getDescHelpMsg() + "\n " + item.getText() + " : " + addHelp);
                        } else {
                            listComboVar.getTable().setToolTipText(var.getDescHelpMsg());
                        }
                    }
                }
            });
        }
        return listComboVar.getTable();
    }

    @Override
    public void update(Observable o, Object arg) {
        this.setValidation();
        Event e = new Event();
        e.detail = (Integer)arg;
        this.varControl.notifyListeners(CUSTOM_EVENT, e);
    }

    public void toggleHelpMsg() {
    }
}

