/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.ui.compsite;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.utils.StringUtils;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ListTableControl {
    static final String VALUES_PROPERTY = "values";
    public static final int TABLE_EVENT_addItem = 0;
    public static final int TABLE_EVENT_deleteSelection = 1;
    public static final int TABLE_EVENT_deleteALL = 2;
    public static final int TABLE_EVENT_clearSelection = 3;
    public static final int TABLE_EVENT_selectAll = 4;
    public static final int TABLE_EVENT_moveUp = 5;
    public static final int TABLE_EVENT_MoveDown = 6;
    final int EDITABLECOLUMN = 0;
    ArrayList<String> values = new ArrayList();
    Table varValueList;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private SelectionListener selectionListener;
    private SelectionListener toolBoxSelectionUpdate;
    TableEditor editor;
    Composite controlContainer;
    private boolean unique = false;
    private boolean readOnly = false;
    private ControlDecoration controlDecoration;
    ToolItem clearSelectionToolItem;
    ToolItem removeSelectionToolItem;
    ToolItem removeAllToolItem;
    ToolItem selectAllToolItem;
    ToolItem addNewToolItem;
    ToolItem moveSelectedUpToolItem;
    ToolItem moveSelectedDownToolItem;

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.support.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.support.removePropertyChangeListener(pcl);
    }

    public Composite createTableControl(Composite parent) {
        this.controlContainer = new Composite(parent, 0){

            public void setEnabled(boolean enabled) {
                ListTableControl.this.readOnly = !enabled;
                ListTableControl.this.toolBoxSelectionUpdate();
                super.setEnabled(true);
            }
        };
        GridData layoutData = new GridData(4, 4, true, false, 2, 1);
        layoutData.horizontalIndent = 25;
        layoutData.minimumWidth = 500;
        this.controlContainer.setLayoutData((Object)layoutData);
        this.controlContainer.setLayout((Layout)new GridLayout(2, false));
        this.varValueList = new Table(this.controlContainer, 68354);
        layoutData = new GridData(4, 4, true, false);
        layoutData.minimumWidth = 500;
        layoutData.heightHint = 150;
        this.varValueList.setLayoutData((Object)layoutData);
        this.selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.handleEvent(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.handleEvent(e);
            }

            void handleEvent(SelectionEvent e) {
                if (e.widget.getData() instanceof Integer) {
                    switch ((Integer)e.widget.getData()) {
                        case 0: {
                            ListTableControl.this.addNewItemEventHandler();
                            break;
                        }
                        case 1: {
                            ListTableControl.this.deleteSelectionEventHandler();
                            break;
                        }
                        case 2: {
                            ListTableControl.this.deleteAllEventHandler();
                            break;
                        }
                        case 3: {
                            ListTableControl.this.varValueList.deselectAll();
                            break;
                        }
                        case 4: {
                            ListTableControl.this.varValueList.selectAll();
                            break;
                        }
                        case 6: {
                            ListTableControl.this.moveSelectionDownEventHandler();
                            break;
                        }
                        case 5: {
                            ListTableControl.this.moveSelectionUpEventHandler();
                            break;
                        }
                        default: {
                            System.out.print("default");
                        }
                    }
                    ListTableControl.this.toolBoxSelectionUpdate();
                }
            }
        };
        TableColumn column1 = new TableColumn(this.varValueList, 0);
        column1.setResizable(true);
        column1.setWidth(500);
        ToolBar toolBar = new ToolBar(this.controlContainer, 520);
        layoutData = new GridData(1, 4, false, true);
        toolBar.setLayoutData((Object)layoutData);
        this.createToolbar(toolBar);
        this.varValueList.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if ((e.stateMask & 0x40000) == 262144 && e.keyCode == 99) {
                    ListTableControl.this.copyListToCP();
                } else if ((e.stateMask & 0x40000) == 262144 && e.keyCode == 118) {
                    ListTableControl.this.pasteToList();
                }
            }
        });
        this.editor = new TableEditor(this.varValueList);
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        this.editor.minimumWidth = 50;
        this.varValueList.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                if (!ListTableControl.this.readOnly) {
                    ListTableControl.this.editSelection();
                }
            }
        });
        this.varValueList.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                System.out.println(" varValueList.addListener SWT.Modify");
                ListTableControl.this.setErrorMessage(null);
                ListTableControl.this.toolBoxSelectionUpdate();
                ListTableControl.this.controlContainer.notifyListeners(24, event);
            }
        });
        this.controlDecoration = new ControlDecoration((Control)this.varValueList, 0x1004000);
        this.controlDecoration.setDescriptionText("");
        this.controlDecoration.hide();
        return this.varValueList;
    }

    protected void addNewItemEventHandler() {
        System.err.println("addNewItemEventHandler");
        String newItemValue = this.getSaveLabel();
        TableItem item = new TableItem(this.varValueList, 0);
        item.setText(newItemValue);
        this.addItem(newItemValue);
        this.varValueList.notifyListeners(24, new Event());
        this.varValueList.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ListTableControl.this.varValueList.deselectAll();
                ListTableControl.this.varValueList.setSelection(ListTableControl.this.varValueList.getItemCount() - 1);
                ListTableControl.this.editSelection(ListTableControl.this.varValueList.getItemCount() - 1);
            }
        });
    }

    protected void addNewItem_() {
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
        String newItem = this.getSaveLabel();
        final TableItem item = new TableItem(this.varValueList, 0);
        item.setText(newItem);
        this.varValueList.deselectAll();
        final Text newEditor = new Text((Composite)this.varValueList, 0);
        newEditor.setText(item.getText(0));
        newEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                Text text = (Text)ListTableControl.this.editor.getEditor();
                ListTableControl.this.editor.getItem().setText(0, text.getText());
            }
        });
        newEditor.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                }
                if (e.detail == 2) {
                    e.doit = false;
                }
            }
        });
        newEditor.selectAll();
        newEditor.setFocus();
        this.editor.setEditor((Control)newEditor, item, 0);
        newEditor.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                String newItem = item.getText();
                ListTableControl.this.addItem(newItem);
                ListTableControl.this.varValueList.notifyListeners(24, new Event());
            }
        });
        newEditor.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                newEditor.dispose();
            }

            public void focusGained(FocusEvent e) {
            }
        });
    }

    private String getSaveLabel() {
        Object label = "new_label";
        int i = 0;
        while (this.values.contains(label)) {
            label = "new_label_" + ++i;
        }
        return label;
    }

    protected void editSelection() {
        int selectedItemIndex = this.varValueList.getSelectionIndex();
        this.editSelection(selectedItemIndex);
    }

    private void exitEditMode() {
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            System.out.println("oldEditor" + String.valueOf(oldEditor));
            if (!oldEditor.isDisposed()) {
                System.out.println("oldEditor notifyListeners SWT.FocusOut");
                oldEditor.notifyListeners(16, new Event());
            }
        }
    }

    protected void editSelection(final int selectedItemIndex) {
        this.exitEditMode();
        if (selectedItemIndex < 0 || selectedItemIndex >= this.varValueList.getItemCount()) {
            return;
        }
        TableItem item = this.varValueList.getItem(selectedItemIndex);
        final Text newEditor = new Text((Composite)this.varValueList, 0);
        newEditor.setText(item.getText(0));
        newEditor.selectAll();
        newEditor.setFocus();
        this.editor.setEditor((Control)newEditor, item, 0);
        final FocusListener focusListener = new FocusListener(){

            public void focusLost(FocusEvent e) {
                System.out.println(e);
                boolean doUpdate = false;
                doUpdate = e.data instanceof Boolean ? ((Boolean)e.data).booleanValue() : ListTableControl.this.finishEditingItem(selectedItemIndex);
                newEditor.removeFocusListener((FocusListener)this);
                newEditor.dispose();
                ListTableControl.this.editor.setEditor(null);
                ListTableControl.this.varValueList.setFocus();
                if (doUpdate) {
                    ListTableControl.this.varValueList.notifyListeners(24, new Event());
                }
            }

            public void focusGained(FocusEvent e) {
            }
        };
        newEditor.addFocusListener(focusListener);
        final TraverseListener traverseListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    boolean doUpdate = ListTableControl.this.finishEditingItem(selectedItemIndex);
                    if (doUpdate) {
                        Event focusEvent = new Event();
                        focusEvent.data = doUpdate;
                        newEditor.notifyListeners(16, focusEvent);
                    }
                }
                if (e.detail == 2) {
                    e.doit = false;
                    ListTableControl.this.setErrorMessage(null);
                    newEditor.dispose();
                    ListTableControl.this.varValueList.setFocus();
                }
            }
        };
        newEditor.addTraverseListener(traverseListener);
        newEditor.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                newEditor.removeFocusListener(focusListener);
                newEditor.removeTraverseListener(traverseListener);
            }
        });
    }

    protected boolean canFinishEditing(TableEditor editor, int selectedItemIndex) {
        Text text = (Text)editor.getEditor();
        String newValue = text.getText();
        if (StringUtils.isBlank((String)newValue)) {
            this.setErrorMessage("Value Can not be empty");
            return false;
        }
        if (this.unique) {
            int i = 0;
            while (i < this.values.size()) {
                if (i != selectedItemIndex && newValue.equals(this.values.get(i))) {
                    this.setErrorMessage("New Value must be unique (No duplication)");
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    protected boolean finishEditingItem(int selectedItemIndex) {
        Control newEditor = this.editor.getEditor();
        this.setErrorMessage(null);
        if (this.canFinishEditing(this.editor, selectedItemIndex)) {
            Text text = (Text)this.editor.getEditor();
            String newValue = text.getText();
            this.varValueList.getItem(selectedItemIndex).setText(newValue);
            this.updateItem(selectedItemIndex, newValue);
            return true;
        }
        return false;
    }

    protected void updateItem(int itemIndex, String newValue) {
        String oldValue = this.values.get(itemIndex);
        this.values.set(itemIndex, newValue);
        this.support.fireIndexedPropertyChange(VALUES_PROPERTY, itemIndex, oldValue, newValue);
    }

    protected void addItem(String newValue) {
        Object oldValue = null;
        this.values.add(newValue);
        this.support.fireIndexedPropertyChange(VALUES_PROPERTY, this.values.size() - 1, oldValue, newValue);
    }

    protected void removeItem(int itemIndex) {
        String oldValue = this.values.get(itemIndex);
        this.values.remove(itemIndex);
        this.support.fireIndexedPropertyChange(VALUES_PROPERTY, itemIndex, oldValue, null);
    }

    protected void pasteToList() {
        TextTransfer transfer = TextTransfer.getInstance();
        Clipboard cb = new Clipboard(this.varValueList.getDisplay());
        String data = (String)cb.getContents((Transfer)transfer);
        if (data != null) {
            data = data.trim();
            this.setListValue(data);
        }
        cb.dispose();
        this.varValueList.notifyListeners(24, new Event());
    }

    protected void copyListToCP() {
        String listValue = this.getListValue();
        Clipboard cb = new Clipboard(this.varValueList.getDisplay());
        TextTransfer textTransfer = TextTransfer.getInstance();
        cb.setContents(new Object[]{listValue}, new Transfer[]{textTransfer});
        cb.dispose();
    }

    public void setListValue(String value) {
        String[] files;
        this.values.clear();
        String[] stringArray = files = value.split("\n");
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            if (!file.isEmpty()) {
                String newItem = file.trim();
                this.values.add(newItem);
            }
            ++n2;
        }
        int i = 0;
        for (String newItem : this.values) {
            this.support.fireIndexedPropertyChange(VALUES_PROPERTY, i, null, newItem);
            ++i;
        }
        this.updateTable();
    }

    public String getListValue() {
        Object retValue = "";
        for (String item : this.values) {
            retValue = (String)retValue + item + "\n";
        }
        return ((String)retValue).trim();
    }

    private void createToolbar(ToolBar toolBar) {
        this.beforeCreatingToolbar(toolBar);
        this.addNewToolItem = new ToolItem(toolBar, 2);
        this.addNewToolItem = new ToolItem(toolBar, 8);
        this.addNewToolItem.setToolTipText("Add Item");
        this.addNewToolItem.setImage(SharedImages.ADD_ITEM);
        this.addNewToolItem.setData((Object)0);
        this.addNewToolItem.addSelectionListener(this.selectionListener);
        this.addNewToolItem.setSelection(this.readOnly);
        ToolItem item = new ToolItem(toolBar, 2);
        this.selectAllToolItem = new ToolItem(toolBar, 8);
        this.selectAllToolItem.setToolTipText("Select All");
        this.selectAllToolItem.setData((Object)4);
        this.selectAllToolItem.setImage(SharedImages.SELECT_ALL);
        this.selectAllToolItem.addSelectionListener(this.selectionListener);
        this.selectAllToolItem.setEnabled(false);
        this.clearSelectionToolItem = new ToolItem(toolBar, 8);
        this.clearSelectionToolItem.setToolTipText("Clear Selection");
        this.clearSelectionToolItem.setData((Object)3);
        this.clearSelectionToolItem.setImage(SharedImages.SELECT_NONE);
        this.clearSelectionToolItem.addSelectionListener(this.selectionListener);
        this.clearSelectionToolItem.setEnabled(false);
        this.removeSelectionToolItem = new ToolItem(toolBar, 8);
        this.removeSelectionToolItem.setToolTipText("Remove Selection");
        this.removeSelectionToolItem.setData((Object)1);
        this.removeSelectionToolItem.setImage(SharedImages.REMOVE_ITEM);
        this.removeSelectionToolItem.addSelectionListener(this.selectionListener);
        this.removeSelectionToolItem.setEnabled(false);
        item = new ToolItem(toolBar, 2);
        this.removeAllToolItem = new ToolItem(toolBar, 8);
        this.removeAllToolItem.setToolTipText("Remove All");
        this.removeAllToolItem.setData((Object)2);
        this.removeAllToolItem.setImage(SharedImages.REMOVE_ALL);
        this.removeAllToolItem.addSelectionListener(this.selectionListener);
        this.removeAllToolItem.setEnabled(false);
        this.moveSelectedUpToolItem = new ToolItem(toolBar, 2);
        this.moveSelectedUpToolItem = new ToolItem(toolBar, 8);
        this.moveSelectedUpToolItem.setToolTipText("Move selected Items Up");
        this.moveSelectedUpToolItem.setData((Object)5);
        this.moveSelectedUpToolItem.setImage(SharedImages.ARROWUP);
        this.moveSelectedUpToolItem.addSelectionListener(this.selectionListener);
        this.moveSelectedDownToolItem = new ToolItem(toolBar, 8);
        this.moveSelectedDownToolItem.setToolTipText("Move selected Items Down");
        this.moveSelectedDownToolItem.setData((Object)6);
        this.moveSelectedDownToolItem.setImage(SharedImages.ARROWDOWN);
        this.moveSelectedDownToolItem.addSelectionListener(this.selectionListener);
        item = new ToolItem(toolBar, 2);
    }

    void toolBoxSelectionUpdate() {
        if (this.varValueList.getSelectionIndices().length == 0) {
            this.clearSelectionToolItem.setEnabled(false);
            this.removeSelectionToolItem.setEnabled(false);
        } else {
            this.clearSelectionToolItem.setEnabled(true);
            this.removeSelectionToolItem.setEnabled(true);
        }
        if (this.varValueList.getItemCount() == 0) {
            this.removeAllToolItem.setEnabled(false);
            this.selectAllToolItem.setEnabled(false);
        } else {
            this.removeAllToolItem.setEnabled(true);
            this.selectAllToolItem.setEnabled(true);
        }
        if (this.readOnly) {
            this.addNewToolItem.setEnabled(false);
            this.removeAllToolItem.setEnabled(false);
            this.clearSelectionToolItem.setEnabled(false);
            this.removeSelectionToolItem.setEnabled(false);
            this.selectAllToolItem.setEnabled(false);
        }
    }

    protected void beforeCreatingToolbar(ToolBar toolBar) {
    }

    private void createMenu(boolean orderBtn, boolean sortBtn) {
        Menu menu = new Menu((Control)this.varValueList);
        this.varValueList.setMenu(menu);
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText("Delete Selected");
        menuItem = new MenuItem(menu, 0);
        menuItem.setText("Delete All");
        menuItem = new MenuItem(menu, 2);
        menuItem = new MenuItem(menu, 0);
        menuItem.setText("Select All");
        menuItem = new MenuItem(menu, 0);
        menuItem.setText("Select None");
        if (orderBtn) {
            menuItem = new MenuItem(menu, 2);
            menuItem = new MenuItem(menu, 0);
            menuItem.setText("Move Selected Up");
            menuItem.setImage(SharedImages.ARROWUP);
            menuItem = new MenuItem(menu, 0);
            menuItem.setText("Move Selected Down");
            menuItem.setImage(SharedImages.ARROWDOWN);
        }
        if (sortBtn) {
            menuItem = new MenuItem(menu, 2);
            menuItem = new MenuItem(menu, 64);
            menuItem.setText("Sort");
            Menu subMenu = new Menu(menu);
            menuItem.setMenu(subMenu);
            menuItem = new MenuItem(subMenu, 8);
            menuItem.setText("Sort by Name");
            menuItem = new MenuItem(subMenu, 8);
            menuItem.setText("Sort by Name/number");
        }
    }

    protected void deleteSelectionEventHandler() {
        System.err.println("deleteSelectionEventHandler");
        this.exitEditMode();
        if (this.varValueList.getItemCount() == 0) {
            return;
        }
        int[] selIndices = this.varValueList.getSelectionIndices();
        if (selIndices.length == 0) {
            return;
        }
        int i = selIndices.length - 1;
        while (i >= 0) {
            this.removeItem(selIndices[i]);
            --i;
        }
        this.varValueList.remove(selIndices);
        if (this.varValueList.getItemCount() != 0) {
            if (selIndices[0] > 0) {
                this.varValueList.setSelection(selIndices[0] - 1);
            } else {
                this.varValueList.setSelection(0);
            }
        }
        this.varValueList.notifyListeners(24, new Event());
    }

    protected void deleteAllEventHandler() {
        System.err.println("deleteAllEventHandler");
        this.exitEditMode();
        String[] oldItems = this.values.toArray(new String[0]);
        int i = oldItems.length - 1;
        while (i >= 0) {
            this.removeItem(i);
            --i;
        }
        this.varValueList.removeAll();
        this.varValueList.notifyListeners(24, new Event());
    }

    protected void moveSelectionDownEventHandler() {
        System.err.println("moveSelectionDownEventHandler");
        this.exitEditMode();
        if (this.varValueList.getItemCount() == 0 || this.varValueList.getSelectionCount() == 0) {
            return;
        }
        int[] selIndices = this.varValueList.getSelectionIndices();
        int startIndex = selIndices[0];
        if (selIndices[selIndices.length - 1] >= this.varValueList.getItemCount() - 1) {
            return;
        }
        int i = selIndices.length - 1;
        while (i >= 0) {
            this.moveBlockSelectionDown(selIndices[i], 1);
            selIndices[i] = selIndices[i] + 1;
            --i;
        }
        this.varValueList.setSelection(selIndices);
        this.tableValueToModel();
        this.varValueList.notifyListeners(24, new Event());
    }

    private void tableValueToModel() {
        int i = 0;
        TableItem[] tableItemArray = this.varValueList.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem srtItem = tableItemArray[n2];
            this.values.set(i, srtItem.getText());
            ++i;
            ++n2;
        }
    }

    protected void moveSelectionUpEventHandler() {
        System.err.println("moveSelectionUpEventHandler");
        this.exitEditMode();
        if (this.varValueList.getItemCount() == 0) {
            return;
        }
        int[] selIndices = this.varValueList.getSelectionIndices();
        if (selIndices.length == 0) {
            return;
        }
        TableItem[] items = this.varValueList.getItems();
        int startIndex = selIndices[0];
        if (startIndex == 0) {
            return;
        }
        int i = 0;
        while (i < selIndices.length) {
            this.moveBlockSelectionUp(selIndices[i], 1);
            selIndices[i] = selIndices[i] - 1;
            ++i;
        }
        this.varValueList.setSelection(selIndices);
        this.tableValueToModel();
        this.varValueList.notifyListeners(24, new Event());
    }

    private void moveBlockSelectionUp(int startIndex, int count) {
        if (startIndex == 0) {
            return;
        }
        TableItem[] items = this.varValueList.getItems();
        String beforeSelection = items[startIndex - 1].getText();
        int i = 0;
        while (i < count) {
            this.varValueList.getItem(startIndex + i - 1).setText(items[startIndex + i].getText());
            ++i;
        }
        int lastIndex = startIndex + count - 1;
        this.varValueList.getItem(lastIndex).setText(beforeSelection);
    }

    private void moveBlockSelectionDown(int startIndex, int count) {
        int lastIndex = startIndex + count - 1;
        TableItem[] items = this.varValueList.getItems();
        if (lastIndex == items.length - 1) {
            return;
        }
        String afterSelection = items[lastIndex + 1].getText();
        int i = 0;
        while (i < count) {
            this.varValueList.getItem(startIndex + i + 1).setText(items[startIndex + i].getText());
            ++i;
        }
        this.varValueList.getItem(startIndex).setText(afterSelection);
    }

    private void updateTable() {
        this.varValueList.removeAll();
        if (this.values.isEmpty()) {
            return;
        }
        for (String srtItem : this.values) {
            TableItem item = new TableItem(this.varValueList, 0);
            item.setText(srtItem.trim());
        }
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public void setErrorMessage(String error) {
        if (error == null) {
            this.controlDecoration.hide();
            this.controlDecoration.setDescriptionText(error);
        } else {
            this.controlDecoration.setImage(SharedImages.ERROR);
            this.controlDecoration.show();
            this.controlDecoration.setDescriptionText(error);
        }
    }

    public ControlDecoration getControlDecoration() {
        return this.controlDecoration;
    }

    public Control getControl() {
        return this.controlContainer;
    }
}

