/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.userservice.local;

import com.biotechvana.commons.ftpservice.IFTPManager;
import com.biotechvana.commons.model.RemoteServerInfo;
import com.biotechvana.commons.model.UserLoginInfo;
import com.biotechvana.users.IUsersService;
import com.biotechvana.users.InvalidLoginInfoException;
import com.biotechvana.users.UserManager;
import com.biotechvana.userservice.local.LocalUserManager;
import com.biotechvana.utils.IPrefs;
import com.biotechvana.utils.PreferenceManager;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.List;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;

public class LocalUsersServiceImpl
implements IUsersService {
    private static String PREF_STORE_PATH = "com.biotechvana.userservice.local.UsersServiceImpl";
    ISecurePreferences prefs;
    UserManager currentUserManager;
    MApplication application;
    @Inject
    IFTPManager ftpManager;
    private List<UserLoginInfo> users;
    private List<RemoteServerInfo> hostsInfo;
    private UserLoginInfo activeLogin = null;

    @Inject
    public void setMApplication(@Optional MApplication application) {
        this.application = application;
        this.setActiveLoginInCntx();
    }

    public List<UserLoginInfo> getLoginInfoList() {
        return this.users;
    }

    public List<RemoteServerInfo> getHostsInfoList() {
        return this.hostsInfo;
    }

    public void addLoginInfo(UserLoginInfo newInfo) {
        this.users.add(newInfo);
    }

    @PostConstruct
    public void init(IEclipseContext context) {
        ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
        this.prefs = preferences.node(PREF_STORE_PATH);
        this.currentUserManager = (UserManager)ContextInjectionFactory.make(LocalUserManager.class, (IEclipseContext)context);
        PreferenceManager.preferenceManager = new PreferenceManager(){

            protected IPrefs resolvePreference() {
                return new IPrefs(){

                    public void put(String propKey, String propValue) {
                        (this).LocalUsersServiceImpl.this.currentUserManager.put(propKey, propValue);
                    }

                    public String get(String propKey, String defaultValue) {
                        return (this).LocalUsersServiceImpl.this.currentUserManager.get(propKey, defaultValue);
                    }

                    public void savePreferences() {
                        (this).LocalUsersServiceImpl.this.currentUserManager.savePreferences();
                    }
                };
            }
        };
        context.set(UserManager.class, (Object)this.currentUserManager);
    }

    public boolean initLogin() throws Exception {
        String activeUserNode = null;
        try {
            activeUserNode = this.prefs.get("ACTIVE_LOGIN", null);
            if (this.prefs.nodeExists(activeUserNode)) {
                ISecurePreferences userPrefs = this.prefs.node(activeUserNode);
                String preferenceEmail = userPrefs.get("email", "");
                String preferenceHost = userPrefs.get("ssh_host", "");
                int preferenceSshPort = userPrefs.getInt("ssh_port", RemoteServerInfo.DEFAULT_SSH_PORT);
                int preferenceFtpPort = userPrefs.getInt("ftp_port", RemoteServerInfo.DEFAULT_FTP_PORT);
                int prefferenceHTTPport = userPrefs.getInt("http_port", RemoteServerInfo.DEFAULT_API_PORT);
                String preferenceScheme = userPrefs.get("ftp_scheme", RemoteServerInfo.Scheme_SFTP);
                int preferenceHTTPport = userPrefs.getInt("http_port", RemoteServerInfo.DEFAULT_API_PORT);
                String preferenceUser = userPrefs.get("ssh_user", "");
                String preferencePassword = userPrefs.get("ssh_password", "");
                UserLoginInfo user = new UserLoginInfo();
                user.setHostInfo(new RemoteServerInfo(preferenceHost, preferenceHost, preferenceHTTPport, preferenceSshPort, preferenceFtpPort));
                user.getHostInfo().setScheme(preferenceScheme);
                user.setUserName(preferenceUser);
                user.setPassword(preferencePassword);
                user.setEmailAddress(preferenceEmail);
                this.activeLogin = user;
                if (this.currentUserManager.setLogin(this.activeLogin)) {
                    this.setActiveLoginInCntx();
                    return true;
                }
            }
        }
        catch (IOException | StorageException e1) {
            throw new Exception("An Unexpected Error happended during login, please contant Support");
        }
        catch (InvalidLoginInfoException e) {
            throw e;
        }
        return false;
    }

    public boolean changeLogin(UserLoginInfo newInfo) {
        String activeUserNode = newInfo.getUserName() + "#" + newInfo.hashCode();
        try {
            if (this.currentUserManager.setLogin(newInfo)) {
                this.activeLogin = newInfo;
                this.prefs.put("ACTIVE_LOGIN", activeUserNode, true);
                ISecurePreferences userPrefs = this.prefs.node(activeUserNode);
                userPrefs.put("email", this.activeLogin.getEmailAddress(), false);
                userPrefs.put("ssh_host", this.activeLogin.getHostInfo().getServerURL(), false);
                userPrefs.put("ssh_port", String.valueOf(this.activeLogin.getHostInfo().getSshPort()), false);
                userPrefs.put("http_port", String.valueOf(this.activeLogin.getHostInfo().getHttpPort()), false);
                userPrefs.put("ssh_user", this.activeLogin.getUserName(), true);
                userPrefs.put("ssh_password", this.activeLogin.getPassword(), true);
                this.setActiveLoginInCntx();
                return true;
            }
        }
        catch (StorageException e) {
            e.printStackTrace();
        }
        catch (InvalidLoginInfoException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public UserLoginInfo getActiveLogin() {
        return this.activeLogin;
    }

    private void setActiveLoginInCntx() {
        if (this.application != null) {
            IEclipseContext appContext = this.application.getContext();
            appContext.set("ACTIVE_LOGIN", (Object)this.activeLogin);
        }
    }

    public UserManager getUserManager() {
        return this.currentUserManager;
    }

    public boolean canLogin(UserLoginInfo newUser) {
        return this.currentUserManager.testConnection(newUser);
    }
}

