/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.userservice.filetransfer;

import com.biotechvana.commons.ftpservice.IFtpFileTransfer;
import com.biotechvana.commons.ftpservice.TransferStatus;
import java.time.Instant;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.eclipse.core.runtime.OperationCanceledException;

public class FileTransferListener
implements CopyStreamListener {
    long real_total = 0L;
    long real_size = 0L;
    int num_files = 0;
    int file_index = 1;
    Instant instant;
    long instant_size = 0L;
    IFtpFileTransfer fileTransferJob;
    public FileObject destFile;
    static int UPDATE_INTERVAL = 1;

    public void bytesTransferred(long totalBytesTransferred, int bytesTransferred, long streamSize) {
        if (this.fileTransferJob.getStatus() == TransferStatus.CANCELING) {
            throw new OperationCanceledException();
        }
        if (this.instant == null) {
            this.instant = Instant.now().plusSeconds(UPDATE_INTERVAL);
            this.instant_size = this.real_total + totalBytesTransferred;
            this.fileTransferJob.updateTransferedBytes(totalBytesTransferred);
        } else if (Instant.now().isAfter(this.instant)) {
            this.instant = Instant.now().plusSeconds(UPDATE_INTERVAL);
            if (this.fileTransferJob.getStatus() == TransferStatus.CANCELING) {
                try {
                    this.destFile.close();
                }
                catch (FileSystemException e) {
                    e.printStackTrace();
                }
            } else {
                long aux = this.real_total + totalBytesTransferred;
                this.fileTransferJob.updateTransferedBytes(totalBytesTransferred, aux - this.instant_size);
                this.instant_size = aux;
            }
        }
    }

    @Deprecated
    public void bytesTransferred(CopyStreamEvent arg0) {
    }
}

