/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.userservice.filetransfer;

import com.biotechvana.commons.ftpservice.FileTransferJob;
import com.biotechvana.commons.ftpservice.IFTPQueue;
import com.biotechvana.commons.ftpservice.IFileTransferJob;
import com.biotechvana.commons.ftpservice.IFtpFileTransfer;
import com.biotechvana.commons.ftpservice.TransferStatus;
import com.biotechvana.commons.ftpservice.TransferType;
import com.biotechvana.commons.model.ILocalFile;
import com.biotechvana.userservice.filetransfer.FtpFileTransferImpl;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.Selectors;

public class FileTransferJobImpl
extends FileTransferJob {
    String source;
    String destination;

    public FileTransferJobImpl(IFTPQueue queue, String source, String destination, TransferType transferType) {
        this.source = source;
        this.destination = destination;
        this.transferType = transferType;
        this.queue = queue;
        this.ftpManagerImpl = queue.getFTPManager();
        queue.addJob((IFileTransferJob)this);
    }

    private FileObject checkUploadDestination(FileObject sourceFile) throws IOException {
        FileObject remoteFile = (FileObject)this.ftpManagerImpl.resolveRemoteFile(this.destination).getFileObject();
        if (remoteFile.isFile()) {
            remoteFile = remoteFile.getParent();
        }
        remoteFile = remoteFile.resolveFile(remoteFile.getName().getPath() + "/" + sourceFile.getName().getBaseName());
        return remoteFile;
    }

    private FileObject checkUploadSource() throws IOException {
        ILocalFile localFile = this.ftpManagerImpl.resolveLocalFile(this.source);
        return (FileObject)localFile.getFileObject();
    }

    private FileObject checkDownloadSource() throws IOException {
        FileObject remoteFile = (FileObject)this.ftpManagerImpl.resolveRemoteFile(this.source).getFileObject();
        if (!remoteFile.exists()) {
            throw new FileNotFoundException();
        }
        return remoteFile;
    }

    private FileObject checkDownloadDestination(FileObject remote) throws IOException {
        FileObject local = (FileObject)this.getFtpManagerImpl().resolveLocalFile(this.destination).getFileObject();
        if (local.exists() && local.isFolder() && local.isFolder()) {
            local = (FileObject)this.getFtpManagerImpl().resolveLocalFile(this.destination + "/" + remote.getName().getBaseName()).getFileObject();
        }
        return local;
    }

    public String getSource() {
        return this.source;
    }

    public String getDestination() {
        return this.destination;
    }

    public void handleTransferJob() {
        try {
            FileObject destinationFile;
            FileObject sourceFile;
            if (this.getStatus() == TransferStatus.CANCELING || this.getStatus() == TransferStatus.STOPED) {
                if (this.getStatus() == TransferStatus.CANCELING) {
                    this.changeStatus(TransferStatus.STOPED);
                }
                return;
            }
            this.changeStatus(TransferStatus.RESOLVING);
            ArrayList files = new ArrayList();
            if (this.transferType == TransferType.DOWNLOAD) {
                sourceFile = this.checkDownloadSource();
                destinationFile = this.checkDownloadDestination(sourceFile);
            } else {
                sourceFile = this.checkUploadSource();
                destinationFile = this.checkUploadDestination(sourceFile);
            }
            System.out.print("calling sourceFile.findFiles");
            sourceFile.findFiles(Selectors.SELECT_ALL, false, files);
            System.out.print("finished sourceFile.findFiles");
            this.totalNumberOfFiles = files.size();
            for (FileObject srcFile : files) {
                if (this.getStatus() == TransferStatus.CANCELING || this.getStatus() == TransferStatus.STOPED) {
                    if (this.getStatus() == TransferStatus.CANCELING) {
                        this.changeStatus(TransferStatus.STOPED);
                    }
                    return;
                }
                if (!srcFile.isFile()) continue;
                String relPath = sourceFile.getName().getRelativeName(srcFile.getName());
                FileObject destFile = destinationFile.resolveFile(relPath, NameScope.DESCENDENT_OR_SELF);
                FtpFileTransferImpl fileTransferJob = new FtpFileTransferImpl(srcFile, destFile, srcFile.getContent().getSize(), this.transferType, this);
                this.add((IFtpFileTransfer)fileTransferJob);
                this.totalTransferSize += srcFile.getContent().getSize();
                this.queue.fileTransferJobUpdated((IFileTransferJob)this);
                this.queue.addJob((IFtpFileTransfer)fileTransferJob);
                if (files.size() <= 1000) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.totalNumberOfFiles = this.jobFiles.size();
            this.changeStatus(TransferStatus.RUNNING);
            this.doneResolving = true;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.checkFinalStatus();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

