/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.userservice.filetransfer;

import com.biotechvana.commons.IFileTransferService;
import com.biotechvana.commons.ftpservice.IFTPManager;
import com.biotechvana.commons.ftpservice.IFTPQueue;
import com.biotechvana.commons.ftpservice.IRemoteFile;
import com.biotechvana.commons.ftpservice.TransferType;
import com.biotechvana.commons.viewers.IFTPBrowser;
import com.biotechvana.commons.viewers.IFileBrowser;
import com.biotechvana.userservice.filetransfer.FileTransferJobImpl;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class FTPFileTransferService
implements IFileTransferService {
    @Inject
    IFTPManager manager;
    @Inject
    IFTPQueue ftpQueue;
    IFTPBrowser ftpViewer;
    IFileBrowser fileBrowser;
    @Inject
    @Named(value="activeShell")
    private Shell activeShell;

    @Inject
    public void setActiveFTPViewer(@Optional IFTPBrowser ftpViewer) {
        this.ftpViewer = ftpViewer;
    }

    @Inject
    public void setActiveFileBrowser(@Optional IFileBrowser fileBrowser) {
        this.fileBrowser = fileBrowser;
    }

    public void uploadFiles(List<Object> sourceFiles, String targetFolder) {
        for (Object source : sourceFiles) {
            this.uploadFile(source, targetFolder);
        }
    }

    public void uploadFile(Object source, String targetFolder) {
        FileTransferJobImpl createdJob = new FileTransferJobImpl(this.ftpQueue, (String)source, targetFolder, TransferType.UPLOAD);
    }

    public void downloadFiles(List<String> ftpFilesList, Object targetFolder) {
        if (this.fileBrowser != null) {
            targetFolder = this.fileBrowser.getSelectedPath();
        }
        if (targetFolder == null) {
            return;
        }
        for (String source : ftpFilesList) {
            this.downloadFile(source, targetFolder);
        }
    }

    public void downloadFile(String source, Object targetFolder) {
        FileTransferJobImpl createdJob = new FileTransferJobImpl(this.ftpQueue, source, (String)targetFolder, TransferType.DOWNLOAD);
    }

    public void customDropCapability(Control control) {
        int operations = 7;
        Transfer[] transfers = new Transfer[]{FileTransfer.getInstance()};
        DropTarget target = new DropTarget(control, operations);
        target.setTransfer(transfers);
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String dropFolder = null;
                dropFolder = event.item != null ? ((IRemoteFile)((TableItem)event.item).getData()).getPath() : FTPFileTransferService.this.manager.getWorkingDirectory().getPath();
                this.performDrop((String[])event.data, dropFolder);
            }

            private void performDrop(String[] data, String dropFolder) {
                String[] stringArray = data;
                int n = data.length;
                int n2 = 0;
                while (n2 < n) {
                    String source = stringArray[n2];
                    FTPFileTransferService.this.uploadFile(source, dropFolder);
                    ++n2;
                }
            }
        });
    }

    public void uploadFilesTo(String destination) {
        InputDialog dialog = new InputDialog(this.activeShell, "Select Files to Upload", "Enter Source", "", null);
        int res = dialog.open();
        if (res == 1) {
            return;
        }
        if (dialog.getValue().isBlank()) {
            return;
        }
        String source = dialog.getValue();
        this.uploadFile(source, destination);
    }

    public void downloadFilesFrom(String sourceFile) {
        InputDialog dialog = new InputDialog(this.activeShell, "Download", "Enter Destination", "", null);
        int res = dialog.open();
        if (res == 1) {
            return;
        }
        String destination = dialog.getValue();
        destination = destination.replaceAll("\\s+", "_");
        destination = destination.replaceAll("\\(|\\)|\\[|\\|\\\\|/", "");
        this.downloadFile(sourceFile, destination);
    }

    public boolean canUseUIUpload() {
        return true;
    }
}

