/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.workflow.starters;

import com.biotechvana.workflow.WorkflowStartupJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.variables.FileListVariable;

public class PipelineVariantStarter
extends WorkflowStartupJob {
    boolean forPairEnd = true;
    public static String JOB_ID = "VariantSeq_Workflow_Options";
    public static final String JOB_NAME = "Pipeline Configuration";
    public static final String OUTPUT_FILES = "OUTPUT_FILES";
    public static final String INPUT_GROUP_LABLES = "INPUT_GROUPS";
    public static final String INPUT_LIBRARY_NAMES = "INPUT_LIBRARY";
    public static final String INPUT_REF_FASTA = "INPUT_REF_FASTA";
    public static final String INPUT_REF_INDEX = "INPUT_REF_INDEX";
    public static final String INPUT_REF_INDEX_CHOICE = "INPUT_REF_INDEX_CHOICE";
    public static final String INPUT_REF_INDEX_PREFIX = "INPUT_REF_INDEX_PREFIX";
    public static final String INPUT_REF_ANNOTATION = "INPUT_REF_ANNOTATION";
    public static final String OUTPUT_REF_INDEX = "OUTPUT_REF_INDEX";
    public static final String OUTPUT_REF_INDEX_FASTA = "OUTPUT_REF_INDEX_FASTA";
    public static final String INPUT_GROUPS_TO_COMPARE = "INPUT_GROUPS_TO_COMPARE";

    public PipelineVariantStarter() {
        this(true);
    }

    public PipelineVariantStarter(boolean forPairEnd) {
        super(JOB_ID, JOB_NAME);
        this.jobDesc.setDesc("Review and setup Configuration for a Variant Analysis.");
        this.forPairEnd = forPairEnd;
        this.setForPE(forPairEnd);
    }

    protected void createInputs() {
        VariableDescriptor varFastaQ = VariableDescriptor.createDescriptorFor((String)"INPUT_FILES", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varFastaQ.isRequired = true;
        varFastaQ.setVariableName("FASTQ");
        varFastaQ.addAcceptedFileFormat("FASTQ", this.forPairEnd, false);
        this.jobDesc.addVariable(varFastaQ);
        VariableDescriptor varOption = VariableDescriptor.createDescriptorFor((String)INPUT_LIBRARY_NAMES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Strings, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Internal);
        varOption.setVariableName("Libray names - output files");
        varOption.setHelpMsg("");
        this.jobDesc.addVariable(varOption);
        super.createInputs();
    }

    protected void createOutputs() {
        VariableDescriptor outputListOfAllInputFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        outputListOfAllInputFile.setVariableName("Input Files");
        outputListOfAllInputFile.addAcceptedFileFormat("FASTQ", false, true);
        this.jobDesc.addVariable(outputListOfAllInputFile);
        super.createOutputs();
    }

    protected void createRules() {
        this.addVariableMap(OUTPUT_FILES, this.getVariable("INPUT_FILES"));
        super.createRules();
    }

    private void setForPE(boolean b) {
        FileListVariable varFiles = (FileListVariable)this.getVariable("INPUT_FILES");
        varFiles.setIsPairedFiles(b);
    }
}

