/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.workflow.manager;

import com.biotechvana.shared.jobs.SharedCatalog;
import com.biotechvana.shared.jobs.mapping.MappingBowtie2Job;
import com.biotechvana.shared.jobs.mapping.MappingBwaJob;
import com.biotechvana.shared.jobs.mapping.MappingHisat2Job;
import com.biotechvana.shared.jobs.mapping.MappingSTARJob;
import com.biotechvana.shared.jobs.mapping.MappingTophatJob;
import com.biotechvana.shared.jobs.preprocessing.PreProcessingCUTADAPTJob;
import com.biotechvana.shared.jobs.preprocessing.PreProcessingFASTAQCJob;
import com.biotechvana.shared.jobs.preprocessing.PreProcessingFastqCollapserJob;
import com.biotechvana.shared.jobs.preprocessing.PreProcessingFastqIntersectJob;
import com.biotechvana.shared.jobs.preprocessing.PreProcessingFastqMidCleanerJob;
import com.biotechvana.shared.jobs.preprocessing.PreProcessingPRINSEQJob;
import com.biotechvana.shared.jobs.preprocessing.PreProcessingTrimmomaticJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastaClippingHistogramJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastaFormatterJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastaNucleotidesChangerJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastqQualityChartJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastqQualityFilterJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastqToFastaJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastxArtifactsFilterJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastxBarcodeSplitterJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastxClipperJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastxCollapserJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastxNucleotideDistJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastxRenamerJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastxReverseComplementjOB;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastxStatisticsJob;
import com.biotechvana.shared.jobs.preprocessing.fastxtools.FastxtoolkitFastxTrimmerJob;
import com.biotechvana.variantseq.jobs.annotation.AnnotationANNOVARJob;
import com.biotechvana.variantseq.jobs.annotation.AnnotationVEPJob;
import com.biotechvana.variantseq.jobs.calling.CallingContraJob;
import com.biotechvana.variantseq.jobs.calling.gatk.GATKCombineGVCFsJob;
import com.biotechvana.variantseq.jobs.calling.gatk.GATKGenotypeGVCFJob;
import com.biotechvana.variantseq.jobs.calling.gatk.GATKGermlineCNVCallerJob;
import com.biotechvana.variantseq.jobs.calling.gatk.GATKHaplotypeCallerJob;
import com.biotechvana.variantseq.jobs.calling.gatk.GATKMutec2Job;
import com.biotechvana.variantseq.jobs.calling.varscan2.VarScanCNVJob;
import com.biotechvana.variantseq.jobs.calling.varscan2.VarScanSomaticJob;
import com.biotechvana.variantseq.jobs.calling.varscan2.VarScanTrioJob;
import com.biotechvana.variantseq.jobs.calling.varscan2.Varscan2GermlineVariantsJob;
import com.biotechvana.variantseq.jobs.filtering.gatk.CrossSampleContaminationJob;
import com.biotechvana.variantseq.jobs.filtering.gatk.GATKCreateSomaticPanelOfNormalsJob;
import com.biotechvana.variantseq.jobs.filtering.gatk.GATKFilterMutectCallsJob;
import com.biotechvana.variantseq.jobs.filtering.gatk.GATKVariantFiltrationJob;
import com.biotechvana.variantseq.jobs.filtering.gatk.GATKVariantQualityScoreRecalibrationJob;
import com.biotechvana.variantseq.jobs.postprocessing.gatk.BaseScoreQualityRecalibrationJob;
import com.biotechvana.variantseq.jobs.postprocessing.gatk.GATKSplitNCigarReadsJob;
import com.biotechvana.variantseq.jobs.postprocessing.gatk.IndelLocalRealignmentJob;
import com.biotechvana.variantseq.jobs.postprocessing.gatk.LeftAlignIndelJob;
import com.biotechvana.variantseq.jobs.postprocessing.picard.CoverageAnalysisJob;
import com.biotechvana.variantseq.jobs.postprocessing.picard.PicardAddReplaceReadGroupsJob;
import com.biotechvana.variantseq.jobs.postprocessing.picard.PicardBuildBamIndexJob;
import com.biotechvana.variantseq.jobs.postprocessing.picard.PicardCreateSequenceDictionaryJob;
import com.biotechvana.variantseq.jobs.postprocessing.picard.PicardMarkDuplicatesJob;
import com.biotechvana.variantseq.jobs.postprocessing.picard.PicardMergeSamFilesJob;
import com.biotechvana.variantseq.jobs.postprocessing.picard.PostProcessingPicardJob;
import com.biotechvana.variantseq.jobs.postprocessing.samtools.SAMToolsIndexJob;
import com.biotechvana.variantseq.jobs.postprocessing.samtools.SAMToolsMergeJob;
import com.biotechvana.variantseq.jobs.postprocessing.samtools.SAMToolsSortJob;
import com.biotechvana.variantseq.jobs.postprocessing.umic.UMIcJob;
import com.biotechvana.variantseq.jobs.trainingset.PostProcessingGenerateTrainingSetJob;
import com.biotechvana.variantseq.jobs.vqshaplotyper.CheckMetadataJob;
import com.biotechvana.variantseq.jobs.vqshaplotyper.MISeqRAVQAPiplineJob;
import com.biotechvana.variantseq.jobs.vqshaplotyper.VQSHaplotyperJob;
import com.biotechvana.variantseq.workflow.starters.PipelineGSVCStarter;
import com.biotechvana.variantseq.workflow.starters.PipelineVariantStarter;
import com.biotechvana.workflow.manager.JobsCatalog;
import com.biotechvana.workflow.ui.menus.JobsToolBox;
import com.biotechvana.workflow.ui.menus.JobsToolBoxItem;
import com.biotechvana.workflow.ui.menus.JobsToolBoxItemList;
import com.biotechvana.workflow.ui.menus.JobsToolBoxJobItemTool;

public class VariantSeqJobsCatalog
extends JobsCatalog {
    public static final String SNPINDELS_PRTOCOL = "SNP/Indels";
    public static final String VQSHAPLOTYPER_PRTOCOL = "VQS/Haplotyper";

    static {
        toolboxPerApp.put(SNPINDELS_PRTOCOL, VariantSeqJobsCatalog.createSNPandINDELsToolboox());
        toolboxPerApp.put(VQSHAPLOTYPER_PRTOCOL, VariantSeqJobsCatalog.createVQSHaplotyperToolbox());
        defaultToolBoxId = SNPINDELS_PRTOCOL;
    }

    public VariantSeqJobsCatalog(ClassLoader classLoader) {
        super(classLoader);
    }

    private static Object createVQSHaplotyperToolbox() {
        JobsToolBox vqshaplotyperToolbox = new JobsToolBox();
        vqshaplotyperToolbox.setName(VQSHAPLOTYPER_PRTOCOL);
        JobsToolBoxJobItemTool item = new JobsToolBoxJobItemTool("Check Metadata", CheckMetadataJob.class);
        vqshaplotyperToolbox.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("Quality Analysis Pipeline", MISeqRAVQAPiplineJob.class);
        vqshaplotyperToolbox.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("VQS Haplotyper", VQSHaplotyperJob.class);
        vqshaplotyperToolbox.addItem((JobsToolBoxItem)item);
        return vqshaplotyperToolbox;
    }

    protected void initCatalog() {
        SharedCatalog.initCatalog((JobsCatalog)this);
        JobsCatalog.JobCatalogItem jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "Pipeline Configuration", PipelineVariantStarter.JOB_ID, PipelineVariantStarter.class.getName());
        this.jobsItems.add(jobItem);
        jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "Pipeline Configuration", PipelineGSVCStarter.JOB_ID, PipelineGSVCStarter.class.getName());
        this.jobsItems.add(jobItem);
        jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "Picard - AddReplaceReadGroups", "picardAddReplaceReadGroups", PicardAddReplaceReadGroupsJob.class.getName());
        this.jobsItems.add(jobItem);
        jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "Picard - MarkDuplicates", "picardMarkDuplicates", PicardMarkDuplicatesJob.class.getName());
        this.jobsItems.add(jobItem);
        jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "Picard tools : BuildBamIndex", "picardBuildBamIndex", PicardBuildBamIndexJob.class.getName());
        this.jobsItems.add(jobItem);
        jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "Picard - CreateSequenceDictionary", "picardCreateSequenceDictionary", PicardCreateSequenceDictionaryJob.class.getName());
        this.jobsItems.add(jobItem);
        jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "Picard - MergeSamFiles", "picardMergeSamFiles", PicardMergeSamFilesJob.class.getName());
        this.jobsItems.add(jobItem);
        jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "GATK - Variant Quality Score Recalibration", "VQSR", GATKVariantQualityScoreRecalibrationJob.class.getName());
        this.jobsItems.add(jobItem);
        jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "GATK - CombineGVCFs", "combineGVCFs", GATKCombineGVCFsJob.class.getName());
        this.jobsItems.add(jobItem);
        jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "GATK - CreateSomaticPanelOfNormals", "createSomaticPON", GATKCreateSomaticPanelOfNormalsJob.class.getName());
        this.jobsItems.add(jobItem);
        jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "GATK - FilterMutectCalls", "filterMutectCalls", GATKFilterMutectCallsJob.class.getName());
        this.jobsItems.add(jobItem);
        jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "GATK - GenotypeGVCFs", "genotypeGVCFs", GATKGenotypeGVCFJob.class.getName());
        this.jobsItems.add(jobItem);
        jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "Call CNVs with Germline CNV Caller", "germlineCNVCaller", GATKGermlineCNVCallerJob.class.getName());
        this.jobsItems.add(jobItem);
        jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "GATK - HaplotypeCaller", "haplotypeCaller", GATKHaplotypeCallerJob.class.getName());
        this.jobsItems.add(jobItem);
        jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "Mutect2", "mutect2", GATKMutec2Job.class.getName());
        this.jobsItems.add(jobItem);
        jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "SplitNCigarReads", "splitNCigarReads", GATKSplitNCigarReadsJob.class.getName());
        this.jobsItems.add(jobItem);
        jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "BQSR", "BQSR", BaseScoreQualityRecalibrationJob.class.getName());
        this.jobsItems.add(jobItem);
        jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "GATK - VariantFiltration", "variantFiltration", GATKVariantFiltrationJob.class.getName());
        this.jobsItems.add(jobItem);
        jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "Varscan2 Germline variants", "mpileup2VarScan", Varscan2GermlineVariantsJob.class.getName());
        this.jobsItems.add(jobItem);
        jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "VarScan2 somatic variants", "somaticVarScan", VarScanSomaticJob.class.getName());
        this.jobsItems.add(jobItem);
        jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "VarScan2 trio calling", "trioVarScan", VarScanTrioJob.class.getName());
        this.jobsItems.add(jobItem);
        jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "VarScan2 - copynumber", "copynumberVarScan", VarScanCNVJob.class.getName());
        this.jobsItems.add(jobItem);
        jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "Coverage Analysis", "coverage", CoverageAnalysisJob.class.getName());
        this.jobsItems.add(jobItem);
        jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "VEP- Variant Effect Prediction", "annotationVEP", AnnotationVEPJob.class.getName());
        this.jobsItems.add(jobItem);
        jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "Generate Training Set", "generateTrainingSet", PostProcessingGenerateTrainingSetJob.class.getName());
        this.jobsItems.add(jobItem);
        jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "Check Metadata", "checkMetadata", CheckMetadataJob.class.getName());
        this.jobsItems.add(jobItem);
        jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "Quality Analysis Pipeline", "QualityAnalysisPipeline", MISeqRAVQAPiplineJob.class.getName());
        this.jobsItems.add(jobItem);
        jobItem = new JobsCatalog.JobCatalogItem((JobsCatalog)this, "VQS Haplotyper", "VQSHaplotyper", VQSHaplotyperJob.class.getName());
        this.jobsItems.add(jobItem);
    }

    public static JobsToolBox createPreProcessingToolbox() {
        JobsToolBox preProcessingToolbox = new JobsToolBox();
        preProcessingToolbox.setName("PreProcessing");
        JobsToolBoxItemList qualityAnalysis = new JobsToolBoxItemList("Quality Analysis");
        JobsToolBoxJobItemTool item = new JobsToolBoxJobItemTool("FASTQC", PreProcessingFASTAQCJob.class.getName());
        qualityAnalysis.addItem((JobsToolBoxItem)item);
        JobsToolBoxItemList demultiplex = new JobsToolBoxItemList("Demultiplex");
        item = new JobsToolBoxJobItemTool("FastqMidCleaner", PreProcessingFastqMidCleanerJob.class.getName());
        demultiplex.addItem((JobsToolBoxItem)item);
        JobsToolBoxItemList TrimmingandCleaning = new JobsToolBoxItemList("Trimming && Cleaning");
        item = new JobsToolBoxJobItemTool("CUTADAPT", PreProcessingCUTADAPTJob.class.getName());
        TrimmingandCleaning.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("PRINSEQ", PreProcessingPRINSEQJob.class.getName());
        TrimmingandCleaning.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("Trimmomatic", PreProcessingTrimmomaticJob.class.getName());
        TrimmingandCleaning.addItem((JobsToolBoxItem)item);
        JobsToolBoxItemList fastax = new JobsToolBoxItemList("Fastx Toolkit");
        TrimmingandCleaning.addItem((JobsToolBoxItem)fastax);
        item = new JobsToolBoxJobItemTool("FASTXTOOLKIT: FASTQ to FASTA", FastxtoolkitFastqToFastaJob.class.getName());
        fastax.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("FASTXTOOLKIT: FASTA Formatter", FastxtoolkitFastaFormatterJob.class.getName());
        fastax.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("FASTXTOOLKIT: FASTA Clipping Histogram", FastxtoolkitFastaClippingHistogramJob.class.getName());
        fastax.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("FASTXTOOLKIT: FASTA Nucleotides Changer", FastxtoolkitFastaNucleotidesChangerJob.class.getName());
        fastax.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("FASTXTOOLKIT: FASTQ Quality Chart", FastxtoolkitFastqQualityChartJob.class.getName());
        fastax.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("FASTXTOOLKIT: FASTQ Quality Filter", FastxtoolkitFastqQualityFilterJob.class.getName());
        fastax.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("FASTXTOOLKIT: FASTX Artifacts Filter", FastxtoolkitFastxArtifactsFilterJob.class.getName());
        fastax.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("FASTXTOOLKIT: FASTX Barcode Splitter", FastxtoolkitFastxBarcodeSplitterJob.class.getName());
        fastax.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("FASTXTOOLKIT: FASTX Clipper", FastxtoolkitFastxClipperJob.class.getName());
        fastax.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("FASTXTOOLKIT: FASTX Collapser", FastxtoolkitFastxCollapserJob.class.getName());
        fastax.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("FASTXTOOLKIT: FASTX Nucleotide Distribution", FastxtoolkitFastxNucleotideDistJob.class.getName());
        fastax.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("FASTXTOOLKIT: FASTX Renamer", FastxtoolkitFastxRenamerJob.class.getName());
        fastax.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("FASTXTOOLKIT: FASTX Reverse Complement", FastxtoolkitFastxReverseComplementjOB.class.getName());
        fastax.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("FASTXTOOLKIT: FASTX Statistics", FastxtoolkitFastxStatisticsJob.class.getName());
        fastax.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("FASTXTOOLKIT: FASTX Trimmer", FastxtoolkitFastxTrimmerJob.class.getName());
        fastax.addItem((JobsToolBoxItem)item);
        JobsToolBoxItemList prepSeq = new JobsToolBoxItemList("PrepSeq");
        item = new JobsToolBoxJobItemTool("FastqCollapser", PreProcessingFastqCollapserJob.class.getName());
        prepSeq.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("FastqIntersect", PreProcessingFastqIntersectJob.class.getName());
        prepSeq.addItem((JobsToolBoxItem)item);
        JobsToolBoxItemList picard = new JobsToolBoxItemList("Picard");
        item = new JobsToolBoxJobItemTool("Picard - CreateSequenceDictionary", PicardCreateSequenceDictionaryJob.class.getName());
        picard.addItem((JobsToolBoxItem)item);
        JobsToolBoxItemList consensus = new JobsToolBoxItemList("Consensus");
        item = new JobsToolBoxJobItemTool("UMIc", UMIcJob.class.getName());
        consensus.addItem((JobsToolBoxItem)item);
        preProcessingToolbox.addItem((JobsToolBoxItem)qualityAnalysis);
        preProcessingToolbox.addItem((JobsToolBoxItem)demultiplex);
        preProcessingToolbox.addItem((JobsToolBoxItem)TrimmingandCleaning);
        preProcessingToolbox.addItem((JobsToolBoxItem)prepSeq);
        preProcessingToolbox.addItem((JobsToolBoxItem)picard);
        preProcessingToolbox.addItem((JobsToolBoxItem)consensus);
        return preProcessingToolbox;
    }

    public static JobsToolBox createSNPandINDELsToolboox() {
        JobsToolBox varAnalysisToolbox = new JobsToolBox();
        varAnalysisToolbox.setName("SNPs && Indels");
        JobsToolBoxItemList preprocessing = new JobsToolBoxItemList("Preprocessing");
        preprocessing.addItems(VariantSeqJobsCatalog.createPreProcessingToolbox().items);
        JobsToolBoxItemList mapping = new JobsToolBoxItemList("Mapping");
        JobsToolBoxItemList dnaMapper = new JobsToolBoxItemList("DNAseq mappers");
        mapping.addItem((JobsToolBoxItem)dnaMapper);
        JobsToolBoxJobItemTool item = new JobsToolBoxJobItemTool("Bowtie2", MappingBowtie2Job.class.getName());
        dnaMapper.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("Bwa", MappingBwaJob.class.getName());
        dnaMapper.addItem((JobsToolBoxItem)item);
        JobsToolBoxItemList rnaMapper = new JobsToolBoxItemList("RNAseq mappers");
        mapping.addItem((JobsToolBoxItem)rnaMapper);
        item = new JobsToolBoxJobItemTool("Tophat2", MappingTophatJob.class.getName());
        rnaMapper.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("STAR", MappingSTARJob.class.getName());
        rnaMapper.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("Hisat2", MappingHisat2Job.class.getName());
        rnaMapper.addItem((JobsToolBoxItem)item);
        JobsToolBoxItemList trainingSet = new JobsToolBoxItemList("Training Sets");
        item = new JobsToolBoxJobItemTool("Generate Training Set", PostProcessingGenerateTrainingSetJob.class.getName());
        trainingSet.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("GATK - CreateSomaticPanelOfNormals", GATKCreateSomaticPanelOfNormalsJob.class.getName());
        trainingSet.addItem((JobsToolBoxItem)item);
        JobsToolBoxItemList postprocessing = new JobsToolBoxItemList("Postprocessing");
        postprocessing.addItem((JobsToolBoxItem)VariantSeqJobsCatalog.createPostProcessingGATKToolsList());
        postprocessing.addItem((JobsToolBoxItem)VariantSeqJobsCatalog.createPicardToolsList());
        postprocessing.addItem((JobsToolBoxItem)VariantSeqJobsCatalog.createSamToolsList());
        postprocessing.addItem((JobsToolBoxItem)new JobsToolBoxJobItemTool("Coverage Analysis", CoverageAnalysisJob.class));
        JobsToolBoxItemList calling = new JobsToolBoxItemList("Variant Calling");
        JobsToolBoxItemList GATKBased = new JobsToolBoxItemList("GATK Based");
        JobsToolBoxItemList gvHCAlt = new JobsToolBoxItemList("Haplotype caller");
        item = new JobsToolBoxJobItemTool("GATK - HaplotypeCaller", GATKHaplotypeCallerJob.class.getName());
        gvHCAlt.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("GATK - CombineGVCFs", GATKCombineGVCFsJob.class.getName());
        gvHCAlt.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("GATK - GenotypeGVCFs", GATKGenotypeGVCFJob.class.getName());
        gvHCAlt.addItem((JobsToolBoxItem)item);
        GATKBased.addItem((JobsToolBoxItem)gvHCAlt);
        item = new JobsToolBoxJobItemTool("Mutect2", GATKMutec2Job.class.getName());
        GATKBased.addItem((JobsToolBoxItem)item);
        calling.addItem((JobsToolBoxItem)GATKBased);
        calling.addItem((JobsToolBoxItem)VariantSeqJobsCatalog.createCallingVarScanToolsList());
        JobsToolBoxItemList annotation = new JobsToolBoxItemList("Annotation");
        item = new JobsToolBoxJobItemTool("VEP- Variant Effect Prediction", AnnotationVEPJob.class);
        annotation.addItem((JobsToolBoxItem)item);
        JobsToolBoxItemList filtering = new JobsToolBoxItemList("Variants Filtering");
        item = new JobsToolBoxJobItemTool("GATK - Variant Quality Score Recalibration", GATKVariantQualityScoreRecalibrationJob.class);
        filtering.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("GATK - VariantFiltration", GATKVariantFiltrationJob.class);
        filtering.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("GATK - Cross-Sample Contamination", CrossSampleContaminationJob.class);
        filtering.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("GATK - FilterMutectCalls", GATKFilterMutectCallsJob.class);
        filtering.addItem((JobsToolBoxItem)item);
        JobsToolBoxItemList statistics = new JobsToolBoxItemList("Statistics");
        JobsToolBoxItemList covarage = new JobsToolBoxItemList("Coverage");
        statistics.addItem((JobsToolBoxItem)covarage);
        JobsToolBoxItemList diagnositics = new JobsToolBoxItemList("Diagnostics");
        statistics.addItem((JobsToolBoxItem)diagnositics);
        varAnalysisToolbox.addItem((JobsToolBoxItem)preprocessing);
        varAnalysisToolbox.addItem((JobsToolBoxItem)mapping);
        varAnalysisToolbox.addItem((JobsToolBoxItem)trainingSet);
        varAnalysisToolbox.addItem((JobsToolBoxItem)postprocessing);
        varAnalysisToolbox.addItem((JobsToolBoxItem)calling);
        varAnalysisToolbox.addItem((JobsToolBoxItem)filtering);
        varAnalysisToolbox.addItem((JobsToolBoxItem)annotation);
        return varAnalysisToolbox;
    }

    static JobsToolBoxItemList createPicardToolsList() {
        JobsToolBoxItemList picardTools = new JobsToolBoxItemList("Picard Tools");
        JobsToolBoxJobItemTool item = new JobsToolBoxJobItemTool("Picard - AddReplaceReadGroups", PicardAddReplaceReadGroupsJob.class.getName());
        picardTools.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("Picard - MarkDuplicates", PicardMarkDuplicatesJob.class.getName());
        picardTools.addItem((JobsToolBoxItem)item);
        return picardTools;
    }

    static JobsToolBoxItemList createPostProcessingGATKToolsList() {
        JobsToolBoxItemList GATKTools = new JobsToolBoxItemList("GATK Tools");
        JobsToolBoxJobItemTool item = new JobsToolBoxJobItemTool("BQSR", BaseScoreQualityRecalibrationJob.class.getName());
        GATKTools.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("SplitNCigarReads", GATKSplitNCigarReadsJob.class.getName());
        GATKTools.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("LeftAlignIndels", LeftAlignIndelJob.class.getName());
        GATKTools.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("Indel Local Realignment", IndelLocalRealignmentJob.class.getName());
        GATKTools.addItem((JobsToolBoxItem)item);
        return GATKTools;
    }

    static JobsToolBoxItemList createCallingGATKToolsList() {
        JobsToolBoxItemList GATKTools = new JobsToolBoxItemList("GATK Tools");
        JobsToolBoxJobItemTool item = new JobsToolBoxJobItemTool("GATK - HaplotypeCaller", GATKHaplotypeCallerJob.class.getName());
        GATKTools.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("GATK - CombineGVCFs", GATKCombineGVCFsJob.class.getName());
        GATKTools.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("GATK - GenotypeGVCFs", GATKGenotypeGVCFJob.class.getName());
        GATKTools.addItem((JobsToolBoxItem)item);
        return GATKTools;
    }

    static JobsToolBoxItemList createCallingVarScanToolsList() {
        JobsToolBoxItemList GATKTools = new JobsToolBoxItemList("VarScan2 Based");
        JobsToolBoxJobItemTool item = new JobsToolBoxJobItemTool("Varscan2 Germline variants", Varscan2GermlineVariantsJob.class.getName());
        GATKTools.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("VarScan2 somatic variants", VarScanSomaticJob.class.getName());
        GATKTools.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("VarScan2 trio calling", VarScanTrioJob.class.getName());
        GATKTools.addItem((JobsToolBoxItem)item);
        return GATKTools;
    }

    static JobsToolBoxItemList createSamToolsList() {
        JobsToolBoxItemList samTools = new JobsToolBoxItemList("SAMTools");
        JobsToolBoxJobItemTool item = new JobsToolBoxJobItemTool("Samtools : Index", SAMToolsIndexJob.class.getName());
        samTools.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("Samtools : Sort", SAMToolsSortJob.class.getName());
        samTools.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("Samtools : Merge", SAMToolsMergeJob.class.getName());
        samTools.addItem((JobsToolBoxItem)item);
        return samTools;
    }

    public static JobsToolBox createCNVsToolboox() {
        JobsToolBox varAnalysisToolbox = new JobsToolBox();
        varAnalysisToolbox.setName("CNSs");
        JobsToolBoxItemList preprocessing = new JobsToolBoxItemList("Preprocessing");
        preprocessing.addItems(VariantSeqJobsCatalog.createPreProcessingToolbox().items);
        JobsToolBoxItemList mapping = new JobsToolBoxItemList("Mapping");
        JobsToolBoxJobItemTool item = new JobsToolBoxJobItemTool("Tophat2", MappingTophatJob.class.getName());
        mapping.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("Hisat2", MappingHisat2Job.class.getName());
        mapping.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("Bowtie2", MappingBowtie2Job.class.getName());
        mapping.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("Bwa", MappingBwaJob.class.getName());
        mapping.addItem((JobsToolBoxItem)item);
        JobsToolBoxItemList postprocessing = new JobsToolBoxItemList("Postprocessing");
        item = new JobsToolBoxJobItemTool("Postprocessing picard", PostProcessingPicardJob.class.getName());
        postprocessing.addItem((JobsToolBoxItem)item);
        JobsToolBoxItemList calling = new JobsToolBoxItemList("CNV Calling");
        item = new JobsToolBoxJobItemTool("CNV Calling - Contra", CallingContraJob.class.getName());
        calling.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("Call CNVs with Germline CNV Caller", GATKGermlineCNVCallerJob.class.getName());
        calling.addItem((JobsToolBoxItem)item);
        JobsToolBoxItemList annotation = new JobsToolBoxItemList("Annotation");
        item = new JobsToolBoxJobItemTool("ANNOVAR Annotation", AnnotationANNOVARJob.class.getName());
        annotation.addItem((JobsToolBoxItem)item);
        item = new JobsToolBoxJobItemTool("VEP- Variant Effect Prediction", AnnotationVEPJob.class.getName());
        annotation.addItem((JobsToolBoxItem)item);
        JobsToolBoxItemList filtering = new JobsToolBoxItemList("Filtering && Priorization");
        varAnalysisToolbox.addItem((JobsToolBoxItem)preprocessing);
        varAnalysisToolbox.addItem((JobsToolBoxItem)mapping);
        varAnalysisToolbox.addItem((JobsToolBoxItem)postprocessing);
        varAnalysisToolbox.addItem((JobsToolBoxItem)calling);
        varAnalysisToolbox.addItem((JobsToolBoxItem)annotation);
        varAnalysisToolbox.addItem((JobsToolBoxItem)filtering);
        return varAnalysisToolbox;
    }
}

