/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.postprocessing.umic;

import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FolderVariable;

public class UMIcJob
extends ISWFJob {
    public static final String JOB_ID = "UMIcJob";
    public static final String JOB_NAME = "UMIc";
    public static final String SCRIPT_NAME = "UMIc.R";
    public static final String INPUT_FOLDER = "INPUT_FOLDER";
    public static final String PARIED_DATA = "PARIED_DATA";
    public static final String UMI_LOC = "UMI_LOC";
    public static final String UMI_LEN = "UMI_LEN";
    public static final String SEQ_LOC = "SEQ_LEN";
    public static final String COUNT_CUTOFF = "COUNT_CUTOFF";
    public static final String UMI_DIST = "UMI_DIST";
    public static final String SEQ_DIST = "SEQ_DIST";

    public UMIcJob() {
        super(JOB_ID, JOB_NAME, true);
        this.jobDesc.setDesc("UMIc is a framework, written in R, implementing a new proposed method for UMI deduplication and reads correction. The method works at nucleotide level, taking into account the frequency and the mean quality of each base.");
    }

    protected void createInputs() {
        VariableDescriptor inputVar = VariableDescriptor.createDescriptorFor((String)INPUT_FOLDER, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Folder, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        inputVar.setVariableName("Input fasta or fasta.gz folder");
        inputVar.isRequired = true;
        this.jobDesc.addVariable(inputVar);
    }

    protected void createOutputs() {
    }

    protected void createOptions() {
        SelectionListVariableDescriptor optionVarSelectionList = VariableDescriptor.SelectionList((String)PARIED_DATA, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVarSelectionList.isRequired = true;
        optionVarSelectionList.setVariableName("Paried Data");
        optionVarSelectionList.setHelpMsg("Type of data - paired or single.");
        optionVarSelectionList.addOptionValue("Paried", "T", "Paried");
        optionVarSelectionList.addOptionValue("Single", "F", "Single");
        optionVarSelectionList.setDefaultIndexValue(0);
        this.jobDesc.addVariable((VariableDescriptor)optionVarSelectionList);
        optionVarSelectionList = VariableDescriptor.SelectionList((String)UMI_LOC, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVarSelectionList.isRequired = true;
        optionVarSelectionList.setVariableName("UMI Location");
        optionVarSelectionList.setHelpMsg("UMI Location.");
        optionVarSelectionList.addOptionValue("R1", "R1", "UMI located in Read1");
        optionVarSelectionList.addOptionValue("R2", "R2", "UMI located in Read2");
        optionVarSelectionList.addOptionValue("R1 & R2", "R1 & R2", "UMI located in Read1 and Read2");
        optionVarSelectionList.setDefaultIndexValue(0);
        this.jobDesc.addVariable((VariableDescriptor)optionVarSelectionList);
        VariableDescriptor optionVar = VariableDescriptor.createDescriptorFor((String)UMI_LEN, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("UMI lenght");
        optionVar.setHelpMsg("Length of the UMI");
        optionVar.isRequired = true;
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)SEQ_LOC, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Sequence lenght");
        optionVar.setHelpMsg("Length of the sequence");
        optionVar.isRequired = true;
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)COUNT_CUTOFF, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Counts Cutoff");
        optionVar.setHelpMsg("Min read counts per UMI, for initial data cleaning.");
        optionVar.isRequired = true;
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)UMI_DIST, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("UMI Distance");
        optionVar.setHelpMsg("Max UMI distance for UMI merging.");
        optionVar.isRequired = true;
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)SEQ_DIST, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Sequence Distance");
        optionVar.setHelpMsg("Max sequence distance for UMI correction.");
        optionVar.isRequired = true;
        this.jobDesc.addVariable(optionVar);
    }

    protected void createRules() {
    }

    protected void generateCommand(StringBuilder builder) {
        String progName = "UMIc.R ";
        FolderVariable inVar1 = (FolderVariable)this.getVariable(INPUT_FOLDER);
        builder.append(BashHelper.command_withTrack((String)inVar1.$(), (String)(progName + "${UMIcJob_INPUT_FOLDER} ${outputFolder} ${UMIcJob_PARIED_DATA} ${UMIcJob_UMI_LOC} ${UMIcJob_UMI_LEN} ${UMIcJob_SEQ_LEN} ${UMIcJob_COUNT_CUTOFF} ${UMIcJob_UMI_DIST} ${UMIcJob_SEQ_DIST}"), (String)JOB_NAME));
    }
}

