/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.postprocessing.samtools;

import com.biotechvana.shared.jobs.SharedCatalog;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class SAMToolsIndexJob
extends ISWFJob {
    public static final String JOB_ID = "samtools_index";
    public static final String JOB_NAME = "Samtools : Index";
    public static final String INPUT_BAM_FILES = "INPUT_FILES";
    public static final String OUTPUT_BAM_FILES = "OUTPUT_BAM_FILES";

    public SAMToolsIndexJob() {
        super(JOB_ID, JOB_NAME);
        this.jobDesc.setDesc("This tool creates a \".bai\" or a \".csi\" Index file from a bam file.");
        this.jobDesc.addPublication(SharedCatalog.getSamtoolsCitation());
    }

    protected void createInputs() {
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)INPUT_BAM_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input Aligned Reads Files");
        varReadInputFile.setHelpMsg("Input [Bam|SAM|CRAM] Files to sort.");
        this.jobDesc.addVariable(varReadInputFile);
    }

    protected void createOutputs() {
        VariableDescriptor bamOutputFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_BAM_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        bamOutputFile.isRequired = true;
        bamOutputFile.setVariableName("Bam Files");
        bamOutputFile.setHelpMsg("Bam Files");
        this.jobDesc.addVariable(bamOutputFile);
    }

    protected void createOptions() {
        SelectionListVariableDescriptor optionVar = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Index Type");
        optionVar.setHelpMsg("Index Type to create.");
        optionVar.addOptionValue("BAI", "-b", "BAI Index");
        optionVar.addOptionValue("CSI", "-c", "CSI Index");
        optionVar.setCommandParamater(" ");
        this.jobDesc.addVariable((VariableDescriptor)optionVar);
    }

    protected void createRules() {
    }

    protected void generateCommand(StringBuilder builder) {
        String cmdPrefix = "samtools index ";
        FilesVariable inputBamFilesVar = (FilesVariable)this.getVariable(INPUT_BAM_FILES);
        FilesVariable outputBamFilesVar = (FilesVariable)this.getVariable(OUTPUT_BAM_FILES);
        builder.append(SAMToolsIndexJob.st((String)"_ext=\"bam\""));
        builder.append(BashHelper.BatcherParallelSingleton((FilesVariable)inputBamFilesVar, (String)SAMToolsIndexJob.st((String)BashHelper.arrayAdd((JobVariable)outputBamFilesVar, (String)"${outputFolder}/${inputFileBaseName}.${_ext}")), (String)(SAMToolsIndexJob.st((String)("ln -s ${_inputFile} " + outputBamFilesVar.$("${_i}"))) + cmdPrefix + this.getOptionParamatersStrAs$() + outputBamFilesVar.$("${_i}")), (String)"samtools index"));
    }
}

