/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.postprocessing.picard;

import com.biotechvana.utils.Constants;
import com.biotechvana.variantseq.jobs.PicardHelper;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class PicardMarkDuplicatesJob
extends ISWFJob {
    public static final String JOB_ID = "picardMarkDuplicates";
    public static final String JOB_NAME = "Picard - MarkDuplicates";
    private static final String OUTPUT_METRICS_FILES = "OUTPUT_METRICS_FILES";
    public static final String INPUT_BAM_FILES = VariantAnaylsisVariableBag.INPUT_BAM_FILES;
    public static final String OUTPUT_BAM_FILES = VariantAnaylsisVariableBag.OUTPUT_BAM_FILES;

    public PicardMarkDuplicatesJob() {
        super(JOB_ID, JOB_NAME);
        this.jobDesc.setDesc(PicardHelper.getDesc("MarkDuplicates : This tool locates and tags duplicate reads in a BAM or SAM file, where duplicate reads are defined as originating from a single fragment of DNA. "));
        PicardHelper.getCitation(this.jobDesc);
        this.jobDesc.addLink(PicardHelper.getManualLink("MarkDuplicates"));
    }

    protected void createInputs() {
        VariableDescriptor varReadInputFile = PicardHelper.createInputBamFilesVar();
        this.jobDesc.addVariable(varReadInputFile);
        VariableDescriptor inputVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        inputVar.setVariableName("Remove Duplicates");
        inputVar.setHelpMsg(" do not write duplicates to the output file instead of writing them with appropriate flags set.");
        inputVar.setCommandParamater("REMOVE_DUPLICATES=true");
        this.jobDesc.addVariable(inputVar);
    }

    protected void createOutputs() {
        VariableDescriptor bamOutputFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_BAM_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        bamOutputFile.isRequired = true;
        bamOutputFile.setVariableName("Bam Files");
        bamOutputFile.setHelpMsg("Bam Files");
        this.jobDesc.addVariable(bamOutputFile);
        VariableDescriptor metricsOutputFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_METRICS_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        metricsOutputFile.setVariableName("metrics Files");
        metricsOutputFile.setHelpMsg("metrics Files");
        this.jobDesc.addVariable(metricsOutputFile);
    }

    protected void createOptions() {
        PicardHelper.createPicardSharedOptions(this.jobDesc);
        this.jobDesc.getVariableDescByCMDSwitch("CREATE_INDEX").setDefaultValue("true");
        VariableDescriptor optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Barcode SAM tag");
        optionVar.setHelpMsg("Barcode SAM tag (ex. BC for 10X Genomics)");
        optionVar.setCommandParamater("BARCODE_TAG");
        optionVar.setCommandParamaterSep("=");
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Read one barcode SAM tag");
        optionVar.setHelpMsg("Read one barcode SAM tag (ex. BX for 10X Genomics)");
        optionVar.setCommandParamater("READ_ONE_BARCODE_TAG");
        optionVar.setCommandParamaterSep("=");
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Read two barcode SAM tag");
        optionVar.setHelpMsg("Read two barcode SAM tag (ex. BX for 10X Genomics)");
        optionVar.setCommandParamater("READ_TWO_BARCODE_TAG");
        optionVar.setCommandParamaterSep("=");
        this.jobDesc.addVariable(optionVar);
        SelectionListVariableDescriptor optionVarSelectionList = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVarSelectionList.setVariableName("TAG DUPLICATE SET MEMBERS");
        optionVarSelectionList.addOptionValue("true");
        optionVarSelectionList.addOptionValue("false");
        optionVarSelectionList.setHelpMsg("If a read appears in a duplicate set, add two tags. The first tag, DUPLICATE_SET_SIZE_TAG (DS), indicates the size of the duplicate set. The smallest possible DS value is 2 which occurs when two reads map to the same portion of the reference only one of which is marked as duplicate. The second tag, DUPLICATE_SET_INDEX_TAG (DI), represents a unique identifier for the duplicate set to which the record belongs. This identifier is the index-in-file of the representative read that was selected out of the duplicate set. Default is false.");
        optionVarSelectionList.setCommandParamater("TAG_DUPLICATE_SET_MEMBERS");
        optionVarSelectionList.setCommandParamaterSep("=");
        this.jobDesc.addVariable((VariableDescriptor)optionVarSelectionList);
        optionVarSelectionList = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVarSelectionList.setVariableName("REMOVE SEQUENCING DUPLICATES");
        optionVarSelectionList.setHelpMsg("If true remove 'optical' duplicates and other duplicates that appear to have arisen from the sequencing process instead of the library preparation process, even if REMOVE_DUPLICATES is false. If REMOVE_DUPLICATES is set, all duplicates are removed and this option is ignored. Default value: false. ");
        optionVarSelectionList.addOptionValue("true");
        optionVarSelectionList.addOptionValue("false");
        optionVarSelectionList.setCommandParamater("REMOVE_SEQUENCING_DUPLICATES");
        optionVarSelectionList.setCommandParamaterSep("=");
        this.jobDesc.addVariable((VariableDescriptor)optionVarSelectionList);
        optionVarSelectionList = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVarSelectionList.setVariableName("Duplicate Tagging Policy");
        optionVarSelectionList.addOptionValue("DontTag");
        optionVarSelectionList.addOptionValue("OpticalOnly");
        optionVarSelectionList.addOptionValue("All");
        optionVarSelectionList.setHelpMsg("Determines how duplicate types are recorded in the DT optional attribute. Default value: DontTag");
        optionVarSelectionList.setCommandParamater("TAGGING_POLICY");
        optionVarSelectionList.setCommandParamaterSep("=");
        this.jobDesc.addVariable((VariableDescriptor)optionVarSelectionList);
        optionVarSelectionList = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVarSelectionList.setVariableName("Assume Sort Order");
        optionVarSelectionList.setHelpMsg("If set, assume that the input file has this order even if the header says otherwise.");
        optionVarSelectionList.addOptionValue("unsorted");
        optionVarSelectionList.addOptionValue("queryname");
        optionVarSelectionList.addOptionValue("coordinate");
        optionVarSelectionList.addOptionValue("duplicate");
        optionVarSelectionList.addOptionValue("unknown");
        optionVarSelectionList.setCommandParamater("ASSUME_SORT_ORDER");
        optionVarSelectionList.setCommandParamaterSep("=");
        this.jobDesc.addVariable(optionVar);
        optionVarSelectionList = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVarSelectionList.setVariableName("Scoring Strategy");
        optionVarSelectionList.setHelpMsg("The scoring strategy for choosing the non-duplicate among candidates. Default value: SUM_OF_BASE_QUALITIES.");
        optionVarSelectionList.addOptionValue("SUM_OF_BASE_QUALITIES");
        optionVarSelectionList.addOptionValue("TOTAL_MAPPED_REFERENCE_LENGTH");
        optionVarSelectionList.addOptionValue("RANDOM");
        optionVarSelectionList.setCommandParamater("DUPLICATE_SCORING_STRATEGY");
        optionVarSelectionList.setCommandParamaterSep("=");
        this.jobDesc.addVariable((VariableDescriptor)optionVarSelectionList);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("OPTICAL DUPLICATE PIXEL DISTANCE");
        optionVar.setHelpMsg("The maximum offset between two duplicate clusters in order to consider them optical duplicates. The default is appropriate for unpatterned versions of the Illumina platform. For the patterned flowcell models, 2500 is moreappropriate. Default value: 100");
        optionVar.setCommandParamater("OPTICAL_DUPLICATE_PIXEL_DISTANCE");
        optionVar.setCommandParamaterSep("=");
        this.jobDesc.addVariable(optionVar);
    }

    protected void createRules() {
    }

    protected void generateCommand(StringBuilder builder) {
        String cmdPrefix = Constants.PIPELINE_PICARD_EXE + " MarkDuplicates " + PicardHelper.getTmpOption();
        FilesVariable inputBamFilesVar = (FilesVariable)this.getVariable(VariantAnaylsisVariableBag.INPUT_BAM_FILES);
        FilesVariable outputBamFilesVar = (FilesVariable)this.getVariable(VariantAnaylsisVariableBag.OUTPUT_BAM_FILES);
        FilesVariable outputMerticsFilesVar = (FilesVariable)this.getVariable(OUTPUT_METRICS_FILES);
        PicardHelper.generateCheckandSortBam(builder, inputBamFilesVar, inputBamFilesVar, "coordinate");
        builder.append(BashHelper.BatcherParallelSingleton((FilesVariable)inputBamFilesVar, (String)(PicardMarkDuplicatesJob.st((String)BashHelper.arrayAdd((JobVariable)outputBamFilesVar, (String)"${outputFolder}/${inputFileBaseName}.bam")) + PicardMarkDuplicatesJob.st((String)BashHelper.arrayAdd((JobVariable)outputMerticsFilesVar, (String)"${outputFolder}/${inputFileBaseName}.metrics.txt"))), (String)(cmdPrefix + this.getOptionParamatersStrAs$() + " VALIDATION_STRINGENCY=LENIENT I=${_inputFile}  O=" + outputBamFilesVar.$("${_i}") + " M=" + outputMerticsFilesVar.$("${_i}")), (String)"MarkDuplicates"));
    }
}

