/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.postprocessing.picard;

import com.biotechvana.utils.Constants;
import com.biotechvana.variantseq.jobs.PicardHelper;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.JobVariable;

public class PicardCreateSequenceDictionaryJob
extends ISWFJob {
    public static final String JOB_ID = "picardCreateSequenceDictionary";
    public static final String JOB_NAME = "Picard - CreateSequenceDictionary";
    public static final String INPUT_REF_FASTA = "INPUT_REF_FASTA";
    public static final String OUTPUT_REF_DICT = "INPUT_REF_DICT";

    public PicardCreateSequenceDictionaryJob() {
        super(JOB_ID, JOB_NAME, true);
        this.jobDesc.setDesc(PicardHelper.getDesc("This tool of Picard creates a sequence dictionary file (with the extension \".dict\") from a reference fasta file. The sequence dictionary is required by several steps and tools of the VariantSeq tool."));
        PicardHelper.getCitation(this.jobDesc);
        this.jobDesc.addLink(PicardHelper.getManualLink("CreateSequenceDictionary"));
    }

    protected void createInputs() {
        VariableDescriptor inputVar = VariableDescriptor.createDescriptorFor((String)INPUT_REF_FASTA, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        inputVar.setVariableName("Input reference fasta or fasta.gz");
        this.jobDesc.addVariable(inputVar);
    }

    protected void createOutputs() {
        VariableDescriptor outputVar = VariableDescriptor.createDescriptorFor((String)OUTPUT_REF_DICT, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        outputVar.setVariableName("Ref Dict");
        outputVar.isRequired = true;
        this.jobDesc.addVariable(outputVar);
    }

    protected void createOptions() {
    }

    protected void createRules() {
    }

    protected void generateCommand(StringBuilder builder) {
        String cmdPrefix = Constants.PIPELINE_PICARD_EXE + " CreateSequenceDictionary " + PicardHelper.getTmpOption();
        JobVariable inputRef = this.getVariable(INPUT_REF_FASTA);
        JobVariable OutDict = this.getVariable(OUTPUT_REF_DICT);
        builder.append(BashHelper.command_withTrack((String)inputRef.$(), (String)(cmdPrefix + this.getOptionParamatersStrAs$() + "R=" + inputRef.$()), (String)"CreateSequenceDictionary"));
    }
}

