/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.postprocessing.picard;

import com.biotechvana.utils.Constants;
import com.biotechvana.variantseq.jobs.PicardHelper;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashConditions;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class PicardAddReplaceReadGroupsJob
extends ISWFJob {
    public static final String JOB_ID = "picardAddReplaceReadGroups";
    public static final String JOB_NAME = "Picard - AddReplaceReadGroups";
    private static final String INPUT_RG_SM = "INPUT_RG_SM";
    private static final String INPUT_RG_ID = "INPUT_RG_ID";
    private static final String INPUT_RG_LB = "INPUT_RG_LB";
    private static final String INPUT_RG_PL = "INPUT_RG_PL";
    private static final String INPUT_RG_PU = "INPUT_RG_PU";
    public static final String INPUT_BAM_FILES = VariantAnaylsisVariableBag.INPUT_BAM_FILES;
    public static final String OUTPUT_BAM_FILES = VariantAnaylsisVariableBag.OUTPUT_BAM_FILES;

    public PicardAddReplaceReadGroupsJob() {
        super(JOB_ID, JOB_NAME);
        this.jobDesc.setDesc(PicardHelper.getDesc("AddOrReplaceReadGroups : Replace read groups in a BAM file.This tool enables the user to replace all read groups in the INPUT file with a single new read group and assign all reads to this read group in the OUTPUT BAM file."));
        PicardHelper.getCitation(this.jobDesc);
        this.jobDesc.addLink(PicardHelper.getManualLink("AddOrReplaceReadGroups"));
    }

    protected void createInputs() {
        VariableDescriptor varReadInputFile = PicardHelper.createInputBamFilesVar();
        this.jobDesc.addVariable(varReadInputFile);
        VariableDescriptor varInput = VariableDescriptor.createDescriptorFor((String)INPUT_RG_SM, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Strings, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varInput.isRequired = true;
        varInput.setVariableName("Read Group sample name RGSM");
        varInput.setHelpMsg("Read Group sample name RGSM tag");
        this.jobDesc.addVariable(varInput);
        varInput = VariableDescriptor.createDescriptorFor((String)INPUT_RG_ID, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Strings, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varInput.setVariableName("Read Group ID RGID");
        varInput.setHelpMsg("Read Group ID RGID tag. By default will be the input file name.");
        this.jobDesc.addVariable(varInput);
        varInput = VariableDescriptor.createDescriptorFor((String)INPUT_RG_LB, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Strings, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varInput.setVariableName("Read Group library RGLB");
        varInput.setHelpMsg("Read Group library RGLB tag.");
        this.jobDesc.addVariable(varInput);
        varInput = VariableDescriptor.createDescriptorFor((String)INPUT_RG_PL, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varInput.isRequired = true;
        varInput.setVariableName("Read Group platfrom RGPL");
        varInput.setHelpMsg("Read Group platform RGPL tag (e.g. illumina, solid)");
        varInput.setCommandParamater("PL");
        varInput.setDefaultValue("illumina");
        varInput.setCommandParamaterSep("=");
        this.jobDesc.addVariable(varInput);
        varInput = VariableDescriptor.createDescriptorFor((String)INPUT_RG_PU, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varInput.setVariableName("Read Group platfrom unit RGPU");
        varInput.setHelpMsg("Read Group platform RGPU tag (eg. run barcode)");
        varInput.isRequired = true;
        varInput.setCommandParamater("PU");
        varInput.setCommandParamaterSep("=");
        this.jobDesc.addVariable(varInput);
    }

    protected void createOutputs() {
        VariableDescriptor bamOutputFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_BAM_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        bamOutputFile.isRequired = true;
        bamOutputFile.setVariableName("Bam Files");
        bamOutputFile.setHelpMsg("Bam Files");
        this.jobDesc.addVariable(bamOutputFile);
    }

    protected void createOptions() {
        VariableDescriptor optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Read Group sequencing center RGCN");
        optionalVar.setHelpMsg("Read Group sequencing center RGCN tag");
        optionalVar.setCommandParamater("CN");
        optionalVar.setCommandParamaterSep("=");
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Strings, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Read Group description RGDS");
        optionalVar.setHelpMsg("Read Group description RGDS tag");
        this.jobDesc.addVariable(optionalVar);
        PicardHelper.createPicardSharedOptions(this.jobDesc);
        this.jobDesc.getVariableDescByCMDSwitch("CREATE_INDEX").setDefaultValue("true");
        SelectionListVariableDescriptor optionalVarSelectionList = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVarSelectionList.setVariableName("Output Bam Sort Order");
        optionalVarSelectionList.addOptionValue("coordinate");
        optionalVarSelectionList.addOptionValue("queryname");
        optionalVarSelectionList.addOptionValue("duplicate");
        optionalVarSelectionList.setCommandParamaterSep("=");
        optionalVarSelectionList.setHelpMsg("Sort order for the output bam file . If not supplied outptut Bam files will in the same order as input Bam files");
        optionalVarSelectionList.setCommandParamater("SO");
        optionalVarSelectionList.setDefaultIndexValue(0);
        optionalVarSelectionList.setRecommendedValue("coordinate");
        optionalVarSelectionList.setRecommendedValueIndex(0);
        optionalVarSelectionList.setRecommendationDesc("Bam Files should be sorted in coordinate , for downstream analysis in GATK pipelines.");
        this.jobDesc.addVariable((VariableDescriptor)optionalVarSelectionList);
    }

    protected void createRules() {
    }

    public boolean notifyVarValueChanged(String varKey, String value) {
        boolean baseReturn = super.notifyVarValueChanged(varKey, value);
        if (varKey == VariantAnaylsisVariableBag.INPUT_BAM_FILES) {
            String groupsValue;
            String idsValue;
            String librarysValue = this.getValue(INPUT_RG_LB);
            if (librarysValue.isEmpty()) {
                this.assginBaseName(VariantAnaylsisVariableBag.INPUT_BAM_FILES, INPUT_RG_LB);
            }
            if ((idsValue = this.getValue(INPUT_RG_ID)).isEmpty()) {
                this.assginBaseName(VariantAnaylsisVariableBag.INPUT_BAM_FILES, INPUT_RG_ID);
            }
            if ((groupsValue = this.getValue(INPUT_RG_SM)).isEmpty()) {
                this.assginBaseName(VariantAnaylsisVariableBag.INPUT_BAM_FILES, INPUT_RG_SM);
            }
        }
        return baseReturn;
    }

    public boolean isValid() {
        boolean valid = super.isValid();
        if (!this.getVariable(VariantAnaylsisVariableBag.INPUT_BAM_FILES).hasMapping()) {
            valid &= this.validateEqualNumberOfFiles(VariantAnaylsisVariableBag.INPUT_BAM_FILES, INPUT_RG_LB);
            valid &= this.validateEqualNumberOfFiles(VariantAnaylsisVariableBag.INPUT_BAM_FILES, INPUT_RG_SM);
            valid &= this.validateEqualNumberOfFiles(VariantAnaylsisVariableBag.INPUT_BAM_FILES, INPUT_RG_ID);
        }
        return valid;
    }

    protected void generateCommand(StringBuilder builder) {
        String cmdPrefix = Constants.PIPELINE_PICARD_EXE + " AddOrReplaceReadGroups " + PicardHelper.getTmpOption();
        FilesVariable inputBamFilesVar = (FilesVariable)this.getVariable(VariantAnaylsisVariableBag.INPUT_BAM_FILES);
        JobVariable inputIdsFilesVar = this.getVariable(INPUT_RG_ID);
        JobVariable inputGroupsFilesVar = this.getVariable(INPUT_RG_SM);
        JobVariable inputLibraryFilesVar = this.getVariable(INPUT_RG_LB);
        FilesVariable outputBamFilesVar = (FilesVariable)this.getVariable(VariantAnaylsisVariableBag.OUTPUT_BAM_FILES);
        builder.append(BashHelper.Batcher_noLog((FilesVariable)inputBamFilesVar, (String)(PicardAddReplaceReadGroupsJob.st((String)("_RGLB=" + PicardAddReplaceReadGroupsJob.qt((String)inputLibraryFilesVar.$("${_i}")))) + String.valueOf(BashHelper.If((String)BashConditions.emptyStr((String)"${_RGLB}")).Then("_RGLB=${inputFileBaseName}")) + PicardAddReplaceReadGroupsJob.st((String)BashHelper.arrayAdd((JobVariable)outputBamFilesVar, (String)"${outputFolder}/${_RGLB}.bam"))), (boolean)true));
        builder.append(BashHelper.BatcherParallelSingleton((FilesVariable)inputBamFilesVar, (String)(PicardAddReplaceReadGroupsJob.st((String)("_RGID=" + PicardAddReplaceReadGroupsJob.qt((String)inputIdsFilesVar.$("${_i}")))) + PicardAddReplaceReadGroupsJob.st((String)("_RGLB=" + PicardAddReplaceReadGroupsJob.qt((String)inputLibraryFilesVar.$("${_i}")))) + PicardAddReplaceReadGroupsJob.st((String)("_RGSM=" + PicardAddReplaceReadGroupsJob.qt((String)inputGroupsFilesVar.$("${_i}")))) + String.valueOf(BashHelper.If((String)BashConditions.emptyStr((String)"${_RGID}")).Then("_RGID=${inputFileBaseName}")) + PicardAddReplaceReadGroupsJob.st((String)("opt_str=" + PicardAddReplaceReadGroupsJob.qt((String)" ID=${_RGID} LB=${_RGLB} SM=${_RGSM} ")))), (String)(cmdPrefix + this.getOptionParamatersStrAs$() + " VALIDATION_STRINGENCY=LENIENT I=${_inputFile} ${opt_str} O=" + outputBamFilesVar.$("${_i}")), (String)"AddReplaceReadGroups"));
    }
}

