/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.postprocessing.gatk;

import com.biotechvana.variantseq.jobs.GATKHelper;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class LeftAlignIndelJob
extends ISWFJob {
    public static final String JOB_ID = "leftAlignIndels";
    public static final String JOB_NAME = "LeftAlignIndels";
    private static final String INPUT_BAM_FILES = VariantAnaylsisVariableBag.INPUT_BAM_FILES;
    private static final String OUTPUT_BAM_FILES = VariantAnaylsisVariableBag.OUTPUT_BAM_FILES;

    public LeftAlignIndelJob() {
        super(JOB_ID, JOB_NAME);
        GATKHelper.addToolGroup(this.jobDesc);
        this.jobDesc.setDesc("Left-aligns indels from reads in a SAM/BAM/CRAM file");
        this.jobDesc.setRef(GATKHelper.getCitation(GATKHelper.getManualPage(JOB_NAME, "org_broadinstitute_hellbender_tools_LeftAlignIndels.php")));
    }

    protected void createInputs() {
        VariableDescriptor varReferenceFasta = GATKHelper.createReferenceVar();
        this.jobDesc.addVariable(varReferenceFasta);
        VariableDescriptor varReadInputFile = GATKHelper.createInputBamFilesVar();
        this.jobDesc.addVariable(varReadInputFile);
    }

    protected void createOutputs() {
        VariableDescriptor bamOutputFiles = VariableDescriptor.createDescriptorFor((String)OUTPUT_BAM_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        bamOutputFiles.isRequired = true;
        bamOutputFiles.setVariableName("Left algined Bam Files");
        bamOutputFiles.setHelpMsg("Left algined Bam Files");
        this.jobDesc.addVariable(bamOutputFiles);
    }

    protected void createOptions() {
        VariableDescriptor optionalVar = GATKHelper.createOptionInterval();
        this.jobDesc.addVariable(optionalVar);
        optionalVar = GATKHelper.createOptionIntervalMergingRule();
        this.jobDesc.addVariable(optionalVar);
        GATKHelper.createSharedOptions(this.jobDesc, new String[]{GATKHelper.GATK_OPTION_SWITCH_CREATE_BAM_INDEX, GATKHelper.GATK_OPTION_SWITCH_CREATE_BAM_MD5});
    }

    protected void createRules() {
    }

    protected void generateCommand(StringBuilder builder) {
        String cmdPrefix = GATKHelper.getGATKCmdPrefix() + " LeftAlignIndels " + GATKHelper.getTmpOption();
        FilesVariable inputBamFilesVar = (FilesVariable)this.getVariable(VariantAnaylsisVariableBag.INPUT_BAM_FILES);
        FilesVariable outBamFilesVar = (FilesVariable)this.getVariable(OUTPUT_BAM_FILES);
        JobVariable refFileVar = this.getVariable(VariantAnaylsisVariableBag.INPUT_REF_FASTA);
        GATKHelper.checkPrepareReference(builder, refFileVar);
        builder.append(BashHelper.Batcher_noLog((FilesVariable)inputBamFilesVar, (String)LeftAlignIndelJob.st((String)BashHelper.arrayAdd((JobVariable)outBamFilesVar, (String)"${outputFolder}/${inputFileBaseName}.bam")), (boolean)true));
        builder.append(BashHelper.BatcherParallelSingleton((FilesVariable)inputBamFilesVar, (String)"", (String)(cmdPrefix + this.getOptionParamatersStrAs$() + "-I ${_inputFile}  --OUTPUT " + outBamFilesVar.$("${_i}")), (String)"GATK LeftAlignIndels"));
    }
}

