/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.postprocessing.gatk;

import com.biotechvana.variantseq.jobs.GATKHelper;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.IntVariableDescriptor;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class IndelLocalRealignmentJob
extends ISWFJob {
    public static final String JOB_ID = "realignGATK";
    public static final String JOB_NAME = "Indel Local Realignment";
    private static final String OUTPUT_TARGET_INTERVALS = "OUTPUT_TARGET_INTERVALS";
    public static final String OUTPUT_BAM_FILES = VariantAnaylsisVariableBag.OUTPUT_BAM_FILES;
    public static final String INPUT_BAM_FILES = VariantAnaylsisVariableBag.INPUT_BAM_FILES;
    private static final String RealignerTargetCreator = "RealignerTargetCreator";
    private static final String IndelRealigner = "IndelRealigner";

    public IndelLocalRealignmentJob() {
        super(JOB_ID, JOB_NAME);
        this.jobDesc.setDesc("Perform Indel realignment using RealignerTargetCreator and IndelRealigner tools.  indel realignment is no longer necessary for variant discovery if you plan to use a variant caller that performs a haplotype assembly step, such as HaplotypeCaller or MuTect2. However it is still required when using legacy callers such as UnifiedGenotyper or the original MuTect.");
        this.jobDesc.setRef(GATKHelper.getCitation(GATKHelper.getManualPage(RealignerTargetCreator, "org_broadinstitute_hellbender_tools_walkers_bqsr_BaseRecalibrator.php") + "\n" + GATKHelper.getManualPage(IndelRealigner, "org_broadinstitute_hellbender_tools_walkers_bqsr_ApplyBQSR.php")));
    }

    protected void createInputs() {
        VariableDescriptor varReferenceFasta = GATKHelper.createReferenceVar();
        this.jobDesc.addVariable(varReferenceFasta);
        VariableDescriptor varReadInputFile = GATKHelper.createInputBamFilesVar();
        this.jobDesc.addVariable(varReadInputFile);
        VariableDescriptor varKnownSites = GATKHelper.createKnownSitesVar();
        varKnownSites.isRequired = false;
        this.jobDesc.addVariable(varKnownSites);
    }

    protected void createOutputs() {
        VariableDescriptor tatgetIntervalsOutputFiles = VariableDescriptor.createDescriptorFor((String)OUTPUT_TARGET_INTERVALS, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        tatgetIntervalsOutputFiles.isRequired = true;
        tatgetIntervalsOutputFiles.setVariableName("targetIntervals");
        tatgetIntervalsOutputFiles.setHelpMsg("targetIntervals");
        this.jobDesc.addVariable(tatgetIntervalsOutputFiles);
        VariableDescriptor reAlginedBamOutputFiles = VariableDescriptor.createDescriptorFor((String)OUTPUT_BAM_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        reAlginedBamOutputFiles.isRequired = true;
        reAlginedBamOutputFiles.setVariableName("Realgined Bam Files");
        reAlginedBamOutputFiles.setHelpMsg("Realgined Bam Files");
        this.jobDesc.addVariable(reAlginedBamOutputFiles);
    }

    protected void createOptions() {
        IndelLocalRealignmentJob.createOptionsRealignerTargetCreator(this.jobDesc, true);
        IndelLocalRealignmentJob.createOptionsIndelRealigner(this.jobDesc, true);
    }

    protected static void createOptionsIndelRealigner(JobDescriptor jobDesc, boolean setToolGroup) {
        SelectionListVariableDescriptor optionVarSelectionList = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVarSelectionList.setVariableName("Consensus Determination Model");
        optionVarSelectionList.setShortHelpMsg("Determines how to compute the possible alternate consenses");
        optionVarSelectionList.setHelpMsg("GATK recommend that users run with USE_READS when trying to realign high quality longer read data mapped with a gapped aligner; Smith-Waterman is really only necessary when using an ungapped aligner (e.g. MAQ in the case of single-end read data). Default is USE_READS ");
        optionVarSelectionList.addOptionValue("Known Only", "KNOWNS_ONLY", "Uses only indels from a provided ROD of known indels.");
        optionVarSelectionList.addOptionValue("Use Reads", "USE_READS", "Additionally uses indels already present in the original alignments of the reads.");
        optionVarSelectionList.addOptionValue("Use SW", "USE_SW", "Additionally uses 'Smith-Waterman' to generate alternate consenses.");
        optionVarSelectionList.setCommandParamater("-model");
        optionVarSelectionList.setCommandParamaterAlt("--consensusDeterminationModel");
        if (setToolGroup) {
            optionVarSelectionList.setVariableGroup(IndelRealigner);
        }
        optionVarSelectionList.setSubProgName(IndelRealigner);
        jobDesc.addVariable((VariableDescriptor)optionVarSelectionList);
        VariableDescriptor optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("LOD threshold");
        optionVar.setShortHelpMsg("LOD threshold above which the cleaner will clean");
        optionVar.setHelpMsg("LOD threshold above which the cleaner will cleanThis term is equivalent to \"significance\" - i.e. is the improvement significant enough to merit realignment?For low coverage and/or when looking for indels with low allele frequency, this number should be smaller.Note that this number should be adjusted based on your particular data set. Default is 5.0 ");
        optionVar.setCommandParamater("-LOD");
        optionVar.setCommandParamaterAlt("--LODThresholdForCleaning");
        if (setToolGroup) {
            optionVar.setVariableGroup(IndelRealigner);
        }
        optionVar.setSubProgName(IndelRealigner);
        jobDesc.addVariable(optionVar);
    }

    protected static void createOptionsRealignerTargetCreator(JobDescriptor jobDesc, boolean setToolGroup) {
        VariableDescriptor optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Maximum interval size");
        optionVar.setShortHelpMsg("Maximum interval size; any intervals larger than this value will be dropped");
        optionVar.setHelpMsg("Maximum interval size; any intervals larger than this value will be dropped\nBecause the realignment algorithm is N^2, allowing too large an interval might take too long to completely realign. Default is 500");
        optionVar.setCommandParamater("-maxInterval");
        optionVar.setCommandParamaterAlt("--maxIntervalSize");
        if (setToolGroup) {
            optionVar.setVariableGroup(RealignerTargetCreator);
        }
        optionVar.setSubProgName(RealignerTargetCreator);
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Minimum reads at a locus");
        optionVar.setShortHelpMsg("Minimum reads at a locus to enable using the entropy calculation");
        optionVar.setHelpMsg("Minimum reads at a locus to enable using the entropy calculation. Default is 4");
        optionVar.setCommandParamater("-minReads");
        optionVar.setCommandParamaterAlt("--minReadsAtLocus");
        if (setToolGroup) {
            optionVar.setVariableGroup(RealignerTargetCreator);
        }
        optionVar.setSubProgName(RealignerTargetCreator);
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Fraction of base qualities needing to mismatch");
        optionVar.setShortHelpMsg("Fraction of base qualities needing to mismatch for a position to have high entropy");
        optionVar.setHelpMsg("Fraction of base qualities needing to mismatch for a position to have high entropy\nTo disable this behavior, set this value to <= 0 or > 1. This feature is really only necessary when using an ungapped aligner (e.g. MAQ in the case of single-end read data) and should be used in conjunction with '--model USE_SW' in the IndelRealigner. Default is 0.0 ");
        optionVar.setCommandParamater("-mismatch");
        optionVar.setCommandParamaterAlt("--mismatchFraction");
        if (setToolGroup) {
            optionVar.setVariableGroup(RealignerTargetCreator);
        }
        optionVar.setSubProgName(RealignerTargetCreator);
        jobDesc.addVariable(optionVar);
        IntVariableDescriptor optionVarInt = VariableDescriptor.Int((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVarInt.setVariableName("Window size for calculating entropy or SNP clusters");
        optionVarInt.setShortHelpMsg("Window size for calculating entropy or SNP clusters");
        optionVarInt.setHelpMsg("window size for calculating entropy or SNP clusters\nAny two SNP calls and/or high entropy positions are considered clustered when they occur no more than this many basepairs apart. Must be > 1. Default is 10");
        optionVarInt.setCommandParamater("-window");
        optionVarInt.setCommandParamaterAlt("--windowSize");
        optionVarInt.setMinValue(2.0);
        if (setToolGroup) {
            optionVarInt.setVariableGroup(RealignerTargetCreator);
        }
        optionVarInt.setSubProgName(RealignerTargetCreator);
        jobDesc.addVariable((VariableDescriptor)optionVarInt);
    }

    protected void createRules() {
    }

    protected void generateCommand(StringBuilder builder) {
        String cmdPrefixRealignerTargetCreator = GATKHelper.getGATKCmdPrefix(3) + " -T RealignerTargetCreator ";
        String cmdPrefixIndelRealigner = GATKHelper.getGATKCmdPrefix(3) + " -T IndelRealigner ";
        FilesVariable inputBamFilesVar = (FilesVariable)this.getVariable(INPUT_BAM_FILES);
        FilesVariable outTargetsFilesVar = (FilesVariable)this.getVariable(OUTPUT_TARGET_INTERVALS);
        FilesVariable outBamFilesVar = (FilesVariable)this.getVariable(OUTPUT_BAM_FILES);
        JobVariable refFileVar = this.getVariable(VariantAnaylsisVariableBag.INPUT_REF_FASTA);
        GATKHelper.checkPrepareReference(builder, refFileVar);
        builder.append(BashHelper.Batcher_noLog((FilesVariable)inputBamFilesVar, (String)(IndelLocalRealignmentJob.st((String)BashHelper.arrayAdd((JobVariable)outTargetsFilesVar, (String)"${outputFolder}/${inputFileBaseName}.intervals")) + IndelLocalRealignmentJob.st((String)BashHelper.arrayAdd((JobVariable)outBamFilesVar, (String)"${outputFolder}/${inputFileBaseName}.bam"))), (boolean)true));
        builder.append(BashHelper.BatcherParallelSingleton((FilesVariable)inputBamFilesVar, (String)"", (String)(cmdPrefixRealignerTargetCreator + this.getOptionParamatersStrAs$() + this.getOptionParamatersStrAs$(RealignerTargetCreator) + "-I ${_inputFile}  -o " + outTargetsFilesVar.$("${_i}")), (String)RealignerTargetCreator));
        builder.append(BashHelper.BatcherParallelSingleton((FilesVariable)inputBamFilesVar, (String)"", (String)(cmdPrefixIndelRealigner + this.getOptionParamatersStrAs$() + this.getOptionParamatersStrAs$(IndelRealigner) + "-I ${_inputFile}  -targetIntervals " + outTargetsFilesVar.$("${_i}") + " -o " + outBamFilesVar.$("${_i}")), (String)IndelRealigner));
    }
}

