/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.postprocessing.gatk;

import com.biotechvana.variantseq.jobs.GATKHelper;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class GATKBaseRecalibratorJob
extends ISWFJob {
    public static final String JOB_ID = "baseRecalibratorGATK";
    public static final String JOB_NAME = "GATK - BaseRecalibration";
    public static final String OUTPUT_RECALIBRATION_REPORT = "OUTPUT_recalibration_report";
    public static final String INPUT_BAM_FILES = VariantAnaylsisVariableBag.INPUT_BAM_FILES;
    public static final String INPUT_KNOWN_SITES = "INPUT_KNOWN_SITES";

    public GATKBaseRecalibratorJob() {
        super(JOB_ID, JOB_NAME);
        GATKHelper.addToolGroup(this.jobDesc);
        this.jobDesc.setDesc("Base quality score recalibration using GATK-BaseRecalibrator to Detect systematic errors in base quality scores. ");
        this.jobDesc.setRef(GATKHelper.getCitation(GATKHelper.getManualPage("BaseRecalibrator", "org_broadinstitute_hellbender_tools_walkers_bqsr_BaseRecalibrator.php")));
    }

    protected void createInputs() {
        VariableDescriptor varReferenceFasta = GATKHelper.createReferenceVar();
        this.jobDesc.addVariable(varReferenceFasta);
        VariableDescriptor varReadInputFile = GATKHelper.createInputBamFilesVar();
        this.jobDesc.addVariable(varReadInputFile);
        VariableDescriptor varKnownSites = GATKHelper.createKnownSitesVar();
        this.jobDesc.addVariable(varKnownSites);
    }

    protected void createOutputs() {
        VariableDescriptor recalibratioTableOutputFiles = VariableDescriptor.createDescriptorFor((String)OUTPUT_RECALIBRATION_REPORT, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        recalibratioTableOutputFiles.isRequired = true;
        recalibratioTableOutputFiles.setVariableName("recalibration report");
        recalibratioTableOutputFiles.setHelpMsg("recalibration report");
        this.jobDesc.addVariable(recalibratioTableOutputFiles);
    }

    protected void createOptions() {
        GATKHelper.createSharedOptions(this.jobDesc);
        this.jobDesc.getVariableDescByCMDSwitch("-OQ").setDefaultValue("true");
    }

    protected void createRules() {
    }

    protected void generateCommand(StringBuilder builder) {
        String cmdPrefix = GATKHelper.getGATKCmdPrefix() + " BaseRecalibrator " + GATKHelper.getTmpOption();
        FilesVariable inputBamFilesVar = (FilesVariable)this.getVariable(VariantAnaylsisVariableBag.INPUT_BAM_FILES);
        FilesVariable outTableFilesVar = (FilesVariable)this.getVariable(OUTPUT_RECALIBRATION_REPORT);
        JobVariable refFileVar = this.getVariable(VariantAnaylsisVariableBag.INPUT_REF_FASTA);
        GATKHelper.checkPrepareReference(builder, refFileVar);
        builder.append(BashHelper.Batcher_noLog((FilesVariable)inputBamFilesVar, (String)GATKBaseRecalibratorJob.st((String)BashHelper.arrayAdd((JobVariable)outTableFilesVar, (String)"${outputFolder}/${inputFileBaseName}.table")), (boolean)true));
        builder.append(BashHelper.BatcherParallelSingleton((FilesVariable)inputBamFilesVar, (String)"", (String)(cmdPrefix + this.getOptionParamatersStrAs$() + "-I ${_inputFile}  -O " + outTableFilesVar.$("${_i}")), (String)"BaseRecalibrator"));
    }
}

