/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.postprocessing.gatk;

import com.biotechvana.variantseq.jobs.GATKHelper;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class GATKApplyBQSRJob
extends ISWFJob {
    public static final String JOB_ID = "applyBQSR";
    public static final String JOB_NAME = "GATK - ApplyBQSR";
    public static final String INPUT_RECALIBRATION_REPORT = "INPUT_recalibration_report";
    public static final String INPUT_BAM_FILES = VariantAnaylsisVariableBag.INPUT_BAM_FILES;
    public static final String OUTPUT_BAM_FILES = VariantAnaylsisVariableBag.OUTPUT_BAM_FILES;
    public static final String APPLY_FIX_MISENCODEDBQREADS = "APPLY_FIX_MISENCODEDBQREADS";

    public GATKApplyBQSRJob() {
        super(JOB_ID, JOB_NAME);
        GATKHelper.addToolGroup(this.jobDesc);
        this.jobDesc.setDesc("Apply base quality score recalibration\nApplyBQSR tool performs the second pass in a two-stage process called Base Quality Score Recalibration (BQSR). Specifically, it recalibrates the base qualities of the input reads based on the recalibration table produced by the BaseRecalibrator tool, and outputs a recalibrated BAM or CRAM file.");
        this.jobDesc.setRef(GATKHelper.getCitation(GATKHelper.getManualPage("ApplyBQSR", "org_broadinstitute_hellbender_tools_walkers_bqsr_ApplyBQSR.php")));
    }

    protected void createInputs() {
        VariableDescriptor varReadInputFile = GATKHelper.createInputBamFilesVar();
        this.jobDesc.addVariable(varReadInputFile);
        VariableDescriptor recalibratioTableOutputFiles = VariableDescriptor.createDescriptorFor((String)INPUT_RECALIBRATION_REPORT, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        recalibratioTableOutputFiles.isRequired = true;
        recalibratioTableOutputFiles.setVariableName("Recalibration Table report");
        recalibratioTableOutputFiles.setHelpMsg("Input recalibration table for BQSR this is the output of BaseRecalibrator tool.");
        this.jobDesc.addVariable(recalibratioTableOutputFiles);
        VariableDescriptor varReferenceFasta = GATKHelper.createReferenceVar();
        varReferenceFasta.isRequired = false;
        this.jobDesc.addVariable(varReferenceFasta);
        VariableDescriptor applyFixMisencodedBaseQualityReadsVar = VariableDescriptor.createDescriptorFor((String)APPLY_FIX_MISENCODEDBQREADS, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        applyFixMisencodedBaseQualityReadsVar.setVariableName("Apply FixMisencodedBaseQualityReads");
        applyFixMisencodedBaseQualityReadsVar.setHelpMsg("Run GATK-FixMisencodedBaseQualityReads to convert quality Phred scores from Phred64 to Phred33. Use this option if the input is in Phred64.");
        this.jobDesc.addVariable(applyFixMisencodedBaseQualityReadsVar);
    }

    protected void createOutputs() {
        VariableDescriptor bamOutputFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_BAM_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        bamOutputFile.isRequired = true;
        bamOutputFile.setVariableName("Recalibrated Bam Files");
        bamOutputFile.setHelpMsg("Recalibrated Bam Files");
        this.jobDesc.addVariable(bamOutputFile);
    }

    protected void createOptions() {
        GATKHelper.createSharedOptions(this.jobDesc);
    }

    protected void createRules() {
    }

    public boolean isValid() {
        boolean valid = super.isValid();
        return valid &= this.validateEqualNumberOfFiles(VariantAnaylsisVariableBag.INPUT_BAM_FILES, INPUT_RECALIBRATION_REPORT);
    }

    protected void generateCommand(StringBuilder builder) {
        String cmdPrefix = GATKHelper.getGATKCmdPrefix() + " ApplyBQSR " + GATKHelper.getTmpOption();
        FilesVariable inputBamFilesVar = (FilesVariable)this.getVariable(VariantAnaylsisVariableBag.INPUT_BAM_FILES);
        FilesVariable inputTableFilesVar = (FilesVariable)this.getVariable(INPUT_RECALIBRATION_REPORT);
        FilesVariable outBamFilesVar = (FilesVariable)this.getVariable(VariantAnaylsisVariableBag.OUTPUT_BAM_FILES);
        JobVariable refFileVar = this.getVariable(VariantAnaylsisVariableBag.INPUT_REF_FASTA);
        GATKHelper.checkPrepareReference(builder, refFileVar);
        builder.append(BashHelper.Batcher_noLog((FilesVariable)inputBamFilesVar, (String)GATKApplyBQSRJob.st((String)BashHelper.arrayAdd((JobVariable)outBamFilesVar, (String)"${outputFolder}/${inputFileBaseName}.bam")), (boolean)true));
        builder.append(BashHelper.BatcherParallelSingleton((FilesVariable)inputBamFilesVar, (String)"", (String)(cmdPrefix + this.getOptionParamatersStrAs$() + "-I ${_inputFile} --create-output-bam-index false -bqsr " + inputTableFilesVar.$("${_i}") + " -O " + outBamFilesVar.$("${_i}")), (String)"ApplyBQSR"));
    }
}

