/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.postprocessing.gatk;

import com.biotechvana.variantseq.jobs.GATKHelper;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashConditions;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class BaseScoreQualityRecalibrationJob
extends ISWFJob {
    public static final String JOB_ID = "BQSR";
    public static final String JOB_NAME = "BQSR";
    private static final String OUTPUT_RECALIBRATION_REPORT = "OUTPUT_recalibration_report";
    public static final String OUTPUT_BAM_FILES = VariantAnaylsisVariableBag.OUTPUT_BAM_FILES;
    public static final String INPUT_BAM_FILES = VariantAnaylsisVariableBag.INPUT_BAM_FILES;
    public static final String INPUT_KNOWN_SITES = "INPUT_KNOWN_SITES";
    public static final String APPLY_FIX_MISENCODEDBQREADS = "APPLY_FIX_MISENCODEDBQREADS";
    public static final String BaseRecalibration = "BaseRecalibration";
    public static final String ApplyBQSR = "ApplyBQSR";

    public BaseScoreQualityRecalibrationJob() {
        super("BQSR", "BQSR");
        GATKHelper.addToolGroup(this.jobDesc);
        this.jobDesc.setDesc("Apply Base quality score recalibration using GATK-BaseRecalibrator and ApplyBQSR");
        this.jobDesc.setRef(GATKHelper.getCitation(GATKHelper.getManualPage("BaseRecalibrator", "org_broadinstitute_hellbender_tools_walkers_bqsr_BaseRecalibrator.php") + "\n" + GATKHelper.getManualPage(ApplyBQSR, "org_broadinstitute_hellbender_tools_walkers_bqsr_ApplyBQSR.php")));
    }

    protected void createInputs() {
        VariableDescriptor varReferenceFasta = GATKHelper.createReferenceVar();
        this.jobDesc.addVariable(varReferenceFasta);
        VariableDescriptor varReadInputFile = GATKHelper.createInputBamFilesVar();
        this.jobDesc.addVariable(varReadInputFile);
        VariableDescriptor varKnownSites = GATKHelper.createKnownSitesVar();
        varKnownSites.setSubProgName(BaseRecalibration);
        this.jobDesc.addVariable(varKnownSites);
        VariableDescriptor applyFixMisencodedBaseQualityReadsVar = VariableDescriptor.createDescriptorFor((String)APPLY_FIX_MISENCODEDBQREADS, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        applyFixMisencodedBaseQualityReadsVar.setVariableName("Apply FixMisencodedBaseQualityReads");
        applyFixMisencodedBaseQualityReadsVar.setHelpMsg("Run GATK-FixMisencodedBaseQualityReads to convert quality Phred scores from Phred64 to Phred33. Use this option if the input is in Phred64.");
        this.jobDesc.addVariable(applyFixMisencodedBaseQualityReadsVar);
    }

    protected void createOutputs() {
        VariableDescriptor recalibratioTableOutputFiles = VariableDescriptor.createDescriptorFor((String)OUTPUT_RECALIBRATION_REPORT, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        recalibratioTableOutputFiles.isRequired = true;
        recalibratioTableOutputFiles.setVariableName("recalibration report");
        recalibratioTableOutputFiles.setHelpMsg("recalibration report");
        this.jobDesc.addVariable(recalibratioTableOutputFiles);
        VariableDescriptor recalibratioBamOutputFiles = VariableDescriptor.createDescriptorFor((String)OUTPUT_BAM_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        recalibratioBamOutputFiles.isRequired = true;
        recalibratioBamOutputFiles.setVariableName("Recalibrated Bam Files");
        recalibratioBamOutputFiles.setHelpMsg("Recalibrated Bam Files");
        this.jobDesc.addVariable(recalibratioBamOutputFiles);
    }

    protected void createOptions() {
        BaseScoreQualityRecalibrationJob.createOptionsBaseRecalibration(this.jobDesc, true);
        BaseScoreQualityRecalibrationJob.createOptionsApplyBQSR(this.jobDesc, true);
        BaseScoreQualityRecalibrationJob.createOptionsShared(this.jobDesc);
    }

    public static void createOptionsShared(JobDescriptor jobDesc) {
        GATKHelper.createSharedOptions(jobDesc);
        jobDesc.getVariableDescByCMDSwitch("-OQ").setDefaultValue("true");
        VariableDescriptor optionVar = GATKHelper.createOptionInterval();
        jobDesc.addVariable(optionVar);
        optionVar = GATKHelper.createOptionIntervalPadding();
        jobDesc.addVariable(optionVar);
        optionVar = GATKHelper.createOptionIntervalMergingRule();
        jobDesc.addVariable(optionVar);
        optionVar = GATKHelper.createOptionIntervalSetRule();
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Preserve Qscores less than");
        optionVar.setShortHelpMsg("Don't recalibrate bases with quality scores less than this threshold");
        optionVar.setHelpMsg("Don't recalibrate bases with quality scores less than this thresholdThis flag tells GATK not to modify quality scores less than this value. Instead they will be written out unmodified in the recalibrated BAM file. In general it's unsafe to change qualities scores below < 6, since base callers use these values to indicate random or bad bases. For example, Illumina writes Q2 bases when the machine has really gone wrong. This would be fine in and of itself, but when you select a subset of these reads based on their ability to align to the reference and their dinucleotide effect, your Q2 bin can be elevated to Q8 or Q10, leading to issues downstream.");
        optionVar.setCommandParamater("--preserve-qscores-less-than");
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Quantize quality");
        optionVar.setShortHelpMsg("Quantize quality scores to a given number of levels");
        optionVar.setHelpMsg("Quantize quality scores to a given number of levelsTurns on the base quantization module. It requires a recalibration report. A value of 0 here means \"do not quantize\". Any value greater than zero will be used to recalculate the quantization using that many levels. Negative values mean that we should quantize using the recalibration report's quantization level.");
        optionVar.setCommandParamater("--quantize-quals");
        jobDesc.addVariable(optionVar);
    }

    public static void createOptionsBaseRecalibration(JobDescriptor jobDesc, boolean setToolGroup) {
        VariableDescriptor optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Binary Tag Name");
        optionVar.setHelpMsg("The binary tag covariate name if using it");
        optionVar.setCommandParamater("--binary-tag-name");
        if (setToolGroup) {
            optionVar.setVariableGroup(BaseRecalibration);
        }
        optionVar.setSubProgName(BaseRecalibration);
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Default Base Qualities");
        optionVar.setShortHelpMsg("Assign a default base quality");
        optionVar.setHelpMsg("If reads are missing some or all base quality scores, this value will be used for all base quality scores. By default this is set to -1 to disable default base quality assignment. ");
        optionVar.setCommandParamater("--default-base-qualities");
        if (setToolGroup) {
            optionVar.setVariableGroup(BaseRecalibration);
        }
        optionVar.setSubProgName(BaseRecalibration);
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Deletions Default Quality");
        optionVar.setHelpMsg("Default quality for the base deletions covariate");
        optionVar.setHelpMsg("A default base qualities to use as a prior (reported quality) in the mismatch covariate model. This value will replace all base qualities in the read for this default value. Negative value turns it off. Default is 45");
        optionVar.setCommandParamater("--deletions-default-quality");
        if (setToolGroup) {
            optionVar.setVariableGroup(BaseRecalibration);
        }
        optionVar.setSubProgName(BaseRecalibration);
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Indels Context Size");
        optionVar.setHelpMsg("Size of the k-mer context to be used for base insertions and deletion");
        optionVar.setHelpMsg("The context covariate will use a context of this size to calculate its covariate value for base insertions and deletions. Must be between 1 and 13 (inclusive). Note that higher values will increase runtime and required java heap size. ");
        optionVar.setCommandParamater("-ics");
        optionVar.setCommandParamaterAlt("--indels-context-size");
        if (setToolGroup) {
            optionVar.setVariableGroup(BaseRecalibration);
        }
        optionVar.setSubProgName(BaseRecalibration);
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Insertions Default Quality");
        optionVar.setHelpMsg("Default quality for the base insertions covariate");
        optionVar.setHelpMsg("A default base qualities to use as a prior (reported quality) in the insertion covariate model. This parameter is used for all reads without insertion quality scores for each base. Default is 45");
        optionVar.setCommandParamater("--insertions-default-quality");
        if (setToolGroup) {
            optionVar.setVariableGroup(BaseRecalibration);
        }
        optionVar.setSubProgName(BaseRecalibration);
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Low Quality Tail");
        optionVar.setHelpMsg("minimum quality for the bases in the tail of the reads to be considered");
        optionVar.setHelpMsg("Reads with low quality bases on either tail (beginning or end) will not be considered in the context. This parameter defines the quality below which (inclusive) a tail is considered low quality. Default is 2");
        optionVar.setCommandParamater("--low-quality-tail");
        if (setToolGroup) {
            optionVar.setVariableGroup(BaseRecalibration);
        }
        optionVar.setSubProgName(BaseRecalibration);
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Maximum Covariate Cycle Value");
        optionVar.setHelpMsg("The maximum cycle value permitted for the Cycle covariate");
        optionVar.setHelpMsg("The cycle covariate will generate an error if it encounters a cycle greater than this value. This argument is ignored if the Cycle covariate is not used. Default is 500");
        optionVar.setCommandParamater("-max-cycle");
        optionVar.setCommandParamaterAlt("--maximum-cycle-value");
        if (setToolGroup) {
            optionVar.setVariableGroup(BaseRecalibration);
        }
        optionVar.setSubProgName(BaseRecalibration);
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Mismatches Context Size");
        optionVar.setHelpMsg("Size of the k-mer context to be used for base mismatches");
        optionVar.setHelpMsg("The context covariate will use a context of this size to calculate its covariate value for base mismatches. Must be between 1 and 13 (inclusive). Note that higher values will increase runtime and required java heap size. Default is 2");
        optionVar.setCommandParamater("-mcs");
        optionVar.setCommandParamaterAlt("--mismatches-context-size");
        if (setToolGroup) {
            optionVar.setVariableGroup(BaseRecalibration);
        }
        optionVar.setSubProgName(BaseRecalibration);
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Mismatches Default Quality");
        optionVar.setHelpMsg("Default quality for the base mismatches covariate");
        optionVar.setHelpMsg("A default base qualities to use as a prior (reported quality) in the mismatch covariate model. This value will replace all base qualities in the read for this default value. Negative value turns it off. Default is -1");
        optionVar.setCommandParamater("--mismatches-default-quality");
        if (setToolGroup) {
            optionVar.setVariableGroup(BaseRecalibration);
        }
        optionVar.setSubProgName(BaseRecalibration);
        jobDesc.addVariable(optionVar);
    }

    public static void createOptionsApplyBQSR(JobDescriptor jobDesc, boolean setToolGroup) {
        VariableDescriptor optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Addtional Argument File");
        optionVar.setHelpMsg("Read one or more arguments from the provied file");
        optionVar.setCommandParamater("--arguments_file");
        if (setToolGroup) {
            optionVar.setVariableGroup(ApplyBQSR);
        }
        optionVar.setSubProgName(ApplyBQSR);
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Emit Original Qualities");
        optionVar.setHelpMsg("Emit original base qualities under the OQ tag");
        optionVar.setCommandParamater("--emit-original-quals");
        if (setToolGroup) {
            optionVar.setVariableGroup(ApplyBQSR);
        }
        optionVar.setSubProgName(ApplyBQSR);
        jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Global Qscore Prior");
        optionVar.setHelpMsg("Global Qscore Bayesian prior to use for BQSR");
        optionVar.setCommandParamater("--global-qscore-prior");
        if (setToolGroup) {
            optionVar.setVariableGroup(ApplyBQSR);
        }
        optionVar.setSubProgName(ApplyBQSR);
        jobDesc.addVariable(optionVar);
    }

    protected void createRules() {
    }

    protected void generateCommand(StringBuilder builder) {
        String cmdPrefixBaseRecalibrator = GATKHelper.getGATKCmdPrefix() + " BaseRecalibrator " + GATKHelper.getTmpOption();
        String cmdPrefixApplyBQSR = GATKHelper.getGATKCmdPrefix() + " ApplyBQSR " + GATKHelper.getTmpOption();
        String cmdPrefixFixMisencodedBaseQualityReads = GATKHelper.getGATKCmdPrefix() + " FixMisencodedBaseQualityReads " + GATKHelper.getTmpOption();
        FilesVariable inputBamFilesVar = (FilesVariable)this.getVariable(VariantAnaylsisVariableBag.INPUT_BAM_FILES);
        FilesVariable outTableFilesVar = (FilesVariable)this.getVariable(OUTPUT_RECALIBRATION_REPORT);
        FilesVariable outBamFilesVar = (FilesVariable)this.getVariable(VariantAnaylsisVariableBag.OUTPUT_BAM_FILES);
        JobVariable refFileVar = this.getVariable(VariantAnaylsisVariableBag.INPUT_REF_FASTA);
        GATKHelper.checkPrepareReference(builder, refFileVar);
        FilesVariable knownSitesVariable = (FilesVariable)this.getVariable(INPUT_KNOWN_SITES);
        GATKHelper.checkPrepareKnownSitesIndex(builder, knownSitesVariable);
        builder.append(BashHelper.Batcher_noLog((FilesVariable)inputBamFilesVar, (String)(BaseScoreQualityRecalibrationJob.st((String)BashHelper.arrayAdd((JobVariable)outTableFilesVar, (String)"${outputFolder}/${inputFileBaseName}.table")) + BaseScoreQualityRecalibrationJob.st((String)BashHelper.arrayAdd((JobVariable)outBamFilesVar, (String)"${outputFolder}/${inputFileBaseName}.bam"))), (boolean)true));
        builder.append(BashHelper.If((String)BashConditions.True((JobVariable)this.getVariable(APPLY_FIX_MISENCODEDBQREADS))).Then(BashHelper.BatcherParallelSingleton((FilesVariable)inputBamFilesVar, (String)"", (String)BaseScoreQualityRecalibrationJob.st((String)(cmdPrefixFixMisencodedBaseQualityReads + "-I ${_inputFile}  -O ${outputFolder}/${inputFileBaseName}_FixBQ.bam")), (String)"FixMisencodedBaseQualityReads") + BashHelper.Batcher_noLog((FilesVariable)inputBamFilesVar, (String)BaseScoreQualityRecalibrationJob.st((String)BashHelper.assign((JobVariable)inputBamFilesVar, (String)"${_i}", (String)"${outputFolder}/${inputFileBaseName}_FixBQ.bam")), (boolean)true)));
        builder.append(BashHelper.BatcherParallelSingleton((FilesVariable)inputBamFilesVar, (String)"", (String)(cmdPrefixBaseRecalibrator + this.getOptionParamatersStrAs$() + this.getOptionParamatersStrAs$(BaseRecalibration) + "-I ${_inputFile}  -O " + outTableFilesVar.$("${_i}")), (String)"BaseRecalibrator"));
        builder.append(BashHelper.BatcherParallelSingleton((FilesVariable)inputBamFilesVar, (String)"", (String)(cmdPrefixApplyBQSR + this.getOptionParamatersStrAs$() + this.getOptionParamatersStrAs$(ApplyBQSR) + "-I ${_inputFile}  -bqsr " + outTableFilesVar.$("${_i}") + " -O " + outBamFilesVar.$("${_i}")), (String)ApplyBQSR));
    }
}

