/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.filtering.gatk;

import com.biotechvana.variantseq.jobs.GATKHelper;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class GATKVariantRecalibratorJob
extends ISWFJob {
    public static final String JOB_ID = "variantRecalibrator";
    public static final String JOB_NAME = "GATK - VariantRecalibrator";
    public static final String INPUT_VCF_FILES = "INPUT_VARIANTS_VCF";
    public static final String OUTPUT_RECAL_TABLE = "OUTPUT_RECAL_TABLE";
    public static final String INPUT_REF_FASTA = VariantAnaylsisVariableBag.INPUT_REF_FASTA;

    public GATKVariantRecalibratorJob() {
        super(JOB_ID, JOB_NAME);
        GATKHelper.addToolGroup(this.jobDesc);
        this.jobDesc.setDesc("Build a recalibration model to score variant quality for filtering purposes");
        this.jobDesc.setRef(GATKHelper.getCitation(GATKHelper.getManualPage("VariantRecalibrator", "org_broadinstitute_hellbender_tools_walkers_vqsr_VariantRecalibrator.php")));
    }

    protected void createInputs() {
        VariableDescriptor varReferenceFasta = GATKHelper.createReferenceVar();
        this.jobDesc.addVariable(varReferenceFasta);
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)INPUT_VCF_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input VCF Files");
        varReadInputFile.setHelpMsg("Input VCF Files.");
        varReadInputFile.addAcceptedFileFormat("VCF");
        this.jobDesc.addVariable(varReadInputFile);
    }

    protected void createOutputs() {
        VariableDescriptor variantOutputFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_RECAL_TABLE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        variantOutputFile.setVariableName("Output recalibration tables");
        variantOutputFile.setHelpMsg("Output recalibration tables");
        this.jobDesc.addVariable(variantOutputFile);
    }

    protected void createOptions() {
        GATKHelper.createSharedOptions(this.jobDesc);
    }

    protected void createRules() {
    }

    protected void generateCommand(StringBuilder builder) {
        String cmdPrefix = GATKHelper.getGATKCmdPrefix() + " VariantRecalibrator " + GATKHelper.getTmpOption();
        FilesVariable inputVCFFilesVar = (FilesVariable)this.getVariable(INPUT_VCF_FILES);
        FilesVariable outFilesVar = (FilesVariable)this.getVariable(OUTPUT_RECAL_TABLE);
        JobVariable refFileVar = this.getVariable(INPUT_REF_FASTA);
        String outputExt = ".vcf";
        GATKHelper.checkPrepareReference(builder, refFileVar);
    }
}

