/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.filtering.gatk;

import com.biotechvana.utils.FilenameUtils;
import com.biotechvana.variantseq.jobs.GATKHelper;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.CmdListMergeStrategy;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.StringsVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FileVariable;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;
import com.biotechvana.workflow.variables.StringsJobVariable;

public class GATKVariantQualityScoreRecalibrationJob
extends ISWFJob {
    public static final String JOB_ID = "VQSR";
    public static final String JOB_NAME = "GATK - Variant Quality Score Recalibration";
    static final String INTERNAL_TRANCHES_TABLE = "tranches_table";
    static final String INTERNAL_RECALIBRATION_TABLE = "recalibration_table";
    public static final String INPUT_VCF_FILES = "INPUT_VARIANTS_VCF";
    public static final String INPUT_RESOURCES_FILES = "RESOURCE_FILES";
    public static final String INPUT_RESOURCES_NAMES = "RESOURCE_NAMES";
    public static final String INPUT_RESOURCES_KNOWN = "RESOURCE_KNOWN";
    public static final String INPUT_RESOURCES_ISTRAINING = "RESOURCES_ISTRAINING";
    public static final String INPUT_RESOURCES_ISTRUTH = "RESOURCES_ISTRUTH";
    public static final String INPUT_RESOURCES_PRIOR = "RESOURCES_PRIOR";
    public static final String INPUT_ANNOTATIONS = "ANNOTATIONS";
    public static final String OUTPUT_VCF_FILES = "OUTPUT_VARIANTS_VCF";
    static final String VariantRecalibrator = "VariantRecalibrator";
    static final String ApplyVQSR = "ApplyVQSR";

    public GATKVariantQualityScoreRecalibrationJob() {
        super(JOB_ID, JOB_NAME);
        GATKHelper.addToolGroup(this.jobDesc);
        this.jobDesc.setDesc("Variant Quality Score Recalibration by using VariantRecalibrator to build a recalibration model to score variant quality, then use ApplyVQSR to apply a score cutoff based on the recalibration model.");
        this.jobDesc.setRef(GATKHelper.getCitation(GATKHelper.getManualPage(ApplyVQSR, "org_broadinstitute_hellbender_tools_walkers_vqsr_ApplyVQSR.php") + "\n" + GATKHelper.getManualPage(VariantRecalibrator, "org_broadinstitute_hellbender_tools_walkers_vqsr_VariantRecalibrator.php")));
    }

    protected void createInputs() {
        VariableDescriptor varReferenceFasta = GATKHelper.createReferenceVar();
        varReferenceFasta.isRequired = false;
        this.jobDesc.addVariable(varReferenceFasta);
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)INPUT_VCF_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input VCF Files");
        varReadInputFile.setHelpMsg("Input VCF Files.");
        varReadInputFile.addAcceptedFileFormat("VCF");
        this.jobDesc.addVariable(varReadInputFile);
        String RESOURCES_GROUP = "Resources";
        StringsVariableDescriptor varInputStrings = VariableDescriptor.Strings((String)INPUT_ANNOTATIONS, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varInputStrings.isRequired = true;
        varInputStrings.setVariableName("Annotations to use");
        varInputStrings.setHelpMsg("The names of the annotations which should used for calculations. See the input VCF file's INFO field for a list of all available annotations.");
        varInputStrings.setCommandParamater("--use-annotation");
        varInputStrings.setSubProgName("_NO_CMD_");
        varInputStrings.setCmdListMergeStrategy(CmdListMergeStrategy.Repeat);
        this.jobDesc.addVariable((VariableDescriptor)varInputStrings);
        VariableDescriptor varInput = VariableDescriptor.createDescriptorFor((String)INPUT_RESOURCES_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varInput.isRequired = true;
        varInput.setVariableName("Resources VCF input files");
        varInput.setShortHelpMsg("A list of sites for which to apply a prior probability of being correct but which aren't used by the algorithm (training and truth sets are required to run)");
        varInput.setHelpMsg("Any set of VCF files to use as lists of training, truth, or known sites. Training - The program builds the Gaussian mixture model using input variants that overlap with these training sites. Truth - The program uses these truth sites to determine where to set the cutoff in VQSLOD sensitivity. Known - The program only uses known sites for reporting purposes (to indicate whether variants are already known or novel). They are not used in any calculations by the algorithm itself. Bad - A database of known bad variants can be used to supplement the set of worst ranked variants (compared to the Gaussian mixture model) that the program selects from the data to model \"bad\" variants.");
        varInput.addAcceptedFileFormat("VCF");
        varInput.setCommandParamater("--resource");
        varInput.setSubProgName("_NO_CMD_");
        varInput.setVariableGroup(RESOURCES_GROUP);
        this.jobDesc.addVariable(varInput);
        varInput = VariableDescriptor.createDescriptorFor((String)INPUT_RESOURCES_NAMES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Strings, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varInput.isRequired = true;
        varInput.setVariableName("Resources Name");
        varInput.setHelpMsg("A short friendly Name for the input Resources VCF files.");
        varInput.setVariableGroup(RESOURCES_GROUP);
        this.jobDesc.addVariable(varInput);
        varInput = VariableDescriptor.createDescriptorFor((String)INPUT_RESOURCES_KNOWN, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Strings, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varInput.isRequired = true;
        varInput.setVariableName("Resources is Known Sites (true/false)");
        varInput.setHelpMsg("Resources is Known Sites. Known Sites are used by the program only for reporting purposes (to indicate whether variants are already known or novel).");
        varInput.setVariableGroup(RESOURCES_GROUP);
        this.jobDesc.addVariable(varInput);
        varInput = VariableDescriptor.createDescriptorFor((String)INPUT_RESOURCES_ISTRAINING, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Strings, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varInput.isRequired = true;
        varInput.setVariableName("Resources is training Sites");
        varInput.setHelpMsg("Resources is training Sites. Training sites are used by the program to build the Gaussian mixture model using input variants that overlap with these training sites.");
        varInput.setVariableGroup(RESOURCES_GROUP);
        this.jobDesc.addVariable(varInput);
        varInput = VariableDescriptor.createDescriptorFor((String)INPUT_RESOURCES_ISTRUTH, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Strings, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varInput.isRequired = true;
        varInput.setVariableName("Resources is Truth Sites (true/false)");
        varInput.setHelpMsg("Resources is Truth Sites. Truth Sites are used by the program to determine where to set the cutoff in VQSLOD sensitivity");
        varInput.setVariableGroup(RESOURCES_GROUP);
        this.jobDesc.addVariable(varInput);
        varInput = VariableDescriptor.createDescriptorFor((String)INPUT_RESOURCES_PRIOR, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Strings, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varInput.isRequired = true;
        varInput.setVariableName("Resources Prior");
        varInput.setHelpMsg("Resources Prior probability of being correct.");
        varInput.setVariableGroup(RESOURCES_GROUP);
        this.jobDesc.addVariable(varInput);
    }

    protected void createOutputs() {
        VariableDescriptor recalibratioTableOutputFiles = VariableDescriptor.createDescriptorFor((String)INTERNAL_RECALIBRATION_TABLE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Internal);
        recalibratioTableOutputFiles.setVariableName("Recalibration Table report");
        recalibratioTableOutputFiles.setHelpMsg("recalibration table for VQSR this is the output of VariantRecalibrator tool.");
        this.jobDesc.addVariable(recalibratioTableOutputFiles);
        VariableDescriptor tranchesTableOutputFiles = VariableDescriptor.createDescriptorFor((String)INTERNAL_TRANCHES_TABLE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Internal);
        tranchesTableOutputFiles.setVariableName("tranches Table report");
        tranchesTableOutputFiles.setHelpMsg("tranches table for VQSR this is the output of VariantRecalibrator tool.");
        this.jobDesc.addVariable(tranchesTableOutputFiles);
        VariableDescriptor bamOutputFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_VCF_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        bamOutputFile.isRequired = true;
        bamOutputFile.setVariableName("Recalibrated VCF Files");
        bamOutputFile.setHelpMsg("Recalibrated VCF Files");
        this.jobDesc.addVariable(bamOutputFile);
    }

    protected void createOptions() {
        VariableDescriptor optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Ignore all filters");
        optionaVar.setHelpMsg("If specified, the variant recalibrator will ignore all input filters. Useful to rerun the VQSR from a filtered output file.");
        optionaVar.setCommandParamater("--ignore-all-filters");
        this.jobDesc.addVariable(optionaVar);
        StringsVariableDescriptor optionaVarStrings = VariableDescriptor.Strings((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVarStrings.setVariableName("Filter to ignore");
        optionaVarStrings.setHelpMsg("If specified, the variant recalibrator will also use variants marked as filtered by the specified filter name in the input VCF file");
        optionaVarStrings.setCommandParamater("--ignore-filter");
        optionaVarStrings.setCmdListMergeStrategy(CmdListMergeStrategy.Repeat);
        this.jobDesc.addVariable((VariableDescriptor)optionaVarStrings);
        SelectionListVariableDescriptor optionaVarSelectionList = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVarSelectionList.setVariableName("Recalibration mode");
        optionaVarSelectionList.setHelpMsg("Recalibration mode to employ. This does not change the input VCF files. Default SNP");
        optionaVarSelectionList.setCommandParamater("--mode");
        optionaVarSelectionList.addOptionValue("SNP", "SNP", "Recalibrating only SNPs");
        optionaVarSelectionList.addOptionValue("INDEL", "INDEL", "Recalibrating only INDELs");
        this.jobDesc.addVariable((VariableDescriptor)optionaVarSelectionList);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Don't emit genotype fields when writing vcf file output");
        optionaVar.setCommandParamater("--sites-only-vcf-output");
        this.jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Use allele specific annotations");
        optionaVar.setHelpMsg("Recalibrator will attempt to use the allele-specific versions of the specified annotations");
        optionaVar.setCommandParamater("use-allele-specific-annotations");
        this.jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Additional raw input variants");
        optionaVar.setHelpMsg("Additional raw input variants to be used in building the model. These additional calls should be unfiltered and annotated with the error covariates that are intended to be used for modeling.");
        optionaVar.setCommandParamater("--aggregate");
        optionaVar.setCommandParamaterAlt("-aggregate");
        optionaVar.setVariableGroup(VariantRecalibrator);
        optionaVar.setSubProgName(VariantRecalibrator);
        this.jobDesc.addVariable(optionaVar);
        GATKHelper.createSharedOptions(this.jobDesc, GATKHelper.GATK_OPTION_SWITCH_ARGUMENTS_FILE, VariantRecalibrator);
        this.jobDesc.getVariableDescByCMDSwitch(GATKHelper.GATK_OPTION_SWITCH_ARGUMENTS_FILE).setSubProgName(VariantRecalibrator);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Expected novel Ti/Tv ratio");
        optionaVar.setHelpMsg("The expected novel Ti/Tv ratio to use when calculating FDR tranches and for display on the optimization curve output figures. (approx 2.15 for whole genome experiments). ONLY USED FOR PLOTTING PURPOSES!. Default 2.15");
        optionaVar.setCommandParamater("--target-titv");
        optionaVar.setCommandParamaterAlt("-titv");
        optionaVar.setVariableGroup(VariantRecalibrator);
        optionaVar.setSubProgName(VariantRecalibrator);
        this.jobDesc.addVariable(optionaVar);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Strings, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Truth sensitivity tranche");
        optionaVar.setHelpMsg("The levels of truth sensitivity at which to slice the data. (in percent, that is 1.0 for 1 percent). Default [100.0, 99.9, 99.0, 90.0]");
        optionaVar.setCommandParamater("--truth-sensitivity-tranche");
        optionaVar.setCommandParamaterAlt("-tranche");
        optionaVar.setVariableGroup(VariantRecalibrator);
        optionaVar.setSubProgName(VariantRecalibrator);
        this.jobDesc.addVariable(optionaVar);
        GATKHelper.createSharedOptions(this.jobDesc, GATKHelper.GATK_OPTION_SWITCH_ARGUMENTS_FILE, ApplyVQSR);
        this.jobDesc.getVariableDescByCMDSwitch(GATKHelper.GATK_OPTION_SWITCH_ARGUMENTS_FILE).setSubProgName(ApplyVQSR);
        optionaVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionaVar.setVariableName("Truth sensitivity tranche");
        optionaVar.setHelpMsg("The truth sensitivity level at which to start filtering. Default null");
        optionaVar.setCommandParamater("--truth-sensitivity-filter-level");
        optionaVar.setCommandParamaterAlt("-ts-filter-level");
        optionaVar.setVariableGroup(ApplyVQSR);
        optionaVar.setSubProgName(ApplyVQSR);
        this.jobDesc.addVariable(optionaVar);
        GATKHelper.createSharedOptions(this.jobDesc, new String[]{GATKHelper.GATK_OPTION_SWITCH_INTERVALS_MERGING_RULE, GATKHelper.GATK_OPTION_SWITCH_INTERVALS, GATKHelper.GATK_OPTION_SWITCH_CREATE_BAM_MD5, GATKHelper.GATK_OPTION_SWITCH_CREATE_VCF_MD5, GATKHelper.GATK_OPTION_SWITCH_EXCLUDE_INTERVALS, GATKHelper.GATK_OPTION_SWITCH_GATK_CONFIG_FILE, GATKHelper.GATK_OPTION_SWITCH_INTERVALS_EXCLUSION_PADDING, GATKHelper.GATK_OPTION_SWITCH_INTERVALS_PADDING, GATKHelper.GATK_OPTION_SWITCH_INTERVALS_SET_RULE, GATKHelper.GATK_OPTION_SWITCH_LENIENT, GATKHelper.GATK_OPTION_SWITCH_READ_VALIDATION_STRINGENCY});
    }

    protected void createRules() {
    }

    public boolean isValid() {
        String value;
        boolean valid = super.isValid();
        valid &= this.validateEqualNumberOfFiles(INPUT_RESOURCES_FILES, INPUT_RESOURCES_ISTRAINING);
        valid &= this.validateEqualNumberOfFiles(INPUT_RESOURCES_FILES, INPUT_RESOURCES_ISTRUTH);
        valid &= this.validateEqualNumberOfFiles(INPUT_RESOURCES_FILES, INPUT_RESOURCES_KNOWN);
        valid &= this.validateEqualNumberOfFiles(INPUT_RESOURCES_FILES, INPUT_RESOURCES_NAMES);
        valid &= this.validateEqualNumberOfFiles(INPUT_RESOURCES_FILES, INPUT_RESOURCES_PRIOR);
        StringsJobVariable varList = (StringsJobVariable)this.getVariable(INPUT_RESOURCES_ISTRUTH);
        String[] values = varList.getStringsList();
        boolean valuesIsValid = true;
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            value = stringArray[n2];
            if (!value.equals("true") && !value.equals("false")) {
                valuesIsValid = false;
                varList.setExternalErrMsg(value + " is not a vaild value for this paramter. Only true or false are accepted.");
                return false;
            }
            ++n2;
        }
        valuesIsValid = false;
        stringArray = values;
        n = values.length;
        n2 = 0;
        while (n2 < n) {
            value = stringArray[n2];
            if (value.equals("true")) {
                valuesIsValid = true;
                break;
            }
            ++n2;
        }
        if (!valuesIsValid) {
            varList.setExternalErrMsg("At least one resource is required as Truth Sites.");
            return false;
        }
        varList = (StringsJobVariable)this.getVariable(INPUT_RESOURCES_ISTRAINING);
        values = varList.getStringsList();
        valuesIsValid = true;
        stringArray = values;
        n = values.length;
        n2 = 0;
        while (n2 < n) {
            value = stringArray[n2];
            if (!value.equals("true") && !value.equals("false")) {
                valuesIsValid = false;
                varList.setExternalErrMsg(value + " is not a vaild value for this paramter. Only true or false are accepted.");
                return false;
            }
            ++n2;
        }
        valuesIsValid = false;
        stringArray = values;
        n = values.length;
        n2 = 0;
        while (n2 < n) {
            value = stringArray[n2];
            if (value.equals("true")) {
                valuesIsValid = true;
                break;
            }
            ++n2;
        }
        if (!valuesIsValid) {
            varList.setExternalErrMsg("At least one resource is required as Training Sites.");
            return false;
        }
        varList = (StringsJobVariable)this.getVariable(INPUT_RESOURCES_KNOWN);
        values = varList.getStringsList();
        valuesIsValid = true;
        stringArray = values;
        n = values.length;
        n2 = 0;
        while (n2 < n) {
            value = stringArray[n2];
            if (!value.equals("true") && !value.equals("false")) {
                valuesIsValid = false;
                varList.setExternalErrMsg(value + " is not a vaild value for this paramter. Only true or false are accepted.");
                return false;
            }
            ++n2;
        }
        varList = (StringsJobVariable)this.getVariable(INPUT_RESOURCES_PRIOR);
        values = varList.getStringsList();
        valuesIsValid = true;
        stringArray = values;
        n = values.length;
        n2 = 0;
        while (n2 < n) {
            value = stringArray[n2];
            try {
                Double.parseDouble(value);
            }
            catch (Exception e) {
                valuesIsValid = false;
                varList.setExternalErrMsg(value + " is not a vaild value for this paramter. Only Decimal Numbers are accepted.");
                return false;
            }
            ++n2;
        }
        varList = (StringsJobVariable)this.getVariableByCMDSwitch("--truth-sensitivity-tranche");
        valuesIsValid = true;
        stringArray = values;
        n = values.length;
        n2 = 0;
        while (n2 < n) {
            value = stringArray[n2];
            try {
                Double.parseDouble(value);
            }
            catch (Exception e) {
                valuesIsValid = false;
                varList.setExternalErrMsg(value + " is not a vaild value for this paramter. Only Decimal Numbers are accepted.");
                return false;
            }
            ++n2;
        }
        return valid;
    }

    public boolean notifyVarValueChanged(String varKey, String value) {
        try {
            if (varKey.equals(INPUT_RESOURCES_FILES)) {
                int i;
                FileVariable filesVar = (FileVariable)this.getVariable(INPUT_RESOURCES_FILES);
                String[] files = filesVar.getFilesList();
                StringsJobVariable varList = (StringsJobVariable)this.getVariable(INPUT_RESOURCES_NAMES);
                String[] values = varList.getStringsList();
                if (values.length < files.length) {
                    i = values.length;
                    while (i < files.length) {
                        String newFileName = FilenameUtils.getBasename((String)files[i]);
                        varList.addString(newFileName);
                        ++i;
                    }
                }
                if ((values = (varList = (StringsJobVariable)this.getVariable(INPUT_RESOURCES_ISTRAINING)).getStringsList()).length < files.length) {
                    i = values.length;
                    while (i < files.length) {
                        varList.addString("false");
                        ++i;
                    }
                }
                if ((values = (varList = (StringsJobVariable)this.getVariable(INPUT_RESOURCES_KNOWN)).getStringsList()).length < files.length) {
                    i = values.length;
                    while (i < files.length) {
                        varList.addString("false");
                        ++i;
                    }
                }
                if ((values = (varList = (StringsJobVariable)this.getVariable(INPUT_RESOURCES_ISTRUTH)).getStringsList()).length < files.length) {
                    i = values.length;
                    while (i < files.length) {
                        varList.addString("false");
                        ++i;
                    }
                }
                if ((values = (varList = (StringsJobVariable)this.getVariable(INPUT_RESOURCES_PRIOR)).getStringsList()).length < files.length) {
                    i = values.length;
                    while (i < files.length) {
                        varList.addString("2.0");
                        ++i;
                    }
                }
            }
        }
        catch (Exception ex) {
            this.getVariable(INPUT_RESOURCES_FILES).setExternalErrMsg("Can not add new File" + ex.getMessage());
        }
        return true;
    }

    protected void generateCommand(StringBuilder builder) {
        String applyVQSRCmdPrefix = GATKHelper.getGATKCmdPrefix() + " ApplyVQSR " + GATKHelper.getTmpOption();
        String variantRecalibratorCmdPrefix = GATKHelper.getGATKCmdPrefix() + " VariantRecalibrator " + GATKHelper.getTmpOption();
        FilesVariable inputVCFFilesVar = (FilesVariable)this.getVariable(INPUT_VCF_FILES);
        FilesVariable recalibrationTableFilesVar = (FilesVariable)this.getVariable(INTERNAL_RECALIBRATION_TABLE);
        FilesVariable tranchesTableFilesVar = (FilesVariable)this.getVariable(INTERNAL_TRANCHES_TABLE);
        FilesVariable outVCFFilesVar = (FilesVariable)this.getVariable(OUTPUT_VCF_FILES);
        FilesVariable resourcesFilesVar = (FilesVariable)this.getVariable(INPUT_RESOURCES_FILES);
        JobVariable annotationsVar = this.getVariable(INPUT_ANNOTATIONS);
        JobVariable refFileVar = this.getVariable(VariantAnaylsisVariableBag.INPUT_REF_FASTA);
        GATKHelper.checkPrepareReference(builder, refFileVar);
        String resourceCMDStr = "resourceCMDStr";
        JobVariable resNamesVar = this.getVariable(INPUT_RESOURCES_NAMES);
        JobVariable resiSTrainingVar = this.getVariable(INPUT_RESOURCES_ISTRAINING);
        JobVariable resiSTruthVar = this.getVariable(INPUT_RESOURCES_ISTRUTH);
        JobVariable resKnownVar = this.getVariable(INPUT_RESOURCES_KNOWN);
        JobVariable resPriorVar = this.getVariable(INPUT_RESOURCES_PRIOR);
        String _i = "${_i}";
        builder.append(GATKVariantQualityScoreRecalibrationJob.st((String)BashHelper.assign((String)resourceCMDStr, (String)"")));
        builder.append(BashHelper.Batcher_noLog((FilesVariable)resourcesFilesVar, (String)GATKVariantQualityScoreRecalibrationJob.st((String)BashHelper.assign((String)resourceCMDStr, (String)(GATKVariantQualityScoreRecalibrationJob.$((String)resourceCMDStr) + " --resource:" + resNamesVar.$(_i) + ",known=" + resKnownVar.$(_i) + ",training=" + resiSTrainingVar.$(_i) + ",truth=" + resiSTruthVar.$(_i) + ",prior=" + resPriorVar.$(_i) + " ${_inputFile}"))), (boolean)true));
        builder.append(GATKVariantQualityScoreRecalibrationJob.st((String)("echo " + GATKVariantQualityScoreRecalibrationJob.$((String)resourceCMDStr))));
        builder.append(BashHelper.Batcher_noLog((FilesVariable)inputVCFFilesVar, (String)(GATKVariantQualityScoreRecalibrationJob.st((String)BashHelper.arrayAdd((JobVariable)recalibrationTableFilesVar, (String)"${outputFolder}/${inputFileBaseName}.recal")) + GATKVariantQualityScoreRecalibrationJob.st((String)BashHelper.arrayAdd((JobVariable)tranchesTableFilesVar, (String)"${outputFolder}/${inputFileBaseName}.tranches")) + GATKVariantQualityScoreRecalibrationJob.st((String)BashHelper.arrayAdd((JobVariable)outVCFFilesVar, (String)"${outputFolder}/${inputFileBaseName}.vcf"))), (boolean)true));
        builder.append(BashHelper.BatcherParallelSingleton((FilesVariable)inputVCFFilesVar, (String)"", (String)(variantRecalibratorCmdPrefix + this.getOptionParamatersStrAs$() + this.getOptionParamatersStrAs$(VariantRecalibrator) + " -V  ${_inputFile} " + GATKVariantQualityScoreRecalibrationJob.$((String)resourceCMDStr) + " --rscript-file ${outputFolder}/${inputFileBaseName}.plots.R  " + BashHelper.hlpCmdSwitchAppend((JobVariable)annotationsVar, (String)"-an", (String)" ") + " -O " + recalibrationTableFilesVar.$("${_i}") + " --tranches-file " + tranchesTableFilesVar.$("${_i}")), (String)VariantRecalibrator));
        builder.append(BashHelper.BatcherParallelSingleton((FilesVariable)inputVCFFilesVar, (String)"", (String)(applyVQSRCmdPrefix + this.getOptionParamatersStrAs$() + this.getOptionParamatersStrAs$(ApplyVQSR) + " -V ${_inputFile}  -recal-file " + recalibrationTableFilesVar.$("${_i}") + " --tranches-file " + tranchesTableFilesVar.$("${_i}") + " -O " + outVCFFilesVar.$("${_i}")), (String)ApplyVQSR));
    }
}

