/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.filtering.gatk;

import com.biotechvana.variantseq.jobs.GATKHelper;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.VariablesRule;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashConditions;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class GATKCreateSomaticPanelOfNormalsJob
extends ISWFJob {
    public static final String JOB_ID = "createSomaticPON";
    public static final String JOB_NAME = "GATK - CreateSomaticPanelOfNormals";
    public static final String INPUT_NORMAL_BAM_FILES = "NORMAL_BAM";
    public static final String INPUT_NORMAL_VCF_FILES = "INPUT_VARIANTS_VCF";
    public static final String OUTPUT_PON_FILE = "PONsFile";
    public static final String INPUT_REF_FASTA = VariantAnaylsisVariableBag.INPUT_REF_FASTA;
    public static final String CREATE_MODE = "createMode";
    public static final String CREATE_MODE_BAM = "BAM";
    public static final String CREATE_MODE_VCF = "VCF";

    public GATKCreateSomaticPanelOfNormalsJob() {
        super(JOB_ID, JOB_NAME);
        GATKHelper.addToolGroup(this.jobDesc);
        this.jobDesc.setDesc("Make a panel of normals for use with Mutect2");
        GATKHelper.getCitation(this.jobDesc);
        this.jobDesc.addPublication(GATKHelper.getCitationNBT2514());
        this.jobDesc.addLink(GATKHelper.getManualLink("CreateSomaticPanelOfNormals", "org_broadinstitute_hellbender_tools_walkers_mutect_CreateSomaticPanelOfNormals.php"));
    }

    protected void createInputs() {
        VariableDescriptor varReferenceFasta = GATKHelper.createReferenceVar();
        this.jobDesc.addVariable(varReferenceFasta);
        SelectionListVariableDescriptor modeVar = VariableDescriptor.SelectionList((String)CREATE_MODE, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        modeVar.isRequired = true;
        modeVar.setVariableName("Input File Type");
        modeVar.setHelpMsg("If the input files are Bam, first run Mutect2 in Tumor Only mode with the default parameters, otherwise you can run mutect2 separately and provide here VCF files.");
        modeVar.addOptionValue(CREATE_MODE_VCF, CREATE_MODE_VCF, "Normal Input to CreateSomaticPanelOfNormals");
        modeVar.addOptionValue(CREATE_MODE_BAM, CREATE_MODE_BAM, "If provided BAM Input, will run Mutect2's tumor-only mode first then CreateSomaticPanelOfNormals");
        modeVar.setDefaultIndexValue(0);
        this.jobDesc.addVariable((VariableDescriptor)modeVar);
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)INPUT_NORMAL_VCF_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input Normal Files");
        varReadInputFile.setHelpMsg("Input Files of normal samples. (VCF or BAM formats)");
        this.jobDesc.addVariable(varReadInputFile);
        varReadInputFile = VariableDescriptor.createDescriptorFor((String)INPUT_NORMAL_BAM_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input Normal Files");
        varReadInputFile.setHelpMsg("Input Files of normal samples. (VCF or BAM formats)");
        this.jobDesc.addVariable(varReadInputFile);
    }

    protected void createOutputs() {
        VariableDescriptor variantOutputFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_PON_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        variantOutputFile.setVariableName("Filtered Variants vcf");
        variantOutputFile.setHelpMsg("variant calls output vcf files");
        this.jobDesc.addVariable(variantOutputFile);
    }

    protected void createOptions() {
        SelectionListVariableDescriptor optionVarSelectionList = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVarSelectionList.setVariableName("Duplicate Sample Strategy");
        optionVarSelectionList.setHelpMsg("How to handle duplicate sample");
        optionVarSelectionList.addOptionValue("THROW_ERROR", "THROW_ERROR", "Throw error to fail");
        optionVarSelectionList.addOptionValue("CHOOSE_FIRST", "CHOOSE_FIRST", "Use the first vcf with each sample name");
        optionVarSelectionList.addOptionValue("ALLOW_ALL", "ALLOW_ALL", "Use all samples regardless of duplicate sample names");
        optionVarSelectionList.setCommandParamater("--duplicate-sample-strategy");
        this.jobDesc.addVariable((VariableDescriptor)optionVarSelectionList);
        VariableDescriptor optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Min Sample Count");
        optionVar.setHelpMsg("Number of samples containing a variant site required to include it in the panel of normals. Default is 2");
        optionVar.setCommandParamater("--min-sample-count");
        this.jobDesc.addVariable(optionVar);
    }

    protected void createRules() {
        new VariablesRule(this.getVariable(CREATE_MODE), this.getVariable(INPUT_NORMAL_BAM_FILES), VariablesRule.Condition.EqualTo, VariablesRule.Action.Enable, CREATE_MODE_BAM, true);
        new VariablesRule(this.getVariable(CREATE_MODE), this.getVariable(INPUT_NORMAL_VCF_FILES), VariablesRule.Condition.EqualTo, VariablesRule.Action.Enable, CREATE_MODE_VCF, true);
    }

    protected void generateCommand(StringBuilder builder) {
        String cmdPrefix = GATKHelper.getGATKCmdPrefix() + " CreateSomaticPanelOfNormals " + GATKHelper.getTmpOption();
        String mutect2CmdPrefix = GATKHelper.getGATKCmdPrefix() + " Mutect2 " + GATKHelper.getTmpOption();
        FilesVariable inputBamFilesVar = (FilesVariable)this.getVariable(INPUT_NORMAL_BAM_FILES);
        FilesVariable vcfFilesVar = (FilesVariable)this.getVariable(INPUT_NORMAL_VCF_FILES);
        FilesVariable ponFileVar = (FilesVariable)this.getVariable(OUTPUT_PON_FILE);
        JobVariable refFileVar = this.getVariable(INPUT_REF_FASTA);
        GATKHelper.checkPrepareReference(builder, refFileVar);
        builder.append(GATKCreateSomaticPanelOfNormalsJob.st((String)BashHelper.assign((JobVariable)ponFileVar, (String)"pon.vcf")));
        builder.append(BashHelper.If((String)BashConditions.Equal((String)CREATE_MODE, (String)CREATE_MODE_BAM)).Then(BashHelper.BatcherParallelSingleton((FilesVariable)inputBamFilesVar, (String)GATKCreateSomaticPanelOfNormalsJob.st((String)BashHelper.arrayAdd((JobVariable)vcfFilesVar, (String)"${outputFolder}/${inputFileBaseName}_pon.vcf")), (String)(GATKCreateSomaticPanelOfNormalsJob.st((String)BashHelper.assign((String)"sampleTumorName", (String)("$(getSamRG " + inputBamFilesVar.$("${_i}") + " )"))) + mutect2CmdPrefix + "-I ${_inputFile} -tumor ${sampleTumorName}  -O " + vcfFilesVar.$("${_i}")), (String)"Mutect2 Tumor-Mode Only")));
        builder.append(BashHelper.command_withTrack((String)BashHelper.hlpArrAppend((JobVariable)vcfFilesVar, (String)","), (String)(cmdPrefix + this.getOptionParamatersStrAs$() + BashHelper.hlpCmdSwitchAppend((JobVariable)vcfFilesVar, (String)"-vcfs", (String)" ") + " -O ${outputFolder}/pon.vcf"), (String)"CreateSomaticPanelOfNormals"));
    }
}

